/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.common.entities.JustDireAreaEffectCloud;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class JustDireArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_POTIONARROW = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SPLASH = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_LINGERING = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_HOMING = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOSTILE_ONLY = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ARROW_STATE = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE_TICK_COUNTER = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> ORIGINAL_VELOCITY = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> IS_EPIC_ARROW = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_PHASE = SynchedEntityData.defineId(JustDireArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int SLOW_DOWN_DURATION = 4;
    private static final int STOP_DURATION = 10;
    private static final int MAX_TARGETS = 10;
    private static final byte EVENT_POTION_PUFF = 0;
    private boolean canHitMobs = true;
    private LivingEntity targetEntity;

    public JustDireArrow(EntityType<? extends AbstractArrow> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_);
    }

    public JustDireArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack itemStack) {
        super((EntityType)Registration.JustDireArrow.get(), x, y, z, level, pickupItemStack, itemStack);
        this.updateColor();
    }

    public JustDireArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack itemStack) {
        super((EntityType)Registration.JustDireArrow.get(), owner, level, pickupItemStack, itemStack);
        this.updateColor();
    }

    public PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    public void setPotionContents(PotionContents p_331534_) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, (Object)p_331534_);
        this.updateColor();
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected void setPickupItemStack(ItemStack p_331667_) {
        super.setPickupItemStack(p_331667_);
        this.updateColor();
    }

    private void updateColor() {
        PotionContents potioncontents = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, (Object)(potioncontents.equals((Object)PotionContents.EMPTY) ? -1 : potioncontents.getColor()));
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(effectInstance));
    }

    public void setPotionArrow(boolean potionArrow) {
        this.entityData.set(IS_POTIONARROW, (Object)potionArrow);
    }

    public void setSplash(boolean splash) {
        this.entityData.set(IS_SPLASH, (Object)splash);
    }

    public void setLingering(boolean lingering) {
        this.entityData.set(IS_LINGERING, (Object)lingering);
    }

    public void setHoming(boolean homing) {
        this.entityData.set(IS_HOMING, (Object)homing);
    }

    public void setPhase(boolean phase) {
        this.entityData.set(IS_PHASE, (Object)phase);
    }

    public boolean isPhase() {
        return (Boolean)this.entityData.get(IS_PHASE);
    }

    public float getOriginalVelocity() {
        return ((Float)this.entityData.get(ORIGINAL_VELOCITY)).floatValue();
    }

    public void setEpicArrow(boolean isEpicArrow) {
        this.entityData.set(IS_EPIC_ARROW, (Object)isEpicArrow);
        this.setPierceLevel((byte)5);
    }

    public boolean isEpic() {
        return (Boolean)this.entityData.get(IS_EPIC_ARROW);
    }

    public void setHostileOnly(boolean hostileOnly) {
        this.entityData.set(HOSTILE_ONLY, (Object)hostileOnly);
    }

    public boolean getHostileOnly() {
        return (Boolean)this.entityData.get(HOSTILE_ONLY);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326324_) {
        super.defineSynchedData(p_326324_);
        p_326324_.define(ID_EFFECT_COLOR, (Object)-1);
        p_326324_.define(IS_POTIONARROW, (Object)false);
        p_326324_.define(IS_SPLASH, (Object)false);
        p_326324_.define(IS_LINGERING, (Object)false);
        p_326324_.define(IS_HOMING, (Object)false);
        p_326324_.define(ARROW_STATE, (Object)ArrowState.NORMAL.ordinal());
        p_326324_.define(STATE_TICK_COUNTER, (Object)0);
        p_326324_.define(ORIGINAL_VELOCITY, (Object)Float.valueOf(0.0f));
        p_326324_.define(IS_EPIC_ARROW, (Object)false);
        p_326324_.define(IS_PHASE, (Object)false);
        p_326324_.define(HOSTILE_ONLY, (Object)true);
    }

    public static boolean isHostileEntity(LivingEntity entity) {
        if (entity instanceof Monster) {
            return true;
        }
        if (entity instanceof ZombifiedPiglin) {
            return ((ZombifiedPiglin)entity).isAngry();
        }
        return false;
    }

    public void setData(EntityDataAccessor<Integer> entityDataAccessor, int value) {
        if (!this.level().isClientSide) {
            this.entityData.set(entityDataAccessor, (Object)value);
        }
    }

    public void setData(EntityDataAccessor<Boolean> entityDataAccessor, boolean value) {
        if (!this.level().isClientSide) {
            this.entityData.set(entityDataAccessor, (Object)value);
        }
    }

    public double searchRadius() {
        return this.isEpic() ? 20.0 : 10.0;
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
        super.setDeltaMovement(deltaMovement);
    }

    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        if (!this.canHitMobs) {
            return null;
        }
        return super.findHitEntity(startVec, endVec);
    }

    public void setTargetEntity(LivingEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void tick() {
        this.noPhysics = this.isPhase();
        if (this.isPhase() && !this.level().isClientSide) {
            Vec3 vec33;
            if (this.tickCount >= 200) {
                this.discard();
                return;
            }
            this.canHitMobs = true;
            Vec3 vec32 = this.position();
            EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33 = vec32.add(this.getDeltaMovement()));
            if (entityhitresult != null) {
                this.onHit((HitResult)entityhitresult);
            }
            this.canHitMobs = false;
        }
        super.tick();
        if (this.isEpic() && this.targetEntity != null && this.wasAlreadyHit(this.targetEntity)) {
            this.targetEntity = this.findNearestEntity();
        }
        if (!this.level().isClientSide && this.getOriginalVelocity() == 0.0f) {
            this.entityData.set(ORIGINAL_VELOCITY, (Object)Float.valueOf((float)this.getDeltaMovement().length()));
        }
        if (this.targetEntity != null && !this.targetEntity.isAlive()) {
            if (!this.isEpic()) {
                this.discard();
            } else {
                this.targetEntity = this.findNearestEntity();
                if (this.targetEntity == null || !this.targetEntity.isAlive()) {
                    this.discard();
                }
            }
        }
        if (((Boolean)this.entityData.get(IS_HOMING)).booleanValue() && !this.inGround) {
            ArrowState currentState = ArrowState.values()[(Integer)this.entityData.get(ARROW_STATE)];
            if (currentState != ArrowState.NORMAL && this.targetEntity == null && this.tickCount > 5) {
                this.discard();
                return;
            }
            int stateTickCounter = (Integer)this.entityData.get(STATE_TICK_COUNTER);
            switch (currentState.ordinal()) {
                case 0: {
                    this.handleNormalState(stateTickCounter);
                    break;
                }
                case 1: {
                    this.handleSlowingDownState(stateTickCounter);
                    break;
                }
                case 2: {
                    this.handleStoppedAndRotatingState(stateTickCounter);
                    break;
                }
                case 3: {
                    this.handleResumingFlightState(stateTickCounter);
                }
            }
            this.setData(STATE_TICK_COUNTER, ++stateTickCounter);
        }
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.getPotionContents().equals((Object)PotionContents.EMPTY) && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.setPickupItemStack(new ItemStack((ItemLike)Items.ARROW));
        }
    }

    protected float getWaterInertia() {
        if (this.isPhase()) {
            return 1.0f;
        }
        return super.getWaterInertia();
    }

    private double calculateDotProduct(Vec3 vec1, Vec3 vec2) {
        return vec1.normalize().dot(vec2.normalize());
    }

    private void handleNormalState(int stateTickCounter) {
        if (this.targetEntity == null || !this.targetEntity.isAlive() || (double)this.targetEntity.distanceTo((Entity)this) > 20.0) {
            this.targetEntity = this.findNearestEntity();
        }
        if (this.targetEntity != null) {
            Vec3 arrowPosition = this.position();
            Vec3 targetPosition = this.targetEntity.getBoundingBox().getCenter();
            Vec3 directionToTarget = targetPosition.subtract(arrowPosition).normalize();
            Vec3 arrowDirection = this.getDeltaMovement().normalize();
            double dotProduct = this.calculateDotProduct(arrowDirection, directionToTarget);
            double distanceToTarget = this.position().distanceTo(targetPosition);
            if (dotProduct >= 0.85 || distanceToTarget < 1.0) {
                this.adjustCourseTowards(this.targetEntity);
            } else {
                this.setData(ARROW_STATE, ArrowState.SLOWING_DOWN.ordinal());
                this.setData(STATE_TICK_COUNTER, 0);
            }
        }
    }

    private void handleSlowingDownState(int stateTickCounter) {
        if (stateTickCounter < 4) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            this.setData(ARROW_STATE, ArrowState.STOPPED_AND_ROTATING.ordinal());
            this.setData(STATE_TICK_COUNTER, 0);
        }
    }

    private void handleStoppedAndRotatingState(int stateTickCounter) {
        this.setDeltaMovement(Vec3.ZERO);
        if (this.targetEntity != null && stateTickCounter != 0) {
            Vec3 arrowPosition = this.position();
            Vec3 targetCenterPosition = this.targetEntity.getBoundingBox().getCenter();
            Vec3 direction = targetCenterPosition.subtract(arrowPosition).normalize();
            double dx = direction.x;
            double dy = direction.y;
            double dz = direction.z;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            float targetYaw = (float)(Math.atan2(dx, dz) * 57.29577951308232);
            float targetPitch = (float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232);
            float currentYaw = this.getYRot();
            float currentPitch = this.getXRot();
            float yawDifference = this.wrapDegrees(targetYaw - currentYaw);
            float newYaw = currentYaw + yawDifference * 0.3f;
            float pitchDifference = this.wrapDegrees(targetPitch - currentPitch);
            float newPitch = currentPitch + pitchDifference * 0.3f;
            this.yRotO = currentYaw;
            this.xRotO = currentPitch;
            this.setYRot(newYaw);
            this.setXRot(newPitch);
        }
        if (stateTickCounter >= 10) {
            this.setData(ARROW_STATE, ArrowState.RESUMING_FLIGHT.ordinal());
            this.setData(STATE_TICK_COUNTER, 0);
            if (this.targetEntity != null) {
                this.adjustCourseTowards(this.targetEntity);
                Entity entity = this.getOwner();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.level().playSound(player, this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, SoundSource.PLAYERS, 1.0f, 0.5f);
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.25));
        }
    }

    private void handleResumingFlightState(int stateTickCounter) {
        if (this.getDeltaMovement().length() < (double)this.getOriginalVelocity()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.5));
        }
        if (this.getDeltaMovement().length() > (double)this.getOriginalVelocity()) {
            this.setDeltaMovement(this.getDeltaMovement().normalize().scale((double)this.getOriginalVelocity()));
        }
        if (this.targetEntity != null) {
            this.adjustCourseTowards(this.targetEntity);
        }
    }

    public void setYRot(float yRot) {
        if (yRot == 0.0f && this.getDeltaMovement().equals((Object)Vec3.ZERO)) {
            return;
        }
        if (this.isPhase()) {
            Vec3 delta = this.getDeltaMovement();
            if (yRot == (float)(Mth.atan2((double)(-delta.x), (double)(-delta.z)) * 180.0 / 3.1415927410125732)) {
                return;
            }
        }
        super.setYRot(yRot);
    }

    public void setXRot(float xRot) {
        if (xRot == 0.0f && this.getDeltaMovement().equals((Object)Vec3.ZERO)) {
            return;
        }
        super.setXRot(xRot);
    }

    private float wrapDegrees(float degrees) {
        if ((degrees %= 360.0f) >= 180.0f) {
            degrees -= 360.0f;
        }
        if (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }

    @Nullable
    private LivingEntity findNearestEntity() {
        double radius = this.searchRadius();
        AABB searchArea = this.getBoundingBox().inflate(radius, radius / 2.0, radius);
        List entities = this.level().getEntitiesOfClass(Mob.class, searchArea);
        Mob nearestEntity = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Mob entity : entities) {
            double distance;
            if (entity == this.getOwner() || !entity.isAlive() || this.wasAlreadyHit((LivingEntity)entity) || this.getHostileOnly() && !JustDireArrow.isHostileEntity((LivingEntity)entity) || !((distance = this.distanceToSqr((Entity)entity)) < nearestDistance)) continue;
            nearestEntity = entity;
            nearestDistance = distance;
        }
        return nearestEntity;
    }

    private boolean wasAlreadyHit(LivingEntity target) {
        if (!this.isEpic()) {
            return false;
        }
        if (this.piercingIgnoreEntityIds == null) {
            return false;
        }
        return this.piercingIgnoreEntityIds.contains(target.getId());
    }

    private void adjustCourseTowards(LivingEntity target) {
        Vec3 arrowPosition = this.position();
        Vec3 targetCenterPosition = target.getBoundingBox().getCenter();
        Vec3 direction = targetCenterPosition.subtract(arrowPosition).normalize();
        if (this.getDeltaMovement().equals((Object)Vec3.ZERO)) {
            this.setDeltaMovement(direction.scale((double)0.1f));
        } else {
            this.setDeltaMovement(direction.scale(this.getDeltaMovement().length()));
        }
        double dx = direction.x;
        double dy = direction.y;
        double dz = direction.z;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        this.setYRot((float)(Math.atan2(dx, dz) * 57.29577951308232));
        this.setXRot((float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private void makeParticle(int particleAmount) {
        int i = this.getColor();
        if (i != -1 && particleAmount > 0) {
            for (int j = 0; j < particleAmount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)i), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(ID_EFFECT_COLOR);
    }

    protected void onHit(HitResult result) {
        HitResult.Type hitresult$type = result.getType();
        if (this.isPhase() && hitresult$type == HitResult.Type.BLOCK) {
            return;
        }
        super.onHit(result);
        PotionContents potioncontents = this.getPotionContents();
        if (potioncontents.is(Potions.WATER)) {
            this.applyWater();
        } else if (potioncontents.hasEffects()) {
            if (((Boolean)this.entityData.get(IS_LINGERING)).booleanValue()) {
                this.makeAreaOfEffectCloud(potioncontents);
            }
            if (((Boolean)this.entityData.get(IS_SPLASH)).booleanValue()) {
                this.applySplash(potioncontents.getAllEffects(), result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null);
                int i = potioncontents.potion().isPresent() && ((Potion)((Holder)potioncontents.potion().get()).value()).hasInstantEffects() ? 2007 : 2002;
                this.level().levelEvent(i, this.blockPosition(), potioncontents.getColor());
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
    }

    public boolean isCurrentlyGlowing() {
        return this.isPhase();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (this.isEpic()) {
            this.setData(ARROW_STATE, ArrowState.STOPPED_AND_ROTATING.ordinal());
            this.setData(STATE_TICK_COUNTER, 0);
        }
    }

    private void applyWater() {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, aabb, ThrownPotion.WATER_SENSITIVE_OR_ON_FIRE)) {
            double d0 = this.distanceToSqr((Entity)livingentity);
            if (!(d0 < 16.0)) continue;
            if (livingentity.isSensitiveToWater()) {
                livingentity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), 1.0f);
            }
            if (!livingentity.isOnFire() || !livingentity.isAlive()) continue;
            livingentity.extinguishFire();
        }
        for (Axolotl axolotl : this.level().getEntitiesOfClass(Axolotl.class, aabb)) {
            axolotl.rehydrate();
        }
    }

    private void applySplash(Iterable<MobEffectInstance> p_330815_, @Nullable Entity p_37549_) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            Entity entity = this.getEffectSource();
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.isAffectedByPotions() || !((d0 = this.distanceToSqr((Entity)livingentity)) < 16.0)) continue;
                double d1 = livingentity == p_37549_ ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                for (MobEffectInstance mobeffectinstance : p_330815_) {
                    Holder holder = mobeffectinstance.getEffect();
                    if (((MobEffect)holder.value()).getCategory() == MobEffectCategory.HARMFUL && this.getOwner() != null && livingentity.is(this.getOwner()) || ((MobEffect)holder.value()).getCategory() == MobEffectCategory.BENEFICIAL && this.getOwner() != null && !livingentity.is(this.getOwner())) continue;
                    if (((MobEffect)holder.value()).isInstantenous()) {
                        ((MobEffect)holder.value()).applyInstantenousEffect((Entity)this, this.getOwner(), livingentity, mobeffectinstance.getAmplifier(), d1);
                        continue;
                    }
                    int i = mobeffectinstance.mapDuration(p_267930_ -> (int)(d1 * (double)p_267930_ + 0.5));
                    MobEffectInstance mobeffectinstance1 = new MobEffectInstance(holder, i, mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible());
                    if (mobeffectinstance1.endsWithin(20)) continue;
                    livingentity.addEffect(mobeffectinstance1, entity);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents p_332124_) {
        JustDireAreaEffectCloud areaeffectcloud = new JustDireAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            areaeffectcloud.setOwner(livingentity);
        }
        areaeffectcloud.setRadius(3.0f);
        areaeffectcloud.setRadiusOnUse(-0.1f);
        areaeffectcloud.setWaitTime(10);
        areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
        areaeffectcloud.setPotionContents(p_332124_);
        this.level().addFreshEntity((Entity)areaeffectcloud);
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        if (!((Boolean)this.entityData.get(IS_POTIONARROW)).booleanValue()) {
            return;
        }
        Entity entity = this.getEffectSource();
        PotionContents potioncontents = this.getPotionContents();
        if (potioncontents.potion().isPresent()) {
            for (MobEffectInstance mobeffectinstance : ((Potion)((Holder)potioncontents.potion().get()).value()).getEffects()) {
                if (((MobEffect)mobeffectinstance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && this.getOwner() != null && living.is(this.getOwner()) || ((MobEffect)mobeffectinstance.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL && this.getOwner() != null && !living.is(this.getOwner())) continue;
                living.addEffect(new MobEffectInstance(mobeffectinstance.getEffect(), Math.max(mobeffectinstance.mapDuration(p_268168_ -> p_268168_ / 2), 1), mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible()), entity);
            }
        }
        for (MobEffectInstance mobeffectinstance1 : potioncontents.customEffects()) {
            living.addEffect(mobeffectinstance1, entity);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i >> 0 & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("is_potionarrow", ((Boolean)this.entityData.get(IS_POTIONARROW)).booleanValue());
        pCompound.putBoolean("is_splash", ((Boolean)this.entityData.get(IS_SPLASH)).booleanValue());
        pCompound.putBoolean("is_lingering", ((Boolean)this.entityData.get(IS_LINGERING)).booleanValue());
        pCompound.putBoolean("is_homing", ((Boolean)this.entityData.get(IS_HOMING)).booleanValue());
        pCompound.putInt("arrow_state", ((Integer)this.entityData.get(ARROW_STATE)).intValue());
        pCompound.putInt("state_tick_counter", ((Integer)this.entityData.get(STATE_TICK_COUNTER)).intValue());
        pCompound.putFloat("original_velocity", ((Float)this.entityData.get(ORIGINAL_VELOCITY)).floatValue());
        pCompound.putBoolean("is_epic_arrow", ((Boolean)this.entityData.get(IS_EPIC_ARROW)).booleanValue());
        pCompound.putBoolean("is_phase", ((Boolean)this.entityData.get(IS_PHASE)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(IS_POTIONARROW, (Object)pCompound.getBoolean("is_potionarrow"));
        this.entityData.set(IS_SPLASH, (Object)pCompound.getBoolean("is_splash"));
        this.entityData.set(IS_LINGERING, (Object)pCompound.getBoolean("is_lingering"));
        this.entityData.set(IS_HOMING, (Object)pCompound.getBoolean("is_homing"));
        this.entityData.set(ARROW_STATE, (Object)pCompound.getInt("arrow_state"));
        this.entityData.set(STATE_TICK_COUNTER, (Object)pCompound.getInt("state_tick_counter"));
        this.entityData.set(ORIGINAL_VELOCITY, (Object)Float.valueOf(pCompound.getFloat("original_velocity")));
        this.entityData.set(IS_EPIC_ARROW, (Object)pCompound.getBoolean("is_epic_arrow"));
        this.entityData.set(IS_PHASE, (Object)pCompound.getBoolean("is_phase"));
    }

    private static enum ArrowState {
        NORMAL,
        SLOWING_DOWN,
        STOPPED_AND_ROTATING,
        RESUMING_FLIGHT;

    }
}

