/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks.resources;

import com.direwolf20.justdirethings.client.particles.glitterparticle.GlitterParticleData;
import com.direwolf20.justdirethings.common.blocks.resources.TimeCrystalCluster;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class TimeCrystalBuddingBlock
extends BuddingAmethystBlock {
    private static final Random rand = new Random();
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);

    public TimeCrystalBuddingBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.AMETHYST).randomTicks().strength(1.5f));
    }

    public int canAdvanceTo(Level level, BlockState state) {
        int stage = (Integer)state.getValue((Property)STAGE);
        if (stage == 0 && level.dimension() != Level.NETHER && level.dimension() != Level.END) {
            return 1;
        }
        if (stage == 1 && level.dimension() == Level.NETHER) {
            return 2;
        }
        if (stage == 2 && level.dimension() == Level.END) {
            return 3;
        }
        return -1;
    }

    public void advance(Level level, BlockState state, BlockPos pos, int advanceTo) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(advanceTo)));
        level.playSound(null, pos, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 0.25f);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int stage = (Integer)state.getValue((Property)STAGE);
        int advanceTo = this.canAdvanceTo((Level)level, state);
        if (advanceTo != -1) {
            this.advance((Level)level, state, pos, advanceTo);
        }
        if (stage != 3) {
            return;
        }
        if (random.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[random.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pos.relative(direction);
            BlockState blockstate = level.getBlockState(blockpos);
            Block block = null;
            if (TimeCrystalBuddingBlock.canClusterGrowAtState((BlockState)blockstate)) {
                block = (Block)Registration.TimeCrystalCluster_Small.get();
            } else if (blockstate.is((Block)Registration.TimeCrystalCluster_Small.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)Registration.TimeCrystalCluster_Medium.get();
            } else if (blockstate.is((Block)Registration.TimeCrystalCluster_Medium.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)Registration.TimeCrystalCluster_Large.get();
            } else if (blockstate.is((Block)Registration.TimeCrystalCluster_Large.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)Registration.TimeCrystalCluster.get();
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)TimeCrystalCluster.FACING, (Comparable)direction)).setValue((Property)TimeCrystalCluster.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                level.setBlockAndUpdate(blockpos, blockstate1);
                if ((Integer)state.getValue((Property)STAGE) == 3 && level.random.nextFloat() < 0.05f) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
                    level.playSound(null, pos, (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.BLOCKS, 1.0f, 0.25f);
                }
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float b;
        float g;
        float r;
        if ((Integer)state.getValue((Property)STAGE) == 3) {
            return;
        }
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.5;
        double d2 = (double)pos.getZ() + 0.5;
        int advanceTo = this.canAdvanceTo(level, state);
        if (advanceTo == -1) {
            return;
        }
        if (advanceTo == 1) {
            r = 0.25f;
            g = 0.55f;
            b = 1.0f;
        } else if (advanceTo == 2) {
            r = 1.0f;
            g = 0.33f;
            b = 0.0f;
        } else if (advanceTo == 3) {
            r = 0.4f;
            g = 1.0f;
            b = 0.5f;
        } else {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            double offsetX = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
            double offsetY = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
            double offsetZ = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
            double startX = (double)pos.getX() + offsetX;
            double startY = (double)pos.getY() + offsetY;
            double startZ = (double)pos.getZ() + offsetZ;
            float randomPartSize = 0.05f + -0.025f * rand.nextFloat();
            GlitterParticleData data = GlitterParticleData.playerparticle("glitter", d0, d1, d2, randomPartSize, r, g, b, 0.5f, 120.0f, false);
            level.addParticle((ParticleOptions)data, startX, startY, startZ, 0.025, (double)0.025f, 0.025);
        }
    }
}

