/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SensorT1BE
extends BaseMachineBE
implements FilterableBE {
    public FilterData filterData = new FilterData();
    protected List<BlockPos> positions = new ArrayList<BlockPos>();
    public SENSE_TARGET sense_target = SENSE_TARGET.BLOCK;
    public boolean emitRedstone = false;
    public boolean strongSignal = false;
    public boolean newlyLoaded = true;
    public Map<Integer, Map<Property<?>, Comparable<?>>> blockStateProperties = new HashMap();
    public final Map<BlockState, Boolean> blockStateFilterCache = new Object2BooleanOpenHashMap();
    public int senseAmount = 0;
    public int equality = 0;

    public SensorT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.ANYSIZE_FILTER_SLOTS = 1;
    }

    public SensorT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.SensorT1BE.get(), pPos, pBlockState);
    }

    public void addBlockStateProperty(int slot, Map<Property<?>, Comparable<?>> properties) {
        if (properties.isEmpty()) {
            this.blockStateProperties.remove(slot);
        } else {
            this.blockStateProperties.put(slot, properties);
        }
        this.blockStateFilterCache.clear();
        this.markDirtyClient();
    }

    public Map<Property<?>, Comparable<?>> getBlockStateProperties(int slot) {
        return this.blockStateProperties.getOrDefault(slot, new HashMap());
    }

    private static <T extends Comparable<T>> String getName(Property<T> pProperty, Comparable<?> pValue) {
        return pProperty.getName(pValue);
    }

    private static <T extends Comparable<T>> Comparable<T> getValue(Property<T> pProperty, String pValue) {
        Optional optional = pProperty.getValue(pValue);
        return optional.orElse(null);
    }

    public static ListTag saveBlockStateProperty(Map<Property<?>, Comparable<?>> propertiesList) {
        ListTag listTag = new ListTag();
        for (Map.Entry<Property<?>, Comparable<?>> value : propertiesList.entrySet()) {
            CompoundTag propertiesTag = new CompoundTag();
            propertiesTag.putString(value.getKey().getName(), SensorT1BE.getName(value.getKey(), value.getValue()));
            listTag.add((Object)propertiesTag);
        }
        return listTag;
    }

    public CompoundTag saveBlockStateProperties() {
        CompoundTag compoundTag = new CompoundTag();
        this.blockStateProperties.forEach((index, propertiesList) -> {
            ListTag listTag = SensorT1BE.saveBlockStateProperty(propertiesList);
            compoundTag.put(index.toString(), (Tag)listTag);
        });
        return compoundTag;
    }

    public static Map<Property<?>, Comparable<?>> loadBlockStateProperty(ListTag listTag, ItemStack stateStack) {
        HashMap propertiesMap;
        block3: {
            Item block;
            block2: {
                propertiesMap = new HashMap();
                Item item = stateStack.getItem();
                if (!(item instanceof BlockItem)) break block2;
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag propertiesTag = listTag.getCompound(i);
                    propertiesTag.getAllKeys().forEach(arg_0 -> SensorT1BE.lambda$loadBlockStateProperty$1((Block)block, propertiesTag, propertiesMap, arg_0));
                }
                break block3;
            }
            block = stateStack.getItem();
            if (!(block instanceof BucketItem)) break block3;
            BucketItem bucketItem = (BucketItem)block;
            BlockState defaultState = bucketItem.content.defaultFluidState().createLegacyBlock();
            Block block2 = defaultState.getBlock();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag propertiesTag = listTag.getCompound(i);
                propertiesTag.getAllKeys().forEach(propertyName -> {
                    String valueStr;
                    Comparable value;
                    Property property = block2.getStateDefinition().getProperty(propertyName);
                    if (property != null && (value = SensorT1BE.getValue(property, valueStr = propertiesTag.getString(propertyName))) != null) {
                        propertiesMap.put(property, value);
                    }
                });
            }
        }
        return propertiesMap;
    }

    public void loadBlockStateProperties(CompoundTag nbt) {
        this.blockStateProperties.clear();
        this.blockStateFilterCache.clear();
        nbt.getAllKeys().forEach(key -> {
            ItemStack stateStack;
            int index = Integer.parseInt(key);
            ListTag listTag = nbt.getList(key, 10);
            Map<Property<?>, Comparable<?>> propertiesList = SensorT1BE.loadBlockStateProperty(listTag, stateStack = this.getFilterHandler().getStackInSlot(index));
            if (!propertiesList.isEmpty()) {
                this.blockStateProperties.put(index, propertiesList);
            }
        });
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER_ANYSIZE));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    public void setSensorSettings(int senseTarget, boolean strongSignal, int senseAmount, int equality) {
        this.sense_target = SENSE_TARGET.values()[senseTarget];
        this.setRedstone(this.emitRedstone, strongSignal);
        this.senseAmount = senseAmount;
        this.equality = equality;
        this.positions.clear();
        this.blockStateFilterCache.clear();
        this.markDirtyClient();
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.newlyLoaded && this.level != null) {
            for (Direction direction : Direction.values()) {
                this.level.neighborChanged(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), this.getBlockPos());
                this.level.updateNeighborsAtExceptFromFacing(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), direction.getOpposite());
            }
            this.newlyLoaded = false;
        }
        this.sense();
    }

    public boolean canSense() {
        return true;
    }

    public void setRedstone(boolean emit, boolean strong) {
        if (emit != this.emitRedstone || strong != this.strongSignal || this.newlyLoaded) {
            this.emitRedstone = emit;
            this.strongSignal = strong;
            for (Direction direction : Direction.values()) {
                this.level.neighborChanged(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), this.getBlockPos());
                this.level.updateNeighborsAtExceptFromFacing(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), direction.getOpposite());
            }
        }
    }

    public boolean checkCount(int found) {
        if (this.equality == 0) {
            return found > this.senseAmount;
        }
        if (this.equality == 1) {
            return found < this.senseAmount;
        }
        if (this.equality == 2) {
            return found == this.senseAmount;
        }
        return found > this.senseAmount;
    }

    public void sense() {
        if (!this.canRun()) {
            return;
        }
        if (!this.canSense()) {
            return;
        }
        if (this.sense_target.equals((Object)SENSE_TARGET.BLOCK) || this.sense_target.equals((Object)SENSE_TARGET.AIR)) {
            if (this.positions.isEmpty()) {
                this.positions = this.findPositions();
            }
            if (this.positions.isEmpty()) {
                return;
            }
            Iterator<BlockPos> iterator = this.positions.iterator();
            int foundMatchingBlocks = 0;
            while (iterator.hasNext()) {
                if (this.senseBlock(iterator.next())) {
                    ++foundMatchingBlocks;
                }
                iterator.remove();
            }
            this.setRedstone(this.checkCount(foundMatchingBlocks), this.strongSignal);
        } else {
            List<Entity> entityList = this.findEntities(this.getAABB());
            this.setRedstone(this.senseEntity(entityList), this.strongSignal);
        }
    }

    public AABB getAABB() {
        return new AABB(this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)));
    }

    public List<Entity> findEntities(AABB aabb) {
        ArrayList<Entity> returnList = new ArrayList<Entity>(this.level.getEntitiesOfClass(Entity.class, aabb, this::isValidEntity));
        return returnList;
    }

    public boolean isValidEntity(Entity entity) {
        Animal animal;
        if (this.sense_target.equals((Object)SENSE_TARGET.HOSTILE) && !(entity instanceof Monster)) {
            return false;
        }
        if ((this.sense_target.equals((Object)SENSE_TARGET.PASSIVE) || this.sense_target.equals((Object)SENSE_TARGET.ADULT) || this.sense_target.equals((Object)SENSE_TARGET.CHILD)) && !(entity instanceof Animal)) {
            return false;
        }
        if (this.sense_target.equals((Object)SENSE_TARGET.ADULT) && entity instanceof Animal && (animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (this.sense_target.equals((Object)SENSE_TARGET.CHILD) && entity instanceof Animal && !(animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (this.sense_target.equals((Object)SENSE_TARGET.PLAYER) && !(entity instanceof Player)) {
            return false;
        }
        if (this.sense_target.equals((Object)SENSE_TARGET.ITEM) && !(entity instanceof ItemEntity)) {
            return false;
        }
        return this.isEntityValidFilter(entity, this.level);
    }

    public boolean senseEntity(List<Entity> entityList) {
        int entityAmount = entityList.size();
        return this.checkCount(entityAmount);
    }

    public boolean senseBlock(BlockPos blockPos) {
        BlockState blockState = this.level.getBlockState(blockPos);
        if (this.sense_target.equals((Object)SENSE_TARGET.AIR)) {
            return blockState.isAir();
        }
        if (blockState.isAir()) {
            return false;
        }
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return this.handleBlockStates(blockPos, blockState, liquidBlock);
        }
        return this.handleBlockStates(blockPos, blockState);
    }

    public boolean handleBlockStates(BlockPos blockPos, BlockState blockState, LiquidBlock liquidBlock) {
        ItemStack blockItemStack = new ItemStack((ItemLike)liquidBlock.fluid.getBucket());
        boolean allowList = this.filterData.allowlist;
        if (this.blockStateFilterCache.containsKey(blockState)) {
            return this.blockStateFilterCache.get(blockState);
        }
        boolean returnValue = this.isStackValidFilter(blockItemStack);
        block0: for (Map.Entry<Integer, Map<Property<?>, Comparable<?>>> propertyValues : this.blockStateProperties.entrySet()) {
            ItemStack filterStack = this.getFilterHandler().getStackInSlot(propertyValues.getKey());
            if (!ItemStack.isSameItemSameComponents((ItemStack)filterStack, (ItemStack)blockItemStack)) continue;
            for (Map.Entry<Property<?>, Comparable<?>> prop : propertyValues.getValue().entrySet()) {
                Comparable comparable = blockState.getValue(prop.getKey());
                boolean propertyMatch = comparable.equals(prop.getValue());
                if (allowList && propertyMatch || !allowList && !propertyMatch) {
                    returnValue = true;
                    continue;
                }
                returnValue = false;
                break block0;
            }
        }
        this.blockStateFilterCache.put(blockState, returnValue);
        return this.blockStateFilterCache.get(blockState);
    }

    public boolean handleBlockStates(BlockPos blockPos, BlockState blockState) {
        ItemStack blockItemStack = blockState.getBlock().getCloneItemStack((LevelReader)this.level, blockPos, blockState);
        boolean allowList = this.filterData.allowlist;
        if (this.blockStateFilterCache.containsKey(blockState)) {
            return this.blockStateFilterCache.get(blockState);
        }
        boolean returnValue = this.isStackValidFilter(blockItemStack);
        block0: for (Map.Entry<Integer, Map<Property<?>, Comparable<?>>> propertyValues : this.blockStateProperties.entrySet()) {
            ItemStack filterStack = this.getFilterHandler().getStackInSlot(propertyValues.getKey());
            if (!ItemStack.isSameItemSameComponents((ItemStack)filterStack, (ItemStack)blockItemStack)) continue;
            for (Map.Entry<Property<?>, Comparable<?>> prop : propertyValues.getValue().entrySet()) {
                Comparable comparable = blockState.getValue(prop.getKey());
                boolean propertyMatch = comparable.equals(prop.getValue());
                if (allowList && propertyMatch || !allowList && !propertyMatch) {
                    returnValue = true;
                    continue;
                }
                returnValue = false;
                break block0;
            }
        }
        this.blockStateFilterCache.put(blockState, returnValue);
        return this.blockStateFilterCache.get(blockState);
    }

    public boolean isBlockPosValid(BlockPos blockPos) {
        return true;
    }

    public List<BlockPos> findPositions() {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(blockPos)) {
            returnList.add(blockPos);
        }
        return returnList;
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (!this.sense_target.equals((Object)SENSE_TARGET.BLOCK)) {
            return false;
        }
        if (this.strongSignal) {
            return false;
        }
        if (!this.blockStateProperties.isEmpty()) {
            return false;
        }
        if (this.senseAmount != 0) {
            return false;
        }
        return this.equality == 0;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("senseTarget", this.sense_target.ordinal());
        tag.putBoolean("strongSignal", this.strongSignal);
        tag.put("blockStateProps", (Tag)this.saveBlockStateProperties());
        tag.putInt("senseAmount", this.senseAmount);
        tag.putInt("equality", this.equality);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.sense_target = SENSE_TARGET.values()[tag.getInt("senseTarget")];
        this.strongSignal = tag.getBoolean("strongSignal");
        this.senseAmount = tag.getInt("senseAmount");
        this.equality = tag.getInt("equality");
        super.loadAdditional(tag, provider);
        this.loadBlockStateProperties(tag.getCompound("blockStateProps"));
    }

    private static /* synthetic */ void lambda$loadBlockStateProperty$1(Block block, CompoundTag propertiesTag, Map propertiesMap, String propertyName) {
        String valueStr;
        Comparable value;
        Property property = block.getStateDefinition().getProperty(propertyName);
        if (property != null && (value = SensorT1BE.getValue(property, valueStr = propertiesTag.getString(propertyName))) != null) {
            propertiesMap.put(property, value);
        }
    }

    public static enum SENSE_TARGET {
        BLOCK,
        AIR,
        HOSTILE,
        PASSIVE,
        ADULT,
        CHILD,
        PLAYER,
        LIVING,
        ITEM;


        public SENSE_TARGET next() {
            SENSE_TARGET[] values = SENSE_TARGET.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }
    }
}

