/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.client.particles.glitterparticle.GlitterParticleData;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.JustDireFluidTank;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.entities.ParadoxEntity;
import com.direwolf20.justdirethings.common.network.data.ParadoxSyncPayload;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.datagen.JustDireEntityTags;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ParadoxMachineBE
extends BaseMachineBE
implements PoweredMachineBE,
AreaAffectingBE,
RedstoneControlledBE,
FluidMachineBE {
    public RedstoneControlData redstoneControlData = this.getDefaultRedstoneData();
    public final FluidContainerData fluidContainerData;
    public AreaAffectingData areaAffectingData = new AreaAffectingData((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
    public final PoweredMachineContainerData poweredMachineData;
    public CompoundTag snapshotData = new CompoundTag();
    public int savedBlocks = -1;
    public int savedEntities = -1;
    public int numBlocks = -1;
    public int numEntities = -1;
    public boolean renderParadox = false;
    public int targetType = 0;
    public boolean isRunning = false;
    public int timeRunning = 0;
    public int fePerTick = 0;
    public int fluidPerTick = 0;
    public float paradoxEnergy = 0.0f;
    public Map<BlockPos, BlockState> restoringBlocks = new HashMap<BlockPos, BlockState>();
    public List<Vec3> restoringEntites = new ArrayList<Vec3>();
    private static final Random random = new Random();

    public ParadoxMachineBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.ParadoxMachineBE.get(), pPos, pBlockState);
        this.poweredMachineData = new PoweredMachineContainerData(this);
        this.fluidContainerData = new FluidContainerData(this);
    }

    @Override
    public void tickClient() {
        if (this.isRunning) {
            if (this.level == null) {
                return;
            }
            ++this.timeRunning;
            for (Map.Entry<BlockPos, BlockState> entry : this.restoringBlocks.entrySet()) {
                this.drawRestoringParticles(entry.getKey().getCenter());
            }
            for (Vec3 vec3 : this.restoringEntites) {
                this.drawRestoringParticles(vec3);
            }
        }
    }

    public void drawRestoringParticles(Vec3 vec3) {
        double d0 = vec3.x;
        double d1 = vec3.y;
        double d2 = vec3.z;
        float r = 0.4f;
        float g = 1.0f;
        float b = 0.39f;
        double offsetX = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
        double offsetY = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
        double offsetZ = random.nextBoolean() ? -0.5 + random.nextDouble() * 0.5 : 1.0 + random.nextDouble() * 0.5;
        double startX = d0 - 0.5 + offsetX;
        double startY = d1 - 0.5 + offsetY;
        double startZ = d2 - 0.5 + offsetZ;
        float randomPartSize = 0.05f + -0.025f * random.nextFloat();
        GlitterParticleData data = GlitterParticleData.playerparticle("glitter", d0, d1, d2, randomPartSize, r, g, b, 1.0f, 120.0f, false);
        this.level.addParticle((ParticleOptions)data, startX, startY, startZ, 2.5E-4, (double)2.5E-4f, 2.5E-4);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doParadox();
        if (this.paradoxEnergy >= this.getMaxParadoxEnergy()) {
            this.spawnParadox();
        }
    }

    public int getRunTime() {
        if (!this.isRunning) {
            return 300;
        }
        return (this.restoringBlocks.size() + this.restoringEntites.size()) * 10;
    }

    public void receiveRunTime(int runtime) {
        this.timeRunning = runtime;
    }

    public float getParadoxEnergyPerBlock() {
        return ((Double)Config.PARADOX_ENERGY_PER_BLOCK.get()).floatValue();
    }

    public float getParadoxEnergyPerEntity() {
        return ((Double)Config.PARADOX_ENERGY_PER_ENTITY.get()).floatValue();
    }

    public float getMaxParadoxEnergy() {
        return ((Double)Config.PARADOX_ENERGY_MAX.get()).floatValue();
    }

    public void addParadoxEnergy(float amt) {
        this.paradoxEnergy = Math.min(this.getMaxParadoxEnergy(), this.paradoxEnergy + amt);
        this.markDirtyClient();
    }

    public void resetParadoxEnergy() {
        this.paradoxEnergy = 0.0f;
        this.markDirtyClient();
    }

    public void spawnParadox() {
        if (this.level == null) {
            return;
        }
        ParadoxEntity paradoxEntity = new ParadoxEntity(this.level, this.getStartingPoint());
        this.level.addFreshEntity((Entity)paradoxEntity);
        this.resetParadoxEnergy();
    }

    public boolean paradoxExists() {
        if (this.level == null) {
            return true;
        }
        List paradoxEntities = this.level.getEntitiesOfClass(ParadoxEntity.class, new AABB(this.getStartingPoint()));
        return !paradoxEntities.isEmpty();
    }

    public void startParadox() {
        if (!this.isActiveRedstone() || !this.canRun()) {
            return;
        }
        if (!this.canParadox()) {
            return;
        }
        if (this.paradoxExists()) {
            return;
        }
        if (!this.isRunning) {
            UsefulFakePlayer fakePlayer = this.getUsefulFakePlayer((ServerLevel)this.level);
            this.restoringBlocks = this.testRestoreBlocks(fakePlayer);
            this.restoringEntites = new ArrayList<Vec3>(this.getEntitiesFromNBT().keySet());
            if (this.restoringBlocks.isEmpty() && this.restoringEntites.isEmpty()) {
                return;
            }
            this.isRunning = true;
            this.fePerTick = this.getEnergyCostPerTick(this.getEnergyCost(this.restoringBlocks.size(), this.restoringEntites.size()));
            this.fluidPerTick = this.getFluidCostPerTick(this.getFluidCost(this.restoringBlocks.size(), this.restoringEntites.size()));
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, 0.25f);
            this.markDirtyClient();
        }
    }

    public void doParadox() {
        if (this.level == null) {
            return;
        }
        this.startParadox();
        if (!this.isRunning) {
            return;
        }
        if (this.timeRunning % 20 == 0 && this.timeRunning < this.getRunTime()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunk(this.getBlockPos()).getPos(), (CustomPacketPayload)new ParadoxSyncPayload(this.getBlockPos(), this.timeRunning), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.timeRunning % 100 == 0 && this.timeRunning < this.getRunTime()) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, 0.25f);
        }
        if (this.extractFluid(this.fluidPerTick) == this.fluidPerTick && this.extractEnergy(this.fePerTick, false) == this.fePerTick) {
            ++this.timeRunning;
        } else {
            this.stopRunning(false);
            return;
        }
        if (this.timeRunning >= this.getRunTime()) {
            this.stopRunning(true);
        }
    }

    public void stopRunning(boolean success) {
        if (success) {
            int finalFluidCost = this.getFluidCost(this.restoringBlocks.size(), this.restoringEntites.size()) - this.fluidPerTick * this.getRunTime();
            int finalEnergyCost = this.getEnergyCost(this.restoringBlocks.size(), this.restoringEntites.size()) - this.fePerTick * this.getRunTime();
            if (this.extractFluid(finalFluidCost) == finalFluidCost && this.extractEnergy(finalEnergyCost, false) == finalEnergyCost) {
                UsefulFakePlayer fakePlayer = this.getUsefulFakePlayer((ServerLevel)this.level);
                this.restoreBlocks(fakePlayer);
                this.addParadoxEnergy(this.getParadoxEnergyPerBlock() * (float)this.restoringBlocks.size());
                this.restoreEntities(fakePlayer);
                this.addParadoxEnergy(this.getParadoxEnergyPerEntity() * (float)this.restoringEntites.size());
                this.postRun();
                this.level.playSound(null, this.getBlockPos(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 0.5f, 0.25f);
            } else {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.CONDUIT_DEACTIVATE, SoundSource.BLOCKS, 0.5f, 0.25f);
            }
        } else {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.CONDUIT_DEACTIVATE, SoundSource.BLOCKS, 0.5f, 0.25f);
        }
        this.timeRunning = 0;
        this.isRunning = false;
        this.restoringBlocks.clear();
        this.restoringEntites.clear();
        this.fePerTick = 0;
        this.fluidPerTick = 0;
        this.markDirtyClient();
    }

    public boolean canPlace(FakePlayer fakePlayer, BlockPos blockPos) {
        if (!this.level.mayInteract((Player)fakePlayer, blockPos)) {
            return false;
        }
        if (!this.level.getBlockState(blockPos).canBeReplaced()) {
            return false;
        }
        return this.canPlaceAt(this.level, blockPos, fakePlayer);
    }

    private Map<BlockPos, BlockState> testRestoreBlocks(FakePlayer fakePlayer) {
        Map<BlockPos, BlockState> blocksToRestore = this.getBlocksFromNBT();
        HashMap<BlockPos, BlockState> returnMap = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : blocksToRestore.entrySet()) {
            BlockPos blockPos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (!this.canPlace(fakePlayer, blockPos)) continue;
            returnMap.put(blockPos, blockState);
        }
        return returnMap;
    }

    public boolean canPlace(BlockPos blockPos) {
        return this.level.getBlockState(blockPos).canBeReplaced();
    }

    public Map<BlockPos, BlockState> testRestoreBlocks() {
        Map<BlockPos, BlockState> blocksToRestore = this.getBlocksFromNBT();
        HashMap<BlockPos, BlockState> returnMap = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : blocksToRestore.entrySet()) {
            BlockPos blockPos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (!this.canPlace(blockPos)) continue;
            returnMap.put(blockPos, blockState);
        }
        return returnMap;
    }

    private void restoreBlocks(FakePlayer fakePlayer) {
        int restoredCount = 0;
        for (Map.Entry<BlockPos, BlockState> entry : this.restoringBlocks.entrySet()) {
            BlockPos blockPos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (!this.canPlace(fakePlayer, blockPos) || !this.level.setBlock(blockPos, blockState, 3)) continue;
            ++restoredCount;
        }
        this.numBlocks = restoredCount;
    }

    private void restoreEntities(FakePlayer fakePlayer) {
        Map<Vec3, LivingEntity> entitiesToRestore = this.getEntitiesFromNBT();
        int restoredCount = 0;
        for (Map.Entry<Vec3, LivingEntity> entry : entitiesToRestore.entrySet()) {
            Vec3 entityPos = entry.getKey();
            if (!this.restoringEntites.contains(entityPos)) continue;
            LivingEntity entity = entry.getValue();
            entity.moveTo(entityPos.x, entityPos.y, entityPos.z, entity.getYRot(), entity.getXRot());
            if (!this.level.addFreshEntity((Entity)entity)) continue;
            ++restoredCount;
        }
        this.numEntities = restoredCount;
    }

    public boolean hasSnapshotData() {
        return !this.snapshotData.isEmpty();
    }

    @Override
    public int getMaxMB() {
        return (Integer)Config.PARADOX_TOTAL_FLUID_CAPACITY.get();
    }

    @Override
    public JustDireFluidTank getFluidTank() {
        return (JustDireFluidTank)((Object)this.getData(Registration.PARADOX_FLUID_HANDLER));
    }

    @Override
    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public RedstoneControlData getDefaultRedstoneData() {
        return new RedstoneControlData(MiscHelpers.RedstoneMode.PULSE);
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.PARADOX_TOTAL_RF_CAPACITY.get();
    }

    @Override
    public int getStandardEnergyCost() {
        return this.getBlockEnergyCost();
    }

    public int getBlockEnergyCost() {
        return (Integer)Config.PARADOX_RF_PER_BLOCK.get();
    }

    public int getEntityEnergyCost() {
        return (Integer)Config.PARADOX_RF_PER_ENTITY.get();
    }

    public int getEnergyCostPerTick(int cost) {
        return (int)Math.floor((double)cost / (double)this.getRunTime());
    }

    public int getEnergyCost(int blocks, int entities) {
        int blockCost = blocks * this.getBlockEnergyCost();
        int entityCost = entities * this.getEntityEnergyCost();
        return blockCost + entityCost;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    public void setAreaOnly(double x, double y, double z) {
        this.getAreaAffectingData().xRadius = Math.max(0.0, Math.min(x, 5.0));
        this.getAreaAffectingData().yRadius = Math.max(0.0, Math.min(y, 5.0));
        this.getAreaAffectingData().zRadius = Math.max(0.0, Math.min(z, 5.0));
        this.getAreaAffectingData().area = null;
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
    }

    public boolean canParadox() {
        if (!this.hasSnapshotData()) {
            return false;
        }
        return !this.getFluidTank().isEmpty();
    }

    public boolean hasEnoughFluid(int fluidCost) {
        FluidStack extractedStack = this.getFluidTank().drain(fluidCost, IFluidHandler.FluidAction.SIMULATE);
        return extractedStack.getAmount() == fluidCost;
    }

    public int extractFluid(int fluidCost) {
        return this.getFluidTank().drain(fluidCost, IFluidHandler.FluidAction.EXECUTE).getAmount();
    }

    public int getFluidCostPerTick(int totalFluidCost) {
        return (int)Math.floor((double)totalFluidCost / (double)this.getRunTime());
    }

    public int getFluidCost(int blocks, int entities) {
        int blockCost = blocks * this.getBlockFluidCost();
        int entityCost = entities * this.getEntityFluidCost();
        return blockCost + entityCost;
    }

    public int getBlockFluidCost() {
        return (Integer)Config.PARADOX_FLUID_PER_BLOCK.get();
    }

    public int getEntityFluidCost() {
        return (Integer)Config.PARADOX_FLUID_PER_ENTITY.get();
    }

    public void postRun() {
        if (this.numBlocks == -1 || this.numEntities == -1) {
            return;
        }
        this.numBlocks = -1;
        this.numEntities = -1;
    }

    public BlockPos getStartingPoint() {
        return this.getBlockPos().offset(this.getAreaAffectingData().xOffset, this.getAreaAffectingData().yOffset, this.getAreaAffectingData().zOffset);
    }

    public boolean isBlockPosValid(ServerLevel serverLevel, BlockPos blockPos) {
        BlockState blockState = serverLevel.getBlockState(blockPos);
        return blockState.is(JustDireBlockTags.PARADOX_ALLOW);
    }

    public Map<BlockPos, BlockState> getBlocksFromNBT() {
        BlockPos machinePos = this.getBlockPos();
        HashMap<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
        if (this.targetType == 2 || !this.snapshotData.contains("blocks")) {
            return blockMap;
        }
        ListTag blockDataList = this.snapshotData.getList("blocks", 10);
        for (int i = 0; i < blockDataList.size(); ++i) {
            CompoundTag blockTag = blockDataList.getCompound(i);
            BlockPos relativePos = NbtUtils.readBlockPos((CompoundTag)blockTag, (String)"pos").orElse(null);
            if (relativePos == null) continue;
            BlockPos worldPos = relativePos.offset((Vec3i)machinePos);
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)blockTag.getCompound("state"));
            blockMap.put(worldPos, blockState);
        }
        return blockMap;
    }

    public Map<Vec3, LivingEntity> getEntitiesFromNBT() {
        BlockPos machinePos = this.getBlockPos();
        HashMap<Vec3, LivingEntity> entityMap = new HashMap<Vec3, LivingEntity>();
        if (this.targetType == 1 || !this.snapshotData.contains("entities")) {
            return entityMap;
        }
        ListTag entityDataList = this.snapshotData.getList("entities", 10);
        for (int i = 0; i < entityDataList.size(); ++i) {
            CompoundTag entityTag = entityDataList.getCompound(i);
            Vec3 relativePos = NBTHelpers.nbtToVec3(entityTag.getCompound("relativePos"));
            Vec3 worldPos = relativePos.add(Vec3.atCenterOf((Vec3i)machinePos));
            CompoundTag entityData = entityTag.getCompound("data");
            LivingEntity entity = this.restoreEntityFromNBT(entityData, worldPos);
            if (entity == null) continue;
            entityMap.put(worldPos, entity);
        }
        return entityMap;
    }

    private LivingEntity restoreEntityFromNBT(CompoundTag entityData, Vec3 worldPos) {
        Entity entity;
        if (entityData == null || !entityData.contains("id")) {
            return null;
        }
        EntityType entityType = EntityType.byString((String)entityData.getString("id")).orElse(null);
        if (entityType == null) {
            return null;
        }
        if (entityData.contains("UUID")) {
            Entity existingEntity;
            UUID entityUUID = entityData.getUUID("UUID");
            if (!this.level.isClientSide && (existingEntity = ((ServerLevel)this.level).getEntity(entityUUID)) != null) {
                return null;
            }
        }
        if (!((entity = entityType.create(this.level)) instanceof LivingEntity)) {
            return null;
        }
        CompoundTag santizedData = (Boolean)Config.PARADOX_RESTRICTED_MOBS.get() != false ? this.sanitizeEntityData(entityData) : this.sanitizeEntityDataDeny(entityData);
        entity.load(santizedData);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)this.level.getCurrentDifficultyAt(this.getBlockPos()), (MobSpawnType)MobSpawnType.SPAWNER, null);
            }
        }
        entity.moveTo(worldPos.x, worldPos.y, worldPos.z, entity.getYRot(), entity.getXRot());
        return (LivingEntity)entity;
    }

    public CompoundTag sanitizeEntityData(CompoundTag entityData) {
        String[] fieldsToCopy;
        CompoundTag compoundTag = new CompoundTag();
        for (String field : fieldsToCopy = new String[]{"IsBaby", "UUID", "Health", "Motion", "Rotation", "Fire", "CustomName", "NoAI", "PersistenceRequired", "Silent", "Color", "Sheared", "Variant", "FromBucket", "Age", "VillagerData", "Xp", "LastRestock", "RestocksToday", "Offers", "EggLayTime"}) {
            if (!entityData.contains(field)) continue;
            compoundTag.put(field, entityData.get(field));
        }
        return compoundTag;
    }

    public CompoundTag sanitizeEntityDataDeny(CompoundTag entityData) {
        CompoundTag compoundTag = new CompoundTag();
        String[] fieldsToRemove = new String[]{"ArmorItems", "HandItems", "Items", "SaddleItem", "Inventory"};
        for (String key : entityData.getAllKeys()) {
            boolean shouldRemove = false;
            for (String field : fieldsToRemove) {
                if (!key.equals(field)) continue;
                shouldRemove = true;
                break;
            }
            if (shouldRemove || entityData.get(key) == null) continue;
            compoundTag.put(key, entityData.get(key));
        }
        return compoundTag;
    }

    public void setRenderParadox(boolean render, int targetType) {
        this.renderParadox = render;
        this.targetType = targetType;
        this.markDirtyClient();
    }

    public void snapshotArea() {
        if (this.level == null) {
            return;
        }
        BlockPos machinePos = this.getBlockEntity().getBlockPos();
        AABB area = this.getAABB(machinePos);
        ArrayList<CompoundTag> blockDataList = new ArrayList<CompoundTag>();
        ArrayList<CompoundTag> entityDataList = new ArrayList<CompoundTag>();
        for (BlockPos pos : this.findBlocksToSave()) {
            BlockState blockState = this.level.getBlockState(pos);
            if (blockState.isAir()) continue;
            CompoundTag blockTag = new CompoundTag();
            blockTag.put("pos", NbtUtils.writeBlockPos((BlockPos)pos.subtract((Vec3i)machinePos)));
            blockTag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
            blockDataList.add(blockTag);
        }
        List<LivingEntity> entities = this.findEntitiesToSave(area);
        for (LivingEntity entity : entities) {
            CompoundTag entityTag = new CompoundTag();
            CompoundTag entityData = new CompoundTag();
            entity.save(entityData);
            Vec3 entityRelativePos = entity.position().subtract(Vec3.atCenterOf((Vec3i)machinePos));
            entityTag.put("relativePos", (Tag)NBTHelpers.vec3ToNBT(entityRelativePos));
            entityTag.put("data", (Tag)entityData);
            entityDataList.add(entityTag);
        }
        this.snapshotData = new CompoundTag();
        this.snapshotData.put("blocks", (Tag)this.writeBlockDataList(blockDataList));
        this.snapshotData.put("entities", (Tag)this.writeEntityDataList(entityDataList));
        this.clearSnapshotCache();
        this.markDirtyClient();
    }

    public void clearSnapshotCache() {
        this.savedBlocks = -1;
        this.savedEntities = -1;
    }

    public int getSavedBlocksCount() {
        if (this.savedBlocks == -1) {
            this.savedBlocks = this.getBlocksFromNBT().size();
        }
        return this.savedBlocks;
    }

    public int getSavedEntitiesCount() {
        if (this.savedEntities == -1) {
            this.savedEntities = this.getEntitiesFromNBT().size();
        }
        return this.savedEntities;
    }

    public List<BlockPos> findBlocksToSave() {
        AABB area = this.getAABB(this.getBlockPos());
        return BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).filter(blockPos -> this.isBlockPosValid((ServerLevel)this.level, (BlockPos)blockPos)).map(BlockPos::immutable).collect(Collectors.toList());
    }

    public List<LivingEntity> findEntitiesToSave(AABB aabb) {
        return new ArrayList<LivingEntity>(this.level.getEntitiesOfClass(LivingEntity.class, aabb, this::isValidEntity));
    }

    public boolean isValidEntity(Entity entity) {
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        if (entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
            return false;
        }
        if (entity.getType().is(JustDireEntityTags.PARADOX_DENY)) {
            return false;
        }
        return !(entity instanceof Player);
    }

    private ListTag writeBlockDataList(List<CompoundTag> blockDataList) {
        ListTag listTag = new ListTag();
        listTag.addAll(blockDataList);
        return listTag;
    }

    private ListTag writeEntityDataList(List<CompoundTag> entityDataList) {
        ListTag listTag = new ListTag();
        listTag.addAll(entityDataList);
        return listTag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        if (this.level.isClientSide && this.isRunning && !pkt.getTag().getBoolean("isRunning")) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                mc.getSoundManager().stop(SoundEvents.PORTAL_AMBIENT.getLocation(), SoundSource.BLOCKS);
            }
        }
        super.onDataPacket(net, pkt, lookupProvider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("snapshotData", (Tag)this.snapshotData);
        tag.putBoolean("renderParadox", this.renderParadox);
        tag.putInt("targetType", this.targetType);
        tag.putBoolean("isRunning", this.isRunning);
        tag.putInt("timeRunning", this.timeRunning);
        tag.putInt("fePerTick", this.fePerTick);
        tag.putInt("fluidPerTick", this.fluidPerTick);
        tag.putFloat("paradoxEnergy", this.paradoxEnergy);
        ListTag restoringBlocksList = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.restoringBlocks.entrySet()) {
            CompoundTag blockData = new CompoundTag();
            blockData.put("pos", NbtUtils.writeBlockPos((BlockPos)entry.getKey()));
            blockData.put("state", (Tag)NbtUtils.writeBlockState((BlockState)entry.getValue()));
            restoringBlocksList.add((Object)blockData);
        }
        tag.put("restoringBlocks", (Tag)restoringBlocksList);
        ListTag restoringEntitiesList = new ListTag();
        for (Vec3 vec : this.restoringEntites) {
            CompoundTag entityData = NBTHelpers.vec3ToNBT(vec);
            restoringEntitiesList.add((Object)entityData);
        }
        tag.put("restoringEntities", (Tag)restoringEntitiesList);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int i;
        super.loadAdditional(tag, provider);
        if (tag.contains("snapshotData")) {
            this.snapshotData = tag.getCompound("snapshotData");
        }
        if (tag.contains("renderParadox")) {
            this.renderParadox = tag.getBoolean("renderParadox");
        }
        if (tag.contains("targetType")) {
            this.targetType = tag.getInt("targetType");
        }
        if (tag.contains("isRunning")) {
            this.isRunning = tag.getBoolean("isRunning");
        }
        if (tag.contains("timeRunning")) {
            this.timeRunning = tag.getInt("timeRunning");
        }
        if (tag.contains("paradoxEnergy")) {
            this.paradoxEnergy = tag.getFloat("paradoxEnergy");
        }
        this.restoringBlocks.clear();
        if (tag.contains("restoringBlocks")) {
            ListTag restoringBlocksList = tag.getList("restoringBlocks", 10);
            for (i = 0; i < restoringBlocksList.size(); ++i) {
                CompoundTag blockData = restoringBlocksList.getCompound(i);
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)blockData, (String)"pos").orElse(null);
                if (pos == null) continue;
                BlockState state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)blockData.getCompound("state"));
                this.restoringBlocks.put(pos, state);
            }
        }
        this.restoringEntites.clear();
        if (tag.contains("restoringEntities")) {
            ListTag restoringEntitiesList = tag.getList("restoringEntities", 10);
            for (i = 0; i < restoringEntitiesList.size(); ++i) {
                CompoundTag entityData = restoringEntitiesList.getCompound(i);
                Vec3 vec = NBTHelpers.nbtToVec3(entityData);
                this.restoringEntites.add(vec);
            }
        }
    }
}

