/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.NBTHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class GooSoilBE
extends BlockEntity {
    private NBTHelpers.BoundInventory boundInventory;
    protected BlockCapabilityCache<IItemHandler, Direction> attachedInventory;

    public GooSoilBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.GooSoilBE.get(), pos, state);
    }

    public void bindInventory(NBTHelpers.BoundInventory boundInventory) {
        this.boundInventory = boundInventory;
        this.setChanged();
    }

    public IItemHandler getAttachedInventory(ServerLevel serverLevel) {
        if (this.boundInventory == null) {
            return null;
        }
        if (this.attachedInventory == null) {
            ServerLevel boundLevel = serverLevel.getServer().getLevel(this.boundInventory.globalPos().dimension());
            if (boundLevel == null) {
                return null;
            }
            this.attachedInventory = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)boundLevel, (BlockPos)this.boundInventory.globalPos().pos(), (Object)this.boundInventory.direction());
        }
        return (IItemHandler)this.attachedInventory.getCapability();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.boundInventory != null) {
            tag.put("boundinventory", (Tag)NBTHelpers.BoundInventory.toNBT(this.boundInventory));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("boundinventory")) {
            this.boundInventory = NBTHelpers.BoundInventory.fromNBT(tag.getCompound("boundinventory"));
        }
        super.loadAdditional(tag, provider);
    }
}

