/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockBreakerT1BE
extends BaseMachineBE
implements RedstoneControlledBE {
    LinkedHashMap<BlockPos, BlockBreakingProgress> blockBreakingTracker = new LinkedHashMap();
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    Map.Entry<BlockPos, BlockBreakingProgress> currentBlock;

    public BlockBreakerT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
    }

    public BlockBreakerT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.BlockBreakerT1BE.get(), pPos, pBlockState);
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    public void clearTracker(FakePlayer fakePlayer) {
        Iterator<Map.Entry<BlockPos, BlockBreakingProgress>> iterator = this.blockBreakingTracker.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, BlockBreakingProgress> entry = iterator.next();
            this.sendClearPacket(entry.getKey(), fakePlayer.getId() + entry.getValue().iterator);
            iterator.remove();
        }
    }

    public void sendClearPacket(BlockPos blockPos, int pBreakerId) {
        this.sendPackets(pBreakerId, blockPos, -1);
    }

    public void removePosFromTracker(BlockPos blockPos, int pBreakerId) {
        this.sendClearPacket(blockPos, pBreakerId);
        this.blockBreakingTracker.remove(blockPos);
    }

    public void clearTrackerIfNeeded(ItemStack tool, FakePlayer fakePlayer) {
        if (this.blockBreakingTracker.isEmpty()) {
            return;
        }
        if (tool.isEmpty()) {
            this.clearTracker(fakePlayer);
        }
        if (!this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE)) {
            this.clearTracker(fakePlayer);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doBlockBreak();
    }

    public boolean canMine() {
        return true;
    }

    public void doBlockBreak() {
        ItemStack tool = this.getTool();
        FakePlayer fakePlayer = this.getFakePlayer((ServerLevel)this.level);
        this.clearTrackerIfNeeded(tool, fakePlayer);
        if (tool.isEmpty()) {
            this.getRedstoneControlData().pulsed = false;
            return;
        }
        if (this.isActiveRedstone() && this.canRun() && this.blockBreakingTracker.isEmpty()) {
            List<BlockPos> blocksToMine = this.findBlocksToMine(fakePlayer);
            for (BlockPos blockPos : blocksToMine) {
                BlockState blockState = this.level.getBlockState(blockPos);
                if (blockState.isAir() || this.blockBreakingTracker.containsKey(blockPos)) continue;
                this.startMining(fakePlayer, blockPos, blockState, tool);
            }
        }
        if (this.blockBreakingTracker.isEmpty() || !this.canMine()) {
            return;
        }
        if (this.currentBlock == null && this.canRun()) {
            this.currentBlock = this.blockBreakingTracker.entrySet().iterator().next();
        }
        if (this.currentBlock != null && this.mineBlock(this.currentBlock.getKey(), tool, fakePlayer)) {
            this.removePosFromTracker(this.currentBlock.getKey(), fakePlayer.getId() + this.currentBlock.getValue().iterator);
            this.currentBlock = null;
        }
    }

    public boolean isBlockValid(FakePlayer fakePlayer, BlockPos blockPos) {
        BlockState blockState = this.level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        if (blockPos.equals((Object)this.getBlockPos())) {
            return false;
        }
        if (this.blockBreakingTracker.containsKey(blockPos)) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)this.level, blockPos) < 0.0f) {
            return false;
        }
        if (!this.level.mayInteract((Player)fakePlayer, blockPos)) {
            return false;
        }
        return this.canBreakAndPlaceAt(this.level, blockPos, fakePlayer);
    }

    public List<BlockPos> findBlocksToMine(FakePlayer fakePlayer) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockValid(fakePlayer, blockPos)) {
            returnList.add(blockPos);
        }
        return returnList;
    }

    public ItemStack getTool() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    public int generatePosHash() {
        BlockPos blockPos = this.getBlockPos();
        return blockPos.getX() + blockPos.getY() + blockPos.getZ();
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    public void startMining(FakePlayer fakePlayer, BlockPos blockPos, BlockState blockState, ItemStack tool) {
        this.setFakePlayerData(tool, fakePlayer, blockPos, this.getFacing());
        this.blockBreakingTracker.put(blockPos, new BlockBreakingProgress(blockState, 0, this.blockBreakingTracker.size() + this.generatePosHash(), this.getDestroyProgress(blockPos, tool, fakePlayer, blockState)));
    }

    public boolean mineBlock(BlockPos blockPos, ItemStack tool, FakePlayer player) {
        BlockState blockState = this.level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return true;
        }
        if (this.blockBreakingTracker.containsKey(blockPos) && !this.level.getBlockState(blockPos).equals(this.blockBreakingTracker.get((Object)blockPos).blockState)) {
            return true;
        }
        BlockBreakingProgress progress = this.blockBreakingTracker.compute(blockPos, (pos, oldProgress) -> {
            int updatedTicks;
            int n = updatedTicks = oldProgress == null ? 1 : oldProgress.ticks + 1;
            if (oldProgress == null) {
                return new BlockBreakingProgress(blockState, 1, -1, this.blockBreakingTracker.size() + this.generatePosHash(), this.getDestroyProgress(blockPos, tool, player, blockState));
            }
            return new BlockBreakingProgress(blockState, updatedTicks, oldProgress.lastSentProgress, oldProgress.iterator, oldProgress.destroyProgress);
        });
        float destroyProgress = progress.destroyProgress * (float)progress.ticks;
        int currentProgress = (int)(destroyProgress * 10.0f);
        if (currentProgress != progress.lastSentProgress && currentProgress < 10) {
            this.sendPackets(player.getId() + progress.iterator, blockPos, currentProgress);
            this.blockBreakingTracker.put(blockPos, new BlockBreakingProgress(blockState, progress.ticks, currentProgress, progress.iterator, progress.destroyProgress));
        }
        if (destroyProgress >= 1.0f) {
            this.tryBreakBlock(tool, player, blockPos, blockState);
            return true;
        }
        return false;
    }

    public float getDestroyProgress(BlockPos blockPos, ItemStack tool, FakePlayer player, BlockState blockState) {
        float hardness = blockState.getDestroySpeed((BlockGetter)this.level, blockPos);
        if (hardness == -1.0f) {
            return -1.0f;
        }
        float modifier = tool.isCorrectToolForDrops(blockState) ? 30.0f : 100.0f;
        return this.getDestroySpeed(blockPos, tool, player, blockState) / hardness / modifier;
    }

    public float getDestroySpeed(BlockPos blockPos, ItemStack tool, FakePlayer player, BlockState blockState) {
        HolderLookup.RegistryLookup registrylookup;
        int efficiency;
        float toolDestroySpeed = tool.getDestroySpeed(blockState);
        if (toolDestroySpeed > 1.0f && (efficiency = tool.getEnchantmentLevel((Holder)(registrylookup = this.level.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).getOrThrow(Enchantments.EFFICIENCY))) > 0) {
            toolDestroySpeed += (float)(efficiency * efficiency + 1);
        }
        toolDestroySpeed = EventHooks.getBreakSpeed((Player)player, (BlockState)blockState, (float)toolDestroySpeed, (BlockPos)blockPos);
        return toolDestroySpeed;
    }

    public boolean tryBreakBlock(ItemStack tool, FakePlayer fakePlayer, BlockPos breakPos, BlockState blockState) {
        this.setFakePlayerData(tool, fakePlayer, breakPos, this.getFacing());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.level, breakPos, this.level.getBlockState(breakPos), (Player)fakePlayer);
        if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return false;
        }
        this.breakBlock(fakePlayer, breakPos, tool, blockState);
        return true;
    }

    public void breakBlock(FakePlayer player, BlockPos breakPos, ItemStack itemStack, BlockState state) {
        BlockEntity blockEntity = this.level.getBlockEntity(breakPos);
        boolean success = this.level.destroyBlock(breakPos, false, (Entity)player);
        if (success) {
            Block.dropResources((BlockState)state, (Level)this.level, (BlockPos)breakPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)itemStack);
            if (state.getDestroySpeed((BlockGetter)this.level, breakPos) != 0.0f) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            }
        }
    }

    public void sendPackets(int pBreakerId, BlockPos pPos, int pProgress) {
        for (ServerPlayer serverplayer : this.level.getServer().getPlayerList().getPlayers()) {
            double d2;
            double d1;
            double d0;
            if (serverplayer == null || serverplayer.level() != this.level || serverplayer.getId() == pBreakerId || !((d0 = (double)pPos.getX() - serverplayer.getX()) * d0 + (d1 = (double)pPos.getY() - serverplayer.getY()) * d1 + (d2 = (double)pPos.getZ() - serverplayer.getZ()) * d2 < 1024.0)) continue;
            serverplayer.connection.send((Packet)new ClientboundBlockDestructionPacket(pBreakerId, pPos, pProgress));
        }
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.tickSpeed != 20) {
            return false;
        }
        return this.getRedstoneControlData().equals(this.getDefaultRedstoneData());
    }

    private record BlockBreakingProgress(BlockState blockState, int ticks, int lastSentProgress, int iterator, float destroyProgress) {
        public BlockBreakingProgress(BlockState blockState, int ticks, int iterator, float destroyProgress) {
            this(blockState, ticks, -1, iterator, destroyProgress);
        }
    }
}

