/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.blockentityrenders;

import com.direwolf20.justdirethings.client.blockentityrenders.baseber.AreaAffectingBER;
import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class InventoryHolderBER
extends AreaAffectingBER {
    public InventoryHolderBER(BlockEntityRendererProvider.Context context) {
    }

    @Override
    public void render(BlockEntity blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        if (blockentity instanceof InventoryHolderBE) {
            InventoryHolderBE inventoryHolderBE = (InventoryHolderBE)blockentity;
            if (inventoryHolderBE.renderPlayer) {
                AbstractClientPlayer mockPlayer = this.createMockPlayer(inventoryHolderBE);
                if (mockPlayer == null) {
                    return;
                }
                mockPlayer.yHeadRot = 0.0f;
                mockPlayer.yHeadRotO = 0.0f;
                this.equipMockPlayer(mockPlayer, inventoryHolderBE);
                this.renderMockPlayerEntity(matrixStackIn, bufferIn, mockPlayer, combinedLightsIn, partialTicks);
            }
        }
    }

    public AbstractClientPlayer createMockPlayer(InventoryHolderBE blockEntity) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return null;
        }
        UUID placedByUUID = blockEntity.placedByUUID;
        if (placedByUUID == null) {
            return null;
        }
        GameProfile gameProfile = new GameProfile(placedByUUID, "MockPlayer");
        return new AbstractClientPlayer(this, minecraft.level, gameProfile){

            public boolean isSpectator() {
                return false;
            }

            public boolean isCreative() {
                return false;
            }
        };
    }

    public void equipMockPlayer(AbstractClientPlayer mockPlayer, InventoryHolderBE blockEntity) {
        ItemStackHandler itemStackHandler = blockEntity.getMachineHandler();
        if (!itemStackHandler.getStackInSlot(blockEntity.renderedSlot).isEmpty()) {
            mockPlayer.setItemInHand(InteractionHand.MAIN_HAND, itemStackHandler.getStackInSlot(blockEntity.renderedSlot));
        }
        if (!itemStackHandler.getStackInSlot(40).isEmpty()) {
            mockPlayer.setItemInHand(InteractionHand.OFF_HAND, itemStackHandler.getStackInSlot(40));
        }
        if (!itemStackHandler.getStackInSlot(36).isEmpty()) {
            mockPlayer.setItemSlot(EquipmentSlot.HEAD, itemStackHandler.getStackInSlot(36));
        }
        if (!itemStackHandler.getStackInSlot(37).isEmpty()) {
            mockPlayer.setItemSlot(EquipmentSlot.CHEST, itemStackHandler.getStackInSlot(37));
        }
        if (!itemStackHandler.getStackInSlot(38).isEmpty()) {
            mockPlayer.setItemSlot(EquipmentSlot.LEGS, itemStackHandler.getStackInSlot(38));
        }
        if (!itemStackHandler.getStackInSlot(39).isEmpty()) {
            mockPlayer.setItemSlot(EquipmentSlot.FEET, itemStackHandler.getStackInSlot(39));
        }
    }

    public void renderMockPlayerEntity(PoseStack matrixStackIn, MultiBufferSource bufferIn, AbstractClientPlayer mockPlayer, int combinedLightsIn, float partialTicks) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 1.0, 0.5);
        matrixStackIn.scale(0.5f, 0.5f, 0.5f);
        long gameTime = System.currentTimeMillis();
        float rotation = (float)(gameTime % 7200L) / 20.0f;
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
        Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)mockPlayer, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, 0xF000F0);
        matrixStackIn.popPose();
    }
}

