/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.particle.custom;

import dev.xylonity.explosiveenhancement.config.ExplosiveValues;
import dev.xylonity.explosiveenhancement.registry.ExplosiveParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FireballParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    boolean important;
    private double velX;
    private double velY;
    private double velZ;

    FireballParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider, double velX, double velY, double velZ) {
        super(world, x, y, z);
        this.sprites = spriteProvider;
        this.lifetime = (int)(9.0 + Math.floor(velX / 5.0));
        this.quadSize = (float)velX;
        this.important = velY == 1.0;
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if ((double)this.age >= (double)this.lifetime * 0.65 && ExplosiveValues.showSparks) {
                this.level.addParticle((ParticleOptions)ExplosiveParticles.SPARKS.get(), this.important, this.x, this.y, this.z, (double)this.quadSize, this.yd, this.zd);
            }
            this.setSpriteFromAge(this.sprites);
        }
    }

    protected int getLightColor(float pPartialTick) {
        return ExplosiveValues.emissiveExplosion ? 0xF000F0 : super.getLightColor(pPartialTick);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new FireballParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

