/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.mixin;

import dev.xylonity.explosiveenhancement.registry.ExplosiveParticleEngine;
import dev.xylonity.explosiveenhancement.registry.ExplosiveRegistries;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ParticleEngine.class})
public class ParticleEngineMixin
implements ExplosiveParticleEngine {
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleProvider<?>> providers;
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleEngine.MutableSpriteSet> spriteSets;
    @Shadow
    protected ClientLevel level;

    @Override
    public <O extends ParticleOptions, T extends ParticleType<O>> void registerExplosive(DeferredHolder<ParticleType<?>, T> type, ParticleEngine.SpriteParticleRegistration<O> registration) {
        ParticleEngine.MutableSpriteSet spriteSet = new ParticleEngine.MutableSpriteSet();
        this.spriteSets.put(type.getId(), spriteSet);
        this.providers.put(type.getId(), registration.create((SpriteSet)spriteSet));
    }

    @Inject(method={"makeParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Registry;getKey(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;")}, cancellable=true)
    private <T extends ParticleOptions> void onMakeParticle(T pParticleData, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, CallbackInfoReturnable<Particle> cir) {
        ResourceLocation original = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)pParticleData.getType());
        if (ExplosiveRegistries.PARTICLE_TYPES_REGISTRY != null) {
            ResourceLocation newResource = original == null ? ExplosiveRegistries.PARTICLE_TYPES_REGISTRY.getKey((Object)pParticleData.getType()) : original;
            ParticleProvider<?> particleProvider = this.providers.get(newResource);
            if (particleProvider != null) {
                Particle particle = particleProvider.createParticle(pParticleData, this.level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
                cir.setReturnValue((Object)particle);
            } else {
                cir.setReturnValue(null);
            }
            cir.cancel();
        }
    }
}

