/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.util;

import brightspark.asynclocator.AsyncLocator;
import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.item.data.ExplorationScrollData;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class LocateUtil {
    private static final Cache<UUID, LocateState> STRUCTURE_LOOKUP_CACHE = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(5L)).build();

    public static HolderSet<Structure> holderFromTag(ServerLevel level, TagKey<Structure> structureTagKey) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        return (HolderSet)registry.getTag(structureTagKey).orElseThrow();
    }

    public static HolderSet<Structure> holderFromResource(ServerLevel level, ResourceKey<Structure> structureResourceKey) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        return (HolderSet)registry.getHolder(structureResourceKey).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElseThrow();
    }

    public static void resolveUUID(ServerLevel level, Vec3 position, ItemStack stack, @Nullable Entity entity) {
        if (!stack.has(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA)) {
            return;
        }
        UUID uuid = (UUID)stack.get(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA);
        LocateState state = (LocateState)STRUCTURE_LOOKUP_CACHE.getIfPresent((Object)uuid);
        if (state == null) {
            ArsAdditions.LOGGER.warn("Found Exploration Warp Scroll with no pending structure lookup.");
            LocateUtil.locateFromStack(level, position, stack);
        }
        if (state == null || state.status() == Status.PENDING) {
            return;
        }
        stack.remove(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA);
        if (state.status() == Status.FAILURE) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.failed"));
            STRUCTURE_LOOKUP_CACHE.invalidate((Object)uuid);
        } else {
            LocateUtil.setScrollData(level, stack, state.pos());
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.located"));
        }
    }

    public static boolean isPending(ItemStack stack) {
        return stack.has(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA);
    }

    public static void locateWithState(ItemStack itemStack, ServerLevel level, HolderSet<Structure> holderSet, BlockPos origin, int searchRadius, boolean skipKnownStructures) {
        UUID uuid = UUID.randomUUID();
        if (itemStack.has(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA)) {
            uuid = (UUID)itemStack.get(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA);
        } else {
            itemStack.set(AddonDataComponentRegistry.STRUCTURE_LOOKUP_DATA, (Object)uuid);
        }
        STRUCTURE_LOOKUP_CACHE.put((Object)uuid, (Object)LocateState.pending());
        UUID finalUuid = uuid;
        LocateUtil.locate(level, holderSet, origin, searchRadius, skipKnownStructures, pair -> {
            if (pair == null) {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.failure());
                return;
            }
            BlockPos pos = (BlockPos)pair.getFirst();
            if (pos == null) {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.failure());
            } else {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.success((Structure)((Holder)pair.getSecond()).value(), pos));
            }
        });
    }

    public static void locateFromStack(ServerLevel level, Vec3 position, ItemStack stack) {
        ExplorationScrollData data = ExplorationScrollData.fromItemStack(stack);
        HolderSet<Structure> holderSet = LocateUtil.holderFromTag(level, ExplorationScrollData.DEFAULT_DESTINATION);
        Vec3 origin = data.pos().orElse(position);
        int searchRadius = 50;
        boolean skipKnown = true;
        LocateUtil.locateWithState(stack, level, holderSet, BlockPos.containing((Position)origin), searchRadius, skipKnown);
    }

    public static void locate(ServerLevel level, HolderSet<Structure> holderSet, BlockPos origin, int searchRadius, boolean skipKnownStructures, Consumer<Pair<BlockPos, Holder<Structure>>> consumer) {
        if (ModList.get().isLoaded("asynclocator")) {
            AsyncLocator.locate((ServerLevel)level, holderSet, (BlockPos)origin, (int)searchRadius, (boolean)skipKnownStructures).then(pair -> {
                if (pair == null) {
                    level.getServer().submit(() -> consumer.accept(null));
                    return;
                }
                Pair modified = pair.mapFirst(pos -> LocateUtil.findBlockPos(level, (Structure)((Holder)pair.getSecond()).value(), pos));
                level.getServer().submit(() -> consumer.accept(modified));
            });
        } else {
            ArsAdditions.LOGGER.warn("Running locate on server thread. If this causes lag please install Async Locator https://modrinth.com/mod/async-locator");
            Pair pair2 = level.getChunkSource().getGenerator().findNearestMapStructure(level, holderSet, origin, searchRadius, skipKnownStructures);
            if (pair2 == null) {
                consumer.accept(null);
                return;
            }
            Pair modified = pair2.mapFirst(pos -> LocateUtil.findBlockPos(level, (Structure)((Holder)pair2.getSecond()).value(), pos));
            consumer.accept((Pair<BlockPos, Holder<Structure>>)modified);
        }
    }

    public static WarpScrollData setScrollData(ServerLevel level, ItemStack stack, BlockPos pos) {
        return (WarpScrollData)stack.update((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true), data -> data.setPos(pos, level.dimension().location().toString()).setRotation(Vec2.ZERO));
    }

    public static BlockPos findBlockPos(ServerLevel level, Structure structure, BlockPos pos) {
        StructureStart structureStart = level.structureManager().getStartForStructure(SectionPos.of((BlockPos)pos), structure, (StructureAccess)level.getChunk(pos));
        if (structureStart == null) {
            BlockPos highest = LocateUtil.findHighestSafeBlock(level, pos);
            if (highest == null) {
                return pos.atY(level.getSeaLevel());
            }
            return highest;
        }
        BoundingBox box = structureStart.getBoundingBox();
        for (int i = 0; i < 5; ++i) {
            int x = Mth.randomBetweenInclusive((RandomSource)level.random, (int)box.minX(), (int)box.maxX());
            int y = Mth.randomBetweenInclusive((RandomSource)level.random, (int)box.minY(), (int)box.maxY());
            int z = Mth.randomBetweenInclusive((RandomSource)level.random, (int)box.minZ(), (int)box.maxZ());
            BlockPos start = new BlockPos(x, y, z);
            for (BlockPos.MutableBlockPos position : BlockPos.spiralAround((BlockPos)start, (int)10, (Direction)Direction.NORTH, (Direction)Direction.EAST)) {
                BlockPos highest = LocateUtil.findHighestSafeBlock(level, (BlockPos)position, y, box.minY());
                if (highest == null) continue;
                return highest;
            }
        }
        return LocateUtil.findHighestSafeBlock(level, pos);
    }

    public static BlockPos findHighestSafeBlock(ServerLevel level, BlockPos pos) {
        return LocateUtil.findHighestSafeBlock(level, pos, level.getMaxBuildHeight(), level.getMinBuildHeight());
    }

    public static BlockPos findHighestSafeBlock(ServerLevel level, BlockPos pos, int max, int min) {
        BlockPos.MutableBlockPos mutable = pos.mutable().setY(max);
        boolean headAir = level.getBlockState((BlockPos)mutable).isAir();
        mutable.move(Direction.DOWN);
        boolean feetAir = level.getBlockState((BlockPos)mutable).isAir();
        while (mutable.getY() > min) {
            mutable.move(Direction.DOWN);
            boolean groundAir = level.getBlockState((BlockPos)mutable).isAir();
            if (!groundAir && feetAir && headAir) {
                return mutable.move(Direction.UP);
            }
            headAir = feetAir;
            feetAir = groundAir;
        }
        return null;
    }

    public record LocateState(Status status, Structure structure, BlockPos pos) {
        public static LocateState pending() {
            return new LocateState(Status.PENDING, null, null);
        }

        public static LocateState failure() {
            return new LocateState(Status.FAILURE, null, null);
        }

        public static LocateState success(Structure structure, BlockPos pos) {
            return new LocateState(Status.SUCCESS, structure, pos);
        }
    }

    public static enum Status {
        PENDING,
        SUCCESS,
        FAILURE;

    }
}

