/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.datagen.StructureTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateStructureProvider
extends SimpleDataProvider {
    public List<LocateStructureRecipe> recipes = new ArrayList<LocateStructureRecipe>();

    public LocateStructureProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (LocateStructureRecipe recipe : this.recipes) {
            Path path = LocateStructureProvider.getRecipePath(this.output, recipe.getId().getPath());
            LocateStructureRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).result().ifPresent(json -> this.saveStable(pOutput, (JsonElement)json, path));
        }
    }

    protected void addEntries() {
        this.addEntry("pillager_outpost", (ResourceKey<Structure>)BuiltinStructures.PILLAGER_OUTPOST, ResourceOrTag.item(Items.EMERALD));
        this.addEntry("end_city", (ResourceKey<Structure>)BuiltinStructures.END_CITY, ResourceOrTag.item(Items.PURPUR_BLOCK));
        this.addEntry("jungle_temple", (ResourceKey<Structure>)BuiltinStructures.JUNGLE_TEMPLE, ResourceOrTag.item(Items.MOSSY_COBBLESTONE));
        this.addEntry("wilden_den", (TagKey<Structure>)StructureTagProvider.WILDEN_DEN, ResourceOrTag.item((Item)ItemsRegistry.SOURCE_GEM.get()));
        this.addEntry("monument", (ResourceKey<Structure>)BuiltinStructures.OCEAN_MONUMENT, ResourceOrTag.tag(ItemTags.FISHES));
        this.addEntry("fortress", (ResourceKey<Structure>)BuiltinStructures.FORTRESS, ResourceOrTag.item(Items.NETHER_BRICK));
        this.addEntry("ancient_city", (ResourceKey<Structure>)BuiltinStructures.ANCIENT_CITY, ResourceOrTag.item(Items.DEEPSLATE_BRICKS));
        this.addEntry("igloo", (ResourceKey<Structure>)BuiltinStructures.IGLOO, ResourceOrTag.item(Items.ICE));
        this.addEntry("bastion", (ResourceKey<Structure>)BuiltinStructures.BASTION_REMNANT, ResourceOrTag.item(Items.POLISHED_BLACKSTONE_BRICKS));
        this.addEntry("desert_temple", (ResourceKey<Structure>)BuiltinStructures.DESERT_PYRAMID, ResourceOrTag.item(Items.SANDSTONE));
        this.addEntry("trail_ruins", (ResourceKey<Structure>)BuiltinStructures.TRAIL_RUINS, ResourceOrTag.tag(ItemTags.TERRACOTTA));
        this.addEntry("arcane_library", (ResourceKey<Structure>)ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix("arcane_library")), ResourceOrTag.item((Item)ItemsRegistry.APPRENTICE_SPELLBOOK.get()));
    }

    private void addEntry(String id, ResourceKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.key(structureId), augments);
    }

    private void addEntry(String id, TagKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.tag(structureId), augments);
    }

    private void addEntry(String id, ResourceOrTag<Structure> structure, ResourceOrTag<Item> ... augments) {
        this.recipes.add(new LocateStructureRecipe(ArsAdditions.prefix(id), List.of(augments), structure, 50, true));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipe/locate_structure/" + id + ".json");
    }

    public String getName() {
        return "Locate Structure Datagen";
    }
}

