/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.datagen.Setup;
import com.github.jarva.arsadditions.datagen.patchouli.ApparatusPageProvider;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.ArsNouveauRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.RelationsPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.SpotlightPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PatchouliDatagen
extends PatchouliProvider {
    public static ResourceLocation STRUCTURES = ArsNouveau.prefix((String)"structures");

    public PatchouliDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart glyph : ArsNouveauRegistry.GLYPHS) {
            this.addGlyphPage(glyph);
        }
        for (AbstractRitual ritual : ArsNouveauRegistry.RITUALS) {
            this.addRitualPage(ritual);
        }
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)AddonItemRegistry.ADVANCED_LECTERN_REMOTE.get()).withName("ars_additions.page.warp_indexes").withTextPage("ars_additions.page1.warp_indexes").withPage((IPatchouliPage)new ApparatusPageProvider((ItemLike)AddonItemRegistry.LECTERN_REMOTE)).withPage((IPatchouliPage)new ApparatusPageProvider((ItemLike)AddonItemRegistry.ADVANCED_LECTERN_REMOTE)).withPage((IPatchouliPage)new RelationsPage().withEntry(MACHINES, "storage_lectern").withEntry(MACHINES, "bookwyrm_charm")), this.getPath(MACHINES, "warp_indexes"));
        this.addPage(new PatchouliBuilder(STRUCTURES, (ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern")).withName("ars_additions.page.ruined_warp_portals").withTextPage("ars_additions.page1.ruined_warp_portals").withPage((IPatchouliPage)new SpotlightPage((ItemLike)AddonItemRegistry.EXPLORATION_WARP_SCROLL.get())), this.getPath(STRUCTURES, "ruined_warp_portals"));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)AddonBlockRegistry.WARP_NEXUS.get()).withTextPage("ars_additions.page1.warp_nexus").withTextPage("ars_additions.page2.warp_nexus").withPage((IPatchouliPage)new RelationsPage().withEntry(STRUCTURES, "nexus_tower")), this.getPath(MACHINES, "warp_nexus"));
        this.addPage(new PatchouliBuilder(STRUCTURES, (ItemLike)AddonBlockRegistry.WARP_NEXUS.get()).withName("ars_additions.page.nexus_tower").withTextPage("ars_additions.page1.nexus_tower").withPage((IPatchouliPage)new SpotlightPage((ItemLike)AddonBlockRegistry.WARP_NEXUS.get()).withText("ars_additions.spotlight.warp_nexus")).withPage((IPatchouliPage)new RelationsPage().withEntry(MACHINES, "warp_nexus")), this.getPath(STRUCTURES, "nexus_tower"));
        this.addPage(new PatchouliBuilder(STRUCTURES, (ItemLike)BlockRegistry.FLOURISHING_WOOD).withName("ars_nouveau.page.wilden_dens").withTextPage("ars_nouveau.page1.wilden_dens"), this.getPath(STRUCTURES, "wilden_dens"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, AddonItemRegistry.UNSTABLE_RELIQUARY).withTextPage("ars_additions.page.unstable_reliquary").withPage((IPatchouliPage)new RelationsPage().withEntry(GLYPHS_3, "glyph_mark").withEntry(GLYPHS_3, "glyph_recall")), this.getPath(EQUIPMENT, "unstable_reliquary"));
        this.addBasicItem((ItemLike)AddonBlockRegistry.ENDER_SOURCE_JAR.get(), MACHINES, new ApparatusPageProvider((ItemLike)AddonBlockRegistry.ENDER_SOURCE_JAR));
        this.addBasicItem((ItemLike)AddonItemRegistry.XP_JAR.get(), EQUIPMENT, new ApparatusPageProvider((ItemLike)AddonItemRegistry.XP_JAR));
        this.addBasicItem((ItemLike)AddonItemRegistry.HANDY_HAVERSACK.get(), EQUIPMENT, (IPatchouliPage)new CraftingPage(AddonItemRegistry.HANDY_HAVERSACK));
        PatchouliBuilder charmBuilder = new PatchouliBuilder(EQUIPMENT, (ItemLike)AddonItemRegistry.CHARMS.get((Object)CharmRegistry.CharmType.FIRE_RESISTANCE)).withName("ars_additions.page.charms").withTextPage("ars_additions.page1.charms");
        for (Map.Entry entry2 : AddonItemRegistry.CHARMS.entrySet().stream().sorted(Comparator.comparing(entry -> ((CharmRegistry.CharmType)((Object)((Object)entry.getKey()))).getName())).toList()) {
            CharmRegistry.CharmType charmType = (CharmRegistry.CharmType)((Object)entry2.getKey());
            Item charm = (Item)((ItemRegistryWrapper)entry2.getValue()).get();
            String name = "page.ars_additions." + charmType.getSerializedName() + ".title";
            String desc = "page.ars_additions." + charmType.getSerializedName() + ".desc";
            charmBuilder = charmBuilder.withPage((IPatchouliPage)new SpotlightPage((ItemLike)charm).withTitle(name).withText(desc).linkRecipe(true));
        }
        this.addPage(charmBuilder, this.getPath(EQUIPMENT, "charms"));
        this.addBasicItem((ItemLike)AddonItemRegistry.IMBUED_SPELL_PARCHMENT.get(), EQUIPMENT, null);
        this.addPage(new PatchouliBuilder(STRUCTURES, (ItemLike)Blocks.BOOKSHELF).withName("ars_additions.page.arcane_library").withTextPage("ars_additions.page1.arcane_library"), this.getPath(STRUCTURES, "arcane_library"));
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.asItem().getDescriptionId()).withIcon((ItemLike)item.asItem()).withPage((IPatchouliPage)new TextPage(Setup.root + ".page." + RegistryHelper.getRegistryName((Item)item.asItem()).getPath()));
        if (recipePage != null) {
            builder = builder.withPage(recipePage);
        }
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.asItem()).getPath()));
        this.pages.add(page);
        return page;
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity." + Setup.root + "." + familiarHolder.getRegistryName().getPath()).withIcon(Setup.root + ":" + familiarHolder.getRegistryName().getPath()).withTextPage(Setup.root + ".familiar_desc." + familiarHolder.getRegistryName().getPath()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().getPath())));
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item." + Setup.root + "." + ritual.getRegistryName().getPath()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage(Setup.root + ":tablet_" + ritual.getRegistryName().getPath()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().getPath())));
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName(Setup.root + ".glyph_name." + spellPart.getRegistryName().getPath()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage(Setup.root + ".glyph_desc." + spellPart.getRegistryName().getPath())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().getPath())));
    }
}

