/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.datagen.Setup;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ModDatagen;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ImbuementDatagen
extends ImbuementRecipeProvider {
    public ImbuementDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/" + Setup.root + "/recipe/imbuement/" + str + ".json");
    }

    public void collectJsons(CachedOutput pOutput) {
        for (CharmRegistry.CharmType value : CharmRegistry.CharmType.values()) {
            this.recipes.add(new ImbuementRecipe(ArsAdditions.prefix(value.getSerializedName()).withPrefix("charms/"), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AddonItemRegistry.CHARMS.get((Object)value).get()}), ((Item)AddonItemRegistry.CHARMS.get((Object)value).get()).getDefaultInstance(), 2000));
        }
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.collectJsons(pOutput);
        ArrayList futures = new ArrayList();
        return ModDatagen.registries.thenCompose(registry -> {
            for (ImbuementRecipe g : this.recipes) {
                Path path = ImbuementDatagen.getRecipePath(this.output, g.id.getPath());
                futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }
}

