/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.ritual;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.item.data.WayfinderData;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.recipes.LocateStructureRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RitualLocateStructure
extends AbstractRitual {
    @Nullable
    private Optional<LocateStructureRecipe> recipe;
    public static ResourceLocation RESOURCE_LOCATION = ArsAdditions.prefix("ritual_locate_structure");

    private Optional<LocateStructureRecipe> getRecipe() {
        return LocateStructureRegistry.INSTANCE.getRecipes().stream().filter(r -> ((LocateStructureRecipe)r.value()).matches(this.getConsumedItems())).findFirst().map(RecipeHolder::value);
    }

    private void dispenseItem(Level level, ItemStack stack, BlockPos pos) {
        Direction facing = Direction.UP;
        double x = (double)pos.getX() + 0.7 * (double)facing.getStepX();
        double y = (double)pos.getY() + 0.7 * (double)facing.getStepY() - 0.125;
        double z = (double)pos.getZ() + 0.7 * (double)facing.getStepZ();
        ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack);
        double g = level.random.nextDouble() * 0.1 + 0.2;
        itemEntity.setDeltaMovement(level.random.triangle((double)facing.getStepX() * g, 0.103365), level.random.triangle(0.2, 0.103365), level.random.triangle((double)facing.getStepZ() * g, 0.103365));
        level.addFreshEntity((Entity)itemEntity);
    }

    private void fail(@Nullable Player player, String reason) {
        Level world = this.getWorld();
        if (world == null || this.getPos() == null) {
            return;
        }
        for (ItemStack consumedItem : this.getConsumedItems()) {
            this.dispenseItem(world, consumedItem, this.getPos());
        }
        this.dispenseItem(world, new ItemStack((ItemLike)RitualRegistry.getRitualItemMap().get(this.getRegistryName())), this.getPos());
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)reason));
        this.setFinished();
    }

    public void onStart(@Nullable Player player) {
        super.onStart(player);
        Level world = this.getWorld();
        if (world == null || this.getPos() == null) {
            this.fail(player, "chat.ars_additions.ritual_locate_structure.failed");
            return;
        }
        if (this.recipe == null) {
            this.recipe = this.getRecipe();
        }
        if (this.recipe.isEmpty()) {
            this.fail(player, "chat.ars_additions.ritual_locate_structure.failed");
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        LocateStructureRecipe locator = this.recipe.get();
        LocateUtil.locate(serverLevel, locator.getStructureHolder(serverLevel), this.getPos(), locator.getRadius(), locator.getSkipExisting(), pair -> {
            if (pair == null) {
                this.fail(player, "chat.ars_additions.ritual_locate_structure.not_found");
                return;
            }
            BlockPos pos = (BlockPos)pair.getFirst();
            Holder structure = (Holder)pair.getSecond();
            ItemStack wayfinder = new ItemStack((ItemLike)AddonItemRegistry.WAYFINDER.get(), 1);
            structure.unwrapKey().map(key -> LangUtil.toTitleCase(key.location().getPath())).ifPresent(component -> wayfinder.set(AddonDataComponentRegistry.WAYFINDER_DATA, (Object)new WayfinderData((Component)component)));
            GlobalPos global = GlobalPos.of((ResourceKey)serverLevel.dimension(), (BlockPos)pos);
            wayfinder.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.of(global), false));
            this.dispenseItem(world, wayfinder, this.getPos());
            this.setFinished();
        });
    }

    protected void tick() {
    }

    public boolean canStart(@Nullable Player player) {
        this.recipe = this.getRecipe();
        return this.recipe.isPresent();
    }

    public boolean canConsumeItem(ItemStack stack) {
        return true;
    }

    public String getLangName() {
        return "Locate Structure";
    }

    public String getLangDescription() {
        return "Locate a nearby structure based on the augments.";
    }

    public ResourceLocation getRegistryName() {
        return RESOURCE_LOCATION;
    }
}

