/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.data;

import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public record HaversackData(GlobalPos pos, Direction side, Boolean active, List<ItemStack> items, Boolean loaded) {
    public static final Codec<HaversackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("bind_pos").forGetter(HaversackData::pos), (App)Direction.CODEC.optionalFieldOf("bind_side", (Object)Direction.UP).forGetter(HaversackData::side), (App)Codec.BOOL.optionalFieldOf("active", (Object)false).forGetter(HaversackData::active), (App)ItemStack.CODEC.listOf().optionalFieldOf("items", List.of()).forGetter(HaversackData::items), (App)Codec.BOOL.optionalFieldOf("Loaded", (Object)false).forGetter(HaversackData::loaded)).apply((Applicative)instance, HaversackData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HaversackData> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, HaversackData::pos, (StreamCodec)Direction.STREAM_CODEC, HaversackData::side, (StreamCodec)ByteBufCodecs.BOOL, HaversackData::active, (StreamCodec)ItemStack.LIST_STREAM_CODEC, HaversackData::items, (StreamCodec)ByteBufCodecs.BOOL, HaversackData::loaded, HaversackData::new);

    public static Optional<HaversackData> fromItemStack(ItemStack stack) {
        return Optional.ofNullable((HaversackData)stack.get(AddonDataComponentRegistry.HAVERSACK_DATA));
    }

    public HaversackData toggle() {
        return new HaversackData(this.pos, this.side, this.active == false, this.items, this.loaded);
    }

    public HaversackData toggleLoaded() {
        return new HaversackData(this.pos, this.side, this.active, this.items, this.loaded == false);
    }

    public HaversackData add(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        list.add(stack.copy());
        return new HaversackData(this.pos, this.side, this.active, list, this.loaded);
    }

    public HaversackData remove(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        if (list.removeIf(s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)stack))) {
            return new HaversackData(this.pos, this.side, this.active, list, this.loaded);
        }
        return this;
    }

    public HaversackData write(ItemStack stack) {
        return (HaversackData)stack.set(AddonDataComponentRegistry.HAVERSACK_DATA, (Object)this);
    }

    public boolean containsStack(ItemStack stack) {
        return this.items.stream().anyMatch(s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)stack));
    }

    @Nullable
    public FilterableItemHandler getItemHandler(Level level) {
        if (!level.isLoaded(this.pos.pos())) {
            return null;
        }
        BlockEntity be = level.getBlockEntity(this.pos.pos());
        if (be == null) {
            return null;
        }
        return new FilterableItemHandler((IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, this.pos.pos(), (Object)this.side), InvUtil.filtersOnTile((BlockEntity)be));
    }
}

