/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.curios;

import com.github.jarva.arsadditions.common.item.data.CharmData;
import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.item.ArsNouveauCurio;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber(modid="ars_additions", bus=EventBusSubscriber.Bus.GAME)
public class Charm
extends ArsNouveauCurio {
    private final int uses;

    public Charm(int uses) {
        super(AddonItemRegistry.defaultItemProperties().stacksTo(1).durability(uses).component(AddonDataComponentRegistry.CHARM_DATA, (Object)new CharmData(uses)));
        this.uses = uses;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip2, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        tooltip2.add((Component)Component.translatable((String)"tooltip.ars_additions.charm.desc").withStyle(ChatFormatting.GRAY));
        int charges = CharmData.getOrDefault(stack, this.uses).charges();
        tooltip2.add((Component)Component.translatable((String)"tooltip.ars_additions.charm.charges", (Object[])new Object[]{charges, this.uses}).withStyle(ChatFormatting.GOLD));
        String descKey = Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this));
        tooltip2.add((Component)Component.translatable((String)descKey).withStyle(ChatFormatting.GRAY));
    }

    public int getMaxDamage(ItemStack stack) {
        return this.uses;
    }

    public int getDamage(ItemStack stack) {
        return this.uses - CharmData.getOrDefault(stack, this.uses).charges();
    }

    public boolean isBarVisible(ItemStack stack) {
        int charges = CharmData.getOrDefault(stack, this.uses).charges();
        return charges != this.uses;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return super.canElytraFly(stack, entity);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return CharmRegistry.isEnabled(stack);
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return this.isEnderMask((LivingEntity)player, endermanEntity);
    }

    public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        return this.isEnderMask(slotContext.entity(), enderMan);
    }

    public boolean isEnderMask(LivingEntity entity, EnderMan enderMan) {
        return CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.ENDER_MASK, () -> {
            Vec3 view = entity.getViewVector(1.0f).normalize();
            Vec3 vec = new Vec3(enderMan.getX() - entity.getX(), enderMan.getEyeY() - entity.getEyeY(), enderMan.getZ() - entity.getZ());
            double d0 = vec.length();
            double d1 = view.dot(vec = vec.normalize());
            return d1 > 1.0 - 0.025 / d0 && entity.hasLineOfSight((Entity)enderMan);
        }, (e, curio) -> CharmRegistry.every(10, entity, 1));
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.makesPiglinsNeutral(slotContext.entity());
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.makesPiglinsNeutral(wearer);
    }

    public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return CharmRegistry.isEnabled(CharmRegistry.CharmType.GOLDEN, wearer);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return this.canWalkOnPowderedSnow(wearer);
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return this.canWalkOnPowderedSnow(slotContext.entity());
    }

    public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        return CharmRegistry.processCharmEvent(wearer, CharmRegistry.CharmType.POWDERED_SNOW_WALK, () -> true, (entity, curio) -> CharmRegistry.every(10, entity, 1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.tick(stack, livingEntity);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.tick(stack, slotContext.entity());
    }

    public void tick(ItemStack stack, LivingEntity entity) {
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.FALL_PREVENTION, () -> entity.fallDistance > 3.0f, (e, curio) -> {
            e.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 100));
            return 1;
        });
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.NIGHT_VISION, () -> {
            int brightness = entity.level().getRawBrightness(entity.blockPosition(), entity.level().getSkyDarken());
            MobEffectInstance nightvision = entity.getEffect(MobEffects.NIGHT_VISION);
            return brightness < 5 && (nightvision == null || nightvision.getDuration() <= 200);
        }, (e, curio) -> {
            e.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 600));
            return 1;
        });
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.VOID_PROTECTION, () -> {
            if (!entity.onGround()) {
                return false;
            }
            BlockPos below = entity.blockPosition().below();
            return entity.level().getBlockState(below).isRedstoneConductor((BlockGetter)entity.level(), below);
        }, (e, curio) -> {
            GlobalPos pos = GlobalPos.of((ResourceKey)e.level().dimension(), (BlockPos)e.blockPosition());
            LodestoneTracker tracker = new LodestoneTracker(Optional.of(pos), false);
            curio.set(DataComponents.LODESTONE_TRACKER, (Object)tracker);
            return 0;
        });
    }

    @SubscribeEvent
    public static void handeUndying(LivingDeathEvent event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.UNDYING, () -> event.getEntity() instanceof Player, (entity, curio) -> {
            entity.setHealth(1.0f);
            entity.removeAllEffects();
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            entity.level().broadcastEntityEvent((Entity)entity, (byte)35);
            event.setCanceled(true);
            return 1;
        });
    }

    @SubscribeEvent
    public static void handleDamage(LivingDamageEvent.Pre event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.FIRE_RESISTANCE, () -> event.getSource().is(DamageTypeTags.IS_FIRE), (entity, curio) -> {
            event.setNewDamage(0.0f);
            if (event.getSource().is(DamageTypes.LAVA)) {
                return CharmRegistry.every(10, entity, (int)event.getOriginalDamage());
            }
            return (int)event.getOriginalDamage();
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.WATER_BREATHING, () -> event.getSource().is(DamageTypeTags.IS_DROWNING), (entity, curio) -> {
            event.setNewDamage(0.0f);
            return (int)event.getOriginalDamage();
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.VOID_PROTECTION, () -> event.getSource().is(DamageTypes.FELL_OUT_OF_WORLD), (entity, curio) -> {
            event.setNewDamage(0.0f);
            Level patt0$temp = entity.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                LodestoneTracker tracker = (LodestoneTracker)curio.get(DataComponents.LODESTONE_TRACKER);
                if (tracker != null) {
                    tracker.target().ifPresent(pos -> {
                        TeleportUtil.teleport(serverLevel.getServer().getLevel(pos.dimension()), pos.pos(), entity.getRotationVector(), (Entity)entity);
                        entity.resetFallDistance();
                    });
                }
            }
            return 1;
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.SONIC_BOOM_PROTECTION, () -> event.getSource().is(DamageTypes.SONIC_BOOM), (entity, curio) -> {
            event.setNewDamage(0.0f);
            return 1;
        });
    }

    @SubscribeEvent
    public static void denyMobEffects(MobEffectEvent.Applicable event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.WITHER_PROTECTION, () -> event.getEffectInstance().getEffect().equals((Object)MobEffects.WITHER), (entity, curio) -> {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            return CharmRegistry.every(2, entity, 1);
        });
    }

    @SubscribeEvent
    public static void handeDispel(DispelEvent.Pre event) {
        EntityHitResult entityHitResult;
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitResult;
            CharmRegistry.processCharmEvent(livingEntity, CharmRegistry.CharmType.DISPEL_PROTECTION, () -> !event.shooter.equals((Object)livingEntity), (entity, curio) -> {
                event.setCanceled(true);
                return 1;
            });
        }
    }
}

