/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.common.item.data.HaversackData;
import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.server.util.PlayerInvUtil;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="ars_additions", bus=EventBusSubscriber.Bus.GAME)
public class HandyHaversack
extends Item
implements IScribeable {
    public HandyHaversack() {
        super(new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % 10L == 0L) {
            return;
        }
        HaversackData.fromItemStack(stack).ifPresent(data -> {
            boolean loaded = level.getServer().getLevel(data.pos().dimension()).isLoaded(data.pos().pos());
            if (data.loaded() != loaded) {
                data.toggleLoaded().write(stack);
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            return super.use(level, player, usedHand);
        }
        ItemStack stack = player.getItemInHand(usedHand);
        return HaversackData.fromItemStack(stack).map(data -> {
            if (player.isShiftKeyDown()) {
                HaversackData updated = data.toggle();
                if (updated.active().booleanValue()) {
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.on"));
                } else {
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.off"));
                }
                updated.write(stack);
                return InteractionResultHolder.consume((Object)stack);
            }
            InteractionHand otherHand = usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack write = player.getItemInHand(otherHand);
            this.writeStack(player, stack, write);
            return InteractionResultHolder.success((Object)stack);
        }).orElse(InteractionResultHolder.fail((Object)stack));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (!context.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (context.getLevel().isClientSide()) {
            return InteractionResult.CONSUME;
        }
        BlockPos pos = context.getClickedPos();
        BlockEntity be = context.getLevel().getBlockEntity(pos);
        if (be == null) {
            return InteractionResult.PASS;
        }
        IItemHandler handler = (IItemHandler)context.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler != null) {
            ItemStack stack = context.getItemInHand();
            HaversackData data = new HaversackData(new GlobalPos(context.getLevel().dimension(), pos), context.getClickedFace(), true, new ArrayList<ItemStack>(), false);
            stack.set(AddonDataComponentRegistry.HAVERSACK_DATA, (Object)data);
            if (context.getPlayer() != null) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.bound", (Object[])new Object[]{LangUtil.container()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean overrideStackedOnOther(ItemStack haversack, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player) && slot.container instanceof Inventory) {
            ItemStack other = slot.getItem();
            return this.transportItem(haversack, other, player, arg_0 -> ((Slot)slot).set(arg_0));
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack haversack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            return this.transportItem(haversack, other, player, arg_0 -> ((SlotAccess)access).set(arg_0));
        }
        return false;
    }

    public boolean transportItem(ItemStack haversack, ItemStack other, Player player, Consumer<ItemStack> update) {
        if (player.isCreative()) {
            return true;
        }
        Optional<HaversackData> dataOpt = HaversackData.fromItemStack(haversack);
        if (dataOpt.isEmpty()) {
            return true;
        }
        HaversackData data = dataOpt.get();
        FilterableItemHandler handler = data.getItemHandler(player.level());
        if (handler == null) {
            return true;
        }
        InventoryManager manager = new InventoryManager(List.of(handler));
        ItemStack remainder = manager.insertStack(other.copy());
        update.accept(remainder);
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        HaversackData.fromItemStack(stack).ifPresentOrElse(data -> {
            tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.warp_index.bound", (Object[])new Object[]{data.pos().pos().getX(), data.pos().pos().getY(), data.pos().pos().getZ(), data.pos().dimension().location().toString()}));
            if (!data.items().isEmpty()) {
                if (data.active().booleanValue()) {
                    tooltip.add((Component)Component.translatable((String)"ars_nouveau.on"));
                } else {
                    tooltip.add((Component)Component.translatable((String)"ars_nouveau.off"));
                }
            }
            for (ItemStack item : data.items()) {
                tooltip.add(item.getHoverName());
            }
        }, () -> tooltip.add((Component)Component.translatable((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use"), LangUtil.container()})));
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue())) {
            tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.handy_haversack.instructions"));
        }
    }

    public boolean writeStack(Player player, ItemStack haversack, ItemStack write) {
        return HaversackData.fromItemStack(haversack).map(data -> {
            if (write.isEmpty()) {
                return false;
            }
            if (data.containsStack(write)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_removed"));
                data.remove(write).write(haversack);
                return true;
            }
            data.add(write).write(haversack);
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_added"));
            return true;
        }).orElseGet(() -> {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"chat.ars_additions.handy_haversack.invalid"));
            return false;
        });
    }

    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack haversack) {
        return this.writeStack(player, haversack, player.getItemInHand(handIn));
    }

    public static void tryStoreStack(Player player, ItemStack pickedUp, Consumer<ItemStack> remainder) {
        ItemStack haversack = PlayerInvUtil.findItem(player, stack -> stack.is((Item)AddonItemRegistry.HANDY_HAVERSACK.get()), ItemStack.EMPTY, Function.identity());
        if (haversack.isEmpty()) {
            return;
        }
        Item item = haversack.getItem();
        if (item instanceof HandyHaversack) {
            HandyHaversack handyHaversack = (HandyHaversack)item;
            HaversackData.fromItemStack(haversack).ifPresent(data -> {
                if (data.containsStack(pickedUp) && data.active().booleanValue()) {
                    handyHaversack.transportItem(haversack, pickedUp, player, remainder);
                }
            });
        }
    }

    @SubscribeEvent
    public static void entityPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemStack pickedUp = event.getItemEntity().getItem();
        HandyHaversack.tryStoreStack(player, pickedUp, remainder -> pickedUp.setCount(remainder.getCount()));
    }
}

