/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions;

import com.github.jarva.arsadditions.ArsAdditionsClient;
import com.github.jarva.arsadditions.common.advancement.Triggers;
import com.github.jarva.arsadditions.common.util.DispenserExperienceGemBehavior;
import com.github.jarva.arsadditions.setup.config.CommonConfig;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.github.jarva.arsadditions.setup.registry.AddonSetup;
import com.github.jarva.arsadditions.setup.registry.ArsNouveauRegistry;
import com.github.jarva.arsadditions.setup.registry.MarkDataRegistry;
import com.github.jarva.arsadditions.setup.registry.ModifyTagRegistry;
import com.hollingsworth.arsnouveau.api.registry.GenericRecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ars_additions")
public class ArsAdditions {
    public static final String MODID = "ars_additions";
    public static final Logger LOGGER = LogManager.getLogger();

    public ArsAdditions(IEventBus modEventBus, ModContainer modContainer) {
        AddonSetup.registers(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_SPEC);
        ArsNouveauRegistry.init();
        modEventBus.addListener(this::common);
        modEventBus.addListener(this::client);
        modEventBus.addListener(this::post);
        modEventBus.addListener(e -> {
            e.register(MarkDataRegistry.MARK_DATA_REGISTRY);
            e.register(ModifyTagRegistry.TAG_MODIFIER_REGISTRY);
        });
        Triggers.init();
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void common(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> GenericRecipeRegistry.reloadAll((RecipeManager)e.getServer().getRecipeManager()));
    }

    private void client(FMLClientSetupEvent event) {
        ArsAdditionsClient.clientSetup();
    }

    public void post(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)ItemsRegistry.EXPERIENCE_GEM, (DispenseItemBehavior)new DispenserExperienceGemBehavior());
            DispenserBlock.registerBehavior((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM, (DispenseItemBehavior)new DispenserExperienceGemBehavior());
        });
    }
}

