/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.tconfig.TConfig;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public class EMFConfig
extends TConfig {
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public boolean attemptRevertingEntityModelsAlteredByAnotherMod = true;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public PhysicsModCompatChoice attemptPhysicsModPatch_2 = PhysicsModCompatChoice.CUSTOM;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public ETFConfig.String2EnumNullMap<RenderModeChoice> entityRenderModeOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<PhysicsModCompatChoice> entityPhysicsModPatchOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<VanillaModelRenderMode> entityVanillaHologramOverrides = new ETFConfig.String2EnumNullMap();
    public ObjectOpenHashSet<String> modelsNamesDisabled = new ObjectOpenHashSet();
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;
    public boolean retainDetailOnLargerMobs = true;
    public boolean animationFrameSkipDuringIrisShadowPass = true;
    public boolean preventFirstPersonHandAnimating = false;
    public boolean onlyClientPlayerModel = false;
    public boolean doubleChestAnimFix = true;
    public boolean variationRequiresDefaultModel = true;
    public boolean resetPlayerModelEachRender = true;
    public boolean onlyDebugRenderOnHover = false;
    public boolean enforceOptifineSubFoldersVariantOnly = true;
    public boolean enforceOptiFineAnimSyntaxLimits = true;

    public RenderModeChoice getRenderModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.renderModeChoice;
        }
        return Objects.requireNonNullElseGet((RenderModeChoice)this.entityRenderModeOverrides.getNullable(typeString), () -> this.renderModeChoice);
    }

    public PhysicsModCompatChoice getPhysicsModModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.attemptPhysicsModPatch_2;
        }
        return Objects.requireNonNullElseGet((PhysicsModCompatChoice)this.entityPhysicsModPatchOverrides.getNullable(typeString), () -> this.attemptPhysicsModPatch_2);
    }

    public VanillaModelRenderMode getVanillaHologramModeFor(EMFEntity entity) {
        String typeString = EMFConfig.getTypeString(entity);
        if (typeString == null) {
            return this.vanillaModelHologramRenderMode_2;
        }
        return Objects.requireNonNullElseGet((VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(typeString), () -> this.vanillaModelHologramRenderMode_2);
    }

    @Nullable
    private static String getTypeString(EMFEntity entity) {
        if (entity instanceof BlockEntity) {
            BlockEntity block = (BlockEntity)entity;
            return ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)block.getType());
        }
        if (entity instanceof Entity) {
            Entity realBoy = (Entity)entity;
            return realBoy.getType().getDescriptionId();
        }
        return null;
    }

    public boolean isModelDisabled(String modelName) {
        return this.modelsNamesDisabled.contains((Object)modelName);
    }

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.models_main").add(new TConfigEntry[]{new TConfigEntryCategory("entity_model_features.config.options", "entity_model_features.config.options.tooltip").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.force_models", "entity_model_features.config.force_models.tooltip", () -> this.attemptRevertingEntityModelsAlteredByAnotherMod, value -> {
            this.attemptRevertingEntityModelsAlteredByAnotherMod = value;
        }, true), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> this.attemptPhysicsModPatch_2, value -> {
            this.attemptPhysicsModPatch_2 = value;
        }, (Enum)PhysicsModCompatChoice.CUSTOM), new TConfigEntryBoolean("entity_model_features.config.ebe_config_modify", "entity_model_features.config.ebe_config_modify.tooltip", () -> this.allowEBEModConfigModify, value -> {
            this.allowEBEModConfigModify = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.double_chest_fix", "entity_model_features.config.double_chest_fix.tooltip", () -> this.doubleChestAnimFix, value -> {
            this.doubleChestAnimFix = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.player_settings").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.prevent_hand", "entity_model_features.config.prevent_hand.tooltip", () -> this.preventFirstPersonHandAnimating, value -> {
            this.preventFirstPersonHandAnimating = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.only_client", "entity_model_features.config.only_client.tooltip", () -> this.onlyClientPlayerModel, value -> {
            this.onlyClientPlayerModel = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.reset_player", "entity_model_features.config.reset_player.tooltip", () -> this.resetPlayerModelEachRender, value -> {
            this.resetPlayerModelEachRender = value;
        }, false)}), new TConfigEntryCategory("entity_model_features.config.performance").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.update", "entity_model_features.config.update.tooltip", () -> this.modelUpdateFrequency, value -> {
            this.modelUpdateFrequency = value;
        }, (Enum)ETFConfig.UpdateFrequency.Average), new TConfigEntryInt("entity_model_features.config.lod", "entity_model_features.config.lod.tooltip", () -> this.animationLODDistance, value -> {
            this.animationLODDistance = value;
        }, 20, 0, 65, true, true), new TConfigEntryBoolean("entity_model_features.config.low_fps_lod", "entity_model_features.config.low_fps_lod.tooltip", () -> this.retainDetailOnLowFps, value -> {
            this.retainDetailOnLowFps = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.large_mob_lod", "entity_model_features.config.large_mob_lod.tooltip", () -> this.retainDetailOnLargerMobs, value -> {
            this.retainDetailOnLargerMobs = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.iris_shadow_skip", "entity_model_features.config.iris_shadow_skip.tooltip", () -> this.animationFrameSkipDuringIrisShadowPass, value -> {
            this.animationFrameSkipDuringIrisShadowPass = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.tools", "entity_model_features.config.tools.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> this.vanillaModelHologramRenderMode_2, value -> {
            this.vanillaModelHologramRenderMode_2 = value;
        }, (Enum)VanillaModelRenderMode.OFF), new TConfigEntryEnumSlider("entity_model_features.config.print_mode", "entity_model_features.config.print_mode.tooltip", () -> this.modelExportMode, value -> {
            this.modelExportMode = value;
        }, (Enum)ModelPrintMode.NONE)}), new TConfigEntryCategory("entity_model_features.config.debug", "entity_model_features.config.debug.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> this.renderModeChoice, value -> {
            this.renderModeChoice = value;
        }, (Enum)RenderModeChoice.NORMAL), new TConfigEntryBoolean("entity_model_features.config.debug_hover", "entity_model_features.config.debug_hover.tooltip", () -> this.onlyDebugRenderOnHover, value -> {
            this.onlyDebugRenderOnHover = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.log_models", "entity_model_features.config.log_models.tooltip", () -> this.logModelCreationData, value -> {
            this.logModelCreationData = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.debug_right_click", "entity_model_features.config.debug_right_click.tooltip", () -> this.debugOnRightClick, value -> {
            this.debugOnRightClick = value;
        }, false)}), this.getModelSettings(), this.getMathInfo()}), this.getEntitySettings(), new TConfigEntryCategory("config.entity_features.optifine_settings", "config.entity_texture_features.optifine.desc").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.variation_base", "entity_model_features.config.variation_base.tooltip", () -> this.variationRequiresDefaultModel, value -> {
            this.variationRequiresDefaultModel = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_subfolders", "entity_model_features.config.optifine_subfolders.tooltip", () -> this.enforceOptifineSubFoldersVariantOnly, value -> {
            this.enforceOptifineSubFoldersVariantOnly = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.optifine_syntax", "entity_model_features.config.optifine_syntax.tooltip", () -> this.enforceOptiFineAnimSyntaxLimits, value -> {
            this.enforceOptiFineAnimSyntaxLimits = value;
        }, true)})});
    }

    private TConfigEntryCategory getMathInfo() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.math");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.math.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        TConfigEntryCategory variables = new TConfigEntryCategory("entity_model_features.config.variables");
        category.add((TConfigEntry)variables);
        variables.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.variables.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        for (UniqueVariableFactory uniqueVariableFactory : VariableRegistry.getInstance().getUniqueVariableFactories()) {
            TConfigEntryCategory unique = new TConfigEntryCategory(uniqueVariableFactory.getTitleTranslationKey()).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)uniqueVariableFactory.getExplanationTranslationKey(), (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        }
        VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().get(key);
            TConfigEntryCategory unique = new TConfigEntryCategory(key).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        });
        TConfigEntryCategory methods = new TConfigEntryCategory("entity_model_features.config.functions");
        category.add((TConfigEntry)methods);
        methods.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.functions.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        MethodRegistry.getInstance().getMethodExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = MethodRegistry.getInstance().getMethodExplanationTranslationKeys().get(key);
            TConfigEntryCategory method = new TConfigEntryCategory(key + "()").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            methods.add((TConfigEntry)method);
        });
        return category;
    }

    private TConfigEntryCategory getModelSettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.models");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models_text", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        EMFManager.getInstance().cache_LayersByModelName.put((Object)new EMFModel_ID("wolf_collar"), (Object)ModelLayers.WOLF);
        EMFManager.getInstance().cache_LayersByModelName.keySet().stream().sorted().forEach(mapData -> {
            LayerDefinition vanilla;
            ModelLayerLocation layer = (ModelLayerLocation)EMFManager.getInstance().cache_LayersByModelName.get(mapData);
            if (layer != null && (vanilla = (LayerDefinition)Minecraft.getInstance().getEntityModels().roots.get(layer)) != null) {
                String namespace = "minecraft".equals(mapData.getNamespace()) ? "" : mapData.getNamespace() + ":";
                String fileName = namespace + mapData.getfileName();
                TConfigEntryCategory model = new TConfigEntryCategory(fileName + ".jem");
                model.setAlign(TConfigScreenList.Align.RIGHT);
                model.setWidgetBackgroundToFullWidth();
                model.setRenderFeature((TConfigScreenList.Renderable)new ModelRootRenderer(layer));
                category.add((TConfigEntry)model);
                EMFModel_ID second = mapData.getSecondaryModel();
                model.add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.models.enabled", "entity_model_features.config.models.enabled.tooltip", () -> !this.modelsNamesDisabled.contains((Object)fileName), value -> {
                    if (value.booleanValue()) {
                        this.modelsNamesDisabled.remove((Object)fileName);
                    } else {
                        this.modelsNamesDisabled.add((Object)fileName);
                    }
                }, true), new TConfigEntryCategory("entity_model_features.config.models.part_names").addAll(this.getmappings(mapData.getMapId())), this.getExport((EMFModel_ID)mapData, layer), new TConfigEntryCategory("entity_model_features.config.models.file_names").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)("<Folders>\nassets/" + mapData.getNamespace() + "/emf/cem/\nassets/" + mapData.getNamespace() + "/optifine/cem/\n\n<possible model names, checked in order>\n" + mapData.getfileName() + ".jem" + (String)(second == null ? "" : "\n" + second.getfileName() + ".jem\n")), (int)600, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.CENTER))}).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.explain", (int)100, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            }
        });
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.arrows", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.cape", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        return category;
    }

    @NotNull
    private TConfigEntry getExport(EMFModel_ID key, ModelLayerLocation layer) {
        TConfigEntryText.TwoLines export;
        try {
            Objects.requireNonNull(key.getMapId());
            Objects.requireNonNull((LayerDefinition)Minecraft.getInstance().getEntityModels().roots.get(layer));
            export = new TConfigEntryCustomButton("entity_model_features.config.models.export", "entity_model_features.config.models.export.tooltip", button -> {
                ModelPrintMode old = this.modelExportMode;
                this.modelExportMode = ModelPrintMode.ALL_LOG_AND_JEM;
                try {
                    EMFModelMappings.getMapOf(key.getMapId(), ((LayerDefinition)Minecraft.getInstance().getEntityModels().roots.get(layer)).bakeRoot(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.modelExportMode = old;
                button.active = false;
                button.setMessage((Component)Component.translatable((String)"entity_model_features.config.models.export.success"));
            });
        }
        catch (Exception e) {
            export = new TConfigEntryText.TwoLines("entity_model_features.config.models.export.fail", e.getMessage());
        }
        return export;
    }

    private Collection<TConfigEntry> getmappings(String mapKey) {
        Map<String, String> map;
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        if (EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.containsKey(mapKey)) {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.optifine_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.OPTIFINE_MODEL_MAP_CACHE.get(mapKey);
        } else {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.unknown_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFModelMappings.UNKNOWN_MODEL_MAP_CACHE.get(mapKey);
        }
        if (map == null) {
            return List.of();
        }
        for (String entry : map.keySet()) {
            list.add((TConfigEntry)new TConfigEntryText(entry));
        }
        return list;
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
                String translationKey = entityType.getDescriptionId();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            BlockEntityRenderers.PROVIDERS.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.models_main");
        entityCategory.add((TConfigEntry)category);
        category.add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> (RenderModeChoice)this.entityRenderModeOverrides.getNullable(translationKey), layer -> this.entityRenderModeOverrides.putNullable(translationKey, (Enum)layer), null, RenderModeChoice.class), new TConfigEntryEnumButton("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> (VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(translationKey), layer -> this.entityVanillaHologramOverrides.putNullable(translationKey, (Enum)layer), null, VanillaModelRenderMode.class), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> (PhysicsModCompatChoice)this.entityPhysicsModPatchOverrides.getNullable(translationKey), layer -> this.entityPhysicsModPatchOverrides.putNullable(translationKey, (Enum)layer), null, PhysicsModCompatChoice.class)});
    }

    public ResourceLocation getModIcon() {
        return EMFUtils.res("entity_model_features", "textures/gui/icon.png");
    }

    public static enum RenderModeChoice {
        NORMAL((Component)Component.translatable((String)"entity_model_features.config.render.normal")),
        GREEN((Component)Component.translatable((String)"entity_model_features.config.render.green")),
        LINES_AND_TEXTURE((Component)Component.translatable((String)"entity_model_features.config.render.lines_texture")),
        LINES_AND_TEXTURE_FLASH((Component)Component.translatable((String)"entity_model_features.config.render.lines_texture_flash")),
        LINES((Component)Component.translatable((String)"entity_model_features.config.render.lines")),
        NONE((Component)Component.translatable((String)"entity_model_features.config.render.none"));

        private final String text;

        private RenderModeChoice(Component text) {
            this.text = text.getString();
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum VanillaModelRenderMode {
        OFF(CommonComponents.OPTION_OFF),
        NORMAL((Component)Component.translatable((String)"entity_model_features.config.vanilla_render.normal")),
        OFFSET((Component)Component.translatable((String)"entity_model_features.config.vanilla_render.offset"));

        private final Component text;

        private VanillaModelRenderMode(Component text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum ModelPrintMode {
        NONE(CommonComponents.OPTION_OFF),
        LOG_ONLY((Component)Component.translatable((String)"entity_model_features.config.print_mode.log")),
        LOG_AND_JEM((Component)Component.translatable((String)"entity_model_features.config.print_mode.log_jem")),
        ALL_LOG_ONLY((Component)Component.translatable((String)"entity_model_features.config.print_mode.all_log")),
        ALL_LOG_AND_JEM((Component)Component.translatable((String)"entity_model_features.config.print_mode.all_log_jem"));

        private final Component text;

        private ModelPrintMode(Component text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum PhysicsModCompatChoice {
        OFF(CommonComponents.OPTION_OFF),
        VANILLA((Component)Component.translatable((String)"entity_model_features.config.physics.1")),
        CUSTOM((Component)Component.translatable((String)"entity_model_features.config.physics.2"));

        private final Component text;

        private PhysicsModCompatChoice(Component text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    private static class ModelRootRenderer
    implements TConfigScreenList.Renderable {
        private final ModelLayerLocation layer;
        private ModelPart root = null;
        private boolean asserted = false;

        ModelRootRenderer(ModelLayerLocation layer) {
            this.layer = layer;
        }

        private boolean canRender() {
            if (!this.asserted && this.root == null) {
                this.asserted = true;
                try {
                    this.root = ((LayerDefinition)Minecraft.getInstance().getEntityModels().roots.get(this.layer)).bakeRoot();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.root != null;
        }

        public void render(GuiGraphics context, int mouseX, int mouseY) {
            if (this.canRender()) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen == null) {
                    return;
                }
                int y = (int)((double)screen.height * 0.75);
                int x = (int)((double)screen.width * 0.33);
                float g = (float)(-Math.atan(((float)(-mouseY) + (float)screen.height / 2.0f) / 40.0f));
                float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)screen.width / 3.0f) / 400.0f));
                Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2 * 8.0f);
                Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)) * 2.0f);
                quaternionf.mul((Quaternionfc)quaternionf2);
                context.pose().pushPose();
                context.pose().translate((double)x, (double)y, 150.0);
                float scaling = (float)((double)screen.height * 0.3);
                context.pose().mulPose(new Matrix4f().scaling(scaling, scaling, -scaling));
                context.pose().mulPose(quaternionf);
                Lighting.setupForEntityInInventory();
                PoseStack matrixStack = context.pose();
                matrixStack.pushPose();
                matrixStack.scale(-1.0f, -1.0f, 1.0f);
                matrixStack.translate(0.0f, -1.501f, 0.0f);
                VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
                if (buffer != null) {
                    this.renderBoxes(matrixStack, buffer, this.root);
                }
                matrixStack.popPose();
            }
        }

        private void renderBoxes(PoseStack matrices, VertexConsumer vertices, ModelPart modelPart) {
            if (!(!modelPart.visible || modelPart.cubes.isEmpty() && modelPart.children.isEmpty())) {
                matrices.pushPose();
                modelPart.translateAndRotate(matrices);
                if (!modelPart.skipDraw) {
                    for (ModelPart.Cube cuboid : modelPart.cubes) {
                        AABB box = new AABB((double)(cuboid.minX / 16.0f), (double)(cuboid.minY / 16.0f), (double)(cuboid.minZ / 16.0f), (double)(cuboid.maxX / 16.0f), (double)(cuboid.maxY / 16.0f), (double)(cuboid.maxZ / 16.0f));
                        LevelRenderer.renderLineBox((PoseStack)matrices, (VertexConsumer)vertices, (AABB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                for (ModelPart modelPartChildren : modelPart.children.values()) {
                    this.renderBoxes(matrices, vertices, modelPartChildren);
                }
                matrices.popPose();
            }
        }
    }
}

