/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryHandler {
    public static final Set<String> SINGLE_IDENTIFIER = Collections.singleton("");
    private final Supplier<Set<String>> identifiersGetter;
    private final SlotCountGetter slotCountGetter;
    private final SlotStackGetter slotStackGetter;

    public PlayerInventoryHandler(Supplier<Set<String>> identifiersGetter, SlotCountGetter slotCountGetter, SlotStackGetter slotStackGetter) {
        this.identifiersGetter = identifiersGetter;
        this.slotCountGetter = slotCountGetter;
        this.slotStackGetter = slotStackGetter;
    }

    public int getSlotCount(Player player, String identifier) {
        return this.slotCountGetter.getSlotCount(player, identifier);
    }

    public ItemStack getStackInSlot(Player player, String identifier, int slot) {
        return this.slotStackGetter.getStackInSlot(player, identifier, slot);
    }

    public Set<String> getIdentifiers() {
        return this.identifiersGetter.get();
    }

    public static interface SlotCountGetter {
        public int getSlotCount(Player var1, String var2);
    }

    public static interface SlotStackGetter {
        public ItemStack getStackInSlot(Player var1, String var2, int var3);
    }
}

