/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import reliquary.Reliquary;
import reliquary.items.util.IScrollableItem;

public record ScrolledItemPayload(double scrollDelta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ScrolledItemPayload> TYPE = new CustomPacketPayload.Type(Reliquary.getRL("scrolled_item"));
    public static final StreamCodec<FriendlyByteBuf, ScrolledItemPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, ScrolledItemPayload::scrollDelta, ScrolledItemPayload::new);

    public static void handlePayload(ScrolledItemPayload payload, IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof IScrollableItem) {
            IScrollableItem leftClickableItem = (IScrollableItem)item;
            leftClickableItem.onMouseScrolled(stack, player, payload.scrollDelta);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

