/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.init.ModDataComponents;
import reliquary.items.ItemBase;
import reliquary.items.component.OversizedComponentItemHandler;
import reliquary.items.component.OversizedItemContainerContents;
import reliquary.util.InventoryHelper;
import reliquary.util.RandHelper;

public abstract class ToggleableItem
extends ItemBase {
    protected static final int FIRST_SLOT = 0;

    protected ToggleableItem(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties, isDisabled);
    }

    protected ToggleableItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return this.isEnabled(stack);
    }

    protected void setCooldown(ItemStack stack, Level level, int cooldown) {
        stack.set(ModDataComponents.COOLDOWN_TIME, (Object)(level.getGameTime() + (long)cooldown));
    }

    protected boolean isInCooldown(ItemStack stack, Level level) {
        return (Long)stack.getOrDefault(ModDataComponents.COOLDOWN_TIME, (Object)0L) > level.getGameTime();
    }

    protected <T> T getFromHandler(ItemStack stack, Function<OversizedComponentItemHandler, T> getter) {
        return getter.apply(this.createHandler(stack));
    }

    protected void runOnHandler(ItemStack stack, Consumer<OversizedComponentItemHandler> runner) {
        runner.accept(this.createHandler(stack));
    }

    public OversizedComponentItemHandler createHandler(ItemStack stack) {
        int size = Math.max(stack.has(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS) ? ((OversizedItemContainerContents)stack.get(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS)).getSlots() : this.getContainerInitialSize(), this.getContainerInitialSize());
        return new OversizedComponentItemHandler(stack, ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS.get(), size, this::getContainerSlotLimit, this::isItemValidForContainerSlot, this::getStackWorth);
    }

    protected int getStackWorth(int slot) {
        return 1;
    }

    protected void removeContainerContents(ItemStack stack) {
        stack.remove(ModDataComponents.OVERSIZED_ITEM_CONTAINER_CONTENTS);
    }

    protected int getContainerInitialSize() {
        return 1;
    }

    protected int getContainerSlotLimit(ItemStack stack, int slot) {
        return this.getContainerSlotLimit(slot);
    }

    protected int getContainerSlotLimit(int slot) {
        return 64;
    }

    protected boolean isItemValidForContainerSlot(int slot, ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown()) {
            this.toggleEnabled(stack);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || oldStack.hasFoil() != newStack.hasFoil();
    }

    public boolean isEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENABLED, (Object)false);
    }

    void toggleEnabled(ItemStack stack) {
        stack.set(ModDataComponents.ENABLED, (Object)(!this.isEnabled(stack) ? 1 : 0));
    }

    protected void consumeAndCharge(Player player, int freeCapacity, int chargePerItem, Item item, int maxCount, IntConsumer addCharge) {
        this.consumeAndCharge(player, freeCapacity, chargePerItem, (ItemStack stack) -> stack.getItem() == item, maxCount, addCharge);
    }

    protected void consumeAndCharge(Player player, int freeCapacity, int chargePerItem, Predicate<ItemStack> itemMatches, int maxCount, IntConsumer addCharge) {
        int maximumToConsume = Math.min(freeCapacity / chargePerItem, maxCount);
        if (maximumToConsume == 0) {
            return;
        }
        int chargeToAdd = InventoryHelper.consumeItemStack(itemMatches, player, maximumToConsume).getCount() * chargePerItem;
        if (chargeToAdd > 0) {
            addCharge.accept(chargeToAdd);
        }
    }

    protected boolean addItemToContainer(ItemStack container, Item item, int chargeToAdd) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setCount(chargeToAdd);
        return this.getFromHandler(container, handler -> handler.insertItemOrAddIntoNewSlotIfNoStackMatches(stack)).isEmpty();
    }

    public boolean removeItemFromInternalStorage(ItemStack stack, int slot, int quantityToRemove, boolean simulate, Player player) {
        if (player.isCreative()) {
            return true;
        }
        return this.getFromHandler(stack, handler -> handler.extractItemAndRemoveSlotIfEmpty(slot, quantityToRemove, simulate)).getCount() == quantityToRemove;
    }
}

