/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import reliquary.init.ModItems;
import reliquary.items.MobCharmDefinition;
import reliquary.items.MobCharmItem;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;

public class MobCharmRegistry {
    private static final Map<ResourceLocation, MobCharmDefinition> REGISTERED_CHARM_DEFINITIONS = new HashMap<ResourceLocation, MobCharmDefinition>();
    private static final Map<ResourceLocation, MobCharmDefinition> ENTITY_NAME_CHARM_DEFINITIONS = new HashMap<ResourceLocation, MobCharmDefinition>();
    private static final Set<ResourceLocation> DYNAMICALLY_REGISTERED = new HashSet<ResourceLocation>();

    private MobCharmRegistry() {
    }

    public static void registerMobCharmDefinition(MobCharmDefinition charmDefinition) {
        REGISTERED_CHARM_DEFINITIONS.put(charmDefinition.getRegistryName(), charmDefinition);
        for (ResourceLocation registryName : charmDefinition.getEntities()) {
            ENTITY_NAME_CHARM_DEFINITIONS.put(registryName, charmDefinition);
        }
    }

    static Optional<MobCharmDefinition> getCharmDefinitionFor(Entity entity) {
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(RegistryHelper.getRegistryName(entity)));
    }

    public static Optional<MobCharmDefinition> getCharmDefinitionFor(ItemStack stack) {
        if (stack.getItem() != ModItems.MOB_CHARM.get()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(MobCharmItem.getEntityEggRegistryName(stack)));
    }

    public static Set<ResourceLocation> getRegisteredNames() {
        return REGISTERED_CHARM_DEFINITIONS.keySet();
    }

    public static void registerDynamicCharmDefinitions() {
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            ResourceLocation registryName = EntityType.getKey((EntityType)entityType);
            if (ENTITY_NAME_CHARM_DEFINITIONS.containsKey(registryName) || entityType.getCategory() != MobCategory.MONSTER || Config.COMMON.items.mobCharm.isBlockedEntity(registryName)) continue;
            MobCharmRegistry.registerMobCharmDefinition(new MobCharmDefinition(entityType));
            DYNAMICALLY_REGISTERED.add(registryName);
        }
    }

    public static void handleAddingFragmentDrops(LivingDropsEvent evt) {
        if (!evt.getSource().getMsgId().equals("player")) {
            return;
        }
        LivingEntity entity = evt.getEntity();
        ResourceLocation regName = RegistryHelper.getRegistryName((Entity)entity);
        if (!DYNAMICALLY_REGISTERED.contains(regName)) {
            return;
        }
        HolderLookup.RegistryLookup registrylookup = entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int lootingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.LOOTING), (LivingEntity)entity);
        double dynamicDropChance = (Double)Config.COMMON.items.mobCharmFragment.dropChance.get() + (double)lootingLevel * (Double)Config.COMMON.items.mobCharmFragment.lootingMultiplier.get();
        if ((double)entity.level().random.nextFloat() < dynamicDropChance) {
            ItemEntity fragmentItemEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(regName));
            fragmentItemEntity.setDefaultPickUpDelay();
            evt.getDrops().add(fragmentItemEntity);
        }
    }

    static {
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITHER_SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CREEPER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITCH);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIFIED_PIGLIN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CAVE_SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ENDERMAN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GHAST);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SLIME);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.MAGMA_CUBE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.BLAZE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GUARDIAN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.PIGLIN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.PIGLIN_BRUTE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.HOGLIN);
    }
}

