/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import reliquary.init.ModDataComponents;
import reliquary.items.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class MidasTouchstoneItem
extends ToggleableItem {
    private static final Map<Class<? extends Item>, IRepairableItem> REPAIRABLE_ITEMS = new ImmutableMap.Builder().put(TieredItem.class, item -> {
        Tier tier = ((TieredItem)item).getTier();
        return tier.equals((Object)Tiers.GOLD) || tier.equals((Object)Tiers.NETHERITE);
    }).put(ArmorItem.class, item -> {
        Holder material = ((ArmorItem)item).getMaterial();
        return material.equals((Object)ArmorMaterials.GOLD) || material.equals((Object)ArmorMaterials.NETHERITE);
    }).build();

    public MidasTouchstoneItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    protected void addMoreInformation(ItemStack touchstone, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", MidasTouchstoneItem.getGlowstoneCharge(touchstone));
        if (this.isEnabled(touchstone)) {
            tooltipBuilder.absorbActive(Items.GLOWSTONE_DUST.getName(new ItemStack((ItemLike)Items.GLOWSTONE_DUST)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean f) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.isEnabled(stack)) {
            int glowstoneCharge = MidasTouchstoneItem.getGlowstoneCharge(stack);
            this.consumeAndCharge(player, this.getGlowstoneLimit() - glowstoneCharge, this.getGlowStoneWorth(), Items.GLOWSTONE_DUST, 16, (int chargeToAdd) -> this.addGlowstoneCharge(stack, chargeToAdd));
        }
        this.doRepairAndDamageTouchstone(stack, player);
    }

    public static int getGlowstoneCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.GLOWSTONE, (Object)0);
    }

    private void addGlowstoneCharge(ItemStack stack, int chargeToAdd) {
        stack.set(ModDataComponents.GLOWSTONE, (Object)Math.max(MidasTouchstoneItem.getGlowstoneCharge(stack) + chargeToAdd, 0));
    }

    private void doRepairAndDamageTouchstone(ItemStack touchstone, Player player) {
        List goldItems = (List)Config.COMMON.items.midasTouchstone.goldItems.get();
        IItemHandler playerInventory = InventoryHelper.getItemHandlerFrom(player);
        if (playerInventory == null) {
            return;
        }
        for (int slot = 0; slot < playerInventory.getSlots(); ++slot) {
            ItemStack stack = playerInventory.getStackInSlot(slot);
            Item item = stack.getItem();
            if (stack.getDamageValue() <= 0 || !stack.has(DataComponents.DAMAGE)) continue;
            this.tryRepairingItem(touchstone, player, goldItems, stack, item);
        }
    }

    private void tryRepairingItem(ItemStack touchstone, Player player, List<String> goldItems, ItemStack stack, Item item) {
        Optional<IRepairableItem> repairableItem = this.getRepairableItem(item.getClass());
        if (repairableItem.isPresent() && repairableItem.get().materialMatches(item) || goldItems.contains(RegistryHelper.getItemRegistryName(item))) {
            this.repairItem(stack, touchstone, player);
        }
    }

    private void repairItem(ItemStack stack, ItemStack touchstone, Player player) {
        if (this.reduceTouchStoneCharge(touchstone, player)) {
            int damage = stack.getDamageValue();
            stack.setDamageValue(damage - Math.min(damage, 10));
        }
    }

    private boolean reduceTouchStoneCharge(ItemStack stack, Player player) {
        if (MidasTouchstoneItem.getGlowstoneCharge(stack) - this.getGlowStoneCost() >= 0 || player.isCreative()) {
            if (!player.isCreative()) {
                this.addGlowstoneCharge(stack, -this.getGlowStoneCost());
            }
            return true;
        }
        return false;
    }

    private int getGlowStoneCost() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneCost.get();
    }

    private int getGlowStoneWorth() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneWorth.get();
    }

    private int getGlowstoneLimit() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneLimit.get();
    }

    private Optional<IRepairableItem> getRepairableItem(Class<? extends Item> item) {
        for (Map.Entry<Class<? extends Item>, IRepairableItem> repairableItem : REPAIRABLE_ITEMS.entrySet()) {
            if (!repairableItem.getKey().isAssignableFrom(item)) continue;
            return Optional.of(repairableItem.getValue());
        }
        return Optional.empty();
    }

    private static interface IRepairableItem {
        public boolean materialMatches(Item var1);
    }
}

