/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.init.ModEntities;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionHelper;

public abstract class ShotBase
extends Projectile {
    private static final EntityDataAccessor<Byte> CRITICAL = SynchedEntityData.defineId(ShotBase.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ShotBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private PotionContents potionContents = PotionContents.EMPTY;
    protected int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;

    protected <T extends ShotBase> ShotBase(EntityType<T> entityType, Level level) {
        super(entityType, level);
    }

    protected <T extends ShotBase> ShotBase(EntityType<T> entityType, Level level, Player player, InteractionHand hand) {
        this(entityType, level);
        this.setOwner((Entity)player);
        this.moveTo(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), player.getYRot(), player.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * (float)(hand == InteractionHand.MAIN_HAND ? 1 : -1) * 0.16f), this.getY() - 0.2, this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * (float)(hand == InteractionHand.MAIN_HAND ? 1 : -1) * 0.16f));
    }

    protected Optional<Player> getShooterPlayer() {
        return Optional.ofNullable((Player)this.getOwner());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CRITICAL, (Object)0);
        builder.define(COLOR, (Object)0);
    }

    public ShotBase addPotionContents(PotionContents potionContents) {
        if (potionContents.hasEffects()) {
            this.potionContents = potionContents;
            this.entityData.set(COLOR, (Object)potionContents.getColor());
        }
        return this;
    }

    public void shoot(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float var9 = (float)Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ);
        motionX /= (double)var9;
        motionY /= (double)var9;
        motionZ /= (double)var9;
        motionX += this.random.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionY += this.random.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionZ += this.random.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.setDeltaMovement(motionX *= (double)velocity, motionY *= (double)velocity, motionZ *= (double)velocity);
        float var10 = (float)Math.sqrt(motionX * motionX + motionZ * motionZ);
        this.setYRot((float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI));
        this.setXRot((float)(Math.atan2(motionY, var10) * 180.0 / Math.PI));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void lerpMotion(double motionX, double motionY, double motionZ) {
        this.setDeltaMovement(motionX, motionY, motionZ);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float var7 = (float)Math.sqrt(motionX * motionX + motionZ * motionZ);
            this.setYRot((float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI));
            this.setXRot((float)(Math.atan2(motionY, var7) * 180.0 / Math.PI));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public void tick() {
        super.tick();
        if (this.ticksInAir > 200) {
            this.discard();
        }
        if (this.level().isClientSide) {
            this.spawnPotionParticles();
        }
        Vec3 motionVec = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float pythingy = (float)Math.sqrt(motionVec.x() * motionVec.x() + motionVec.z() * motionVec.z());
            this.setYRot((float)(Math.atan2(motionVec.x(), motionVec.z()) * 180.0 / Math.PI));
            this.setXRot((float)(Math.atan2(motionVec.y(), pythingy) * 180.0 / Math.PI));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        ++this.ticksInAir;
        if (this.ticksInAir == 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
            for (int particles = 0; particles < 3; ++particles) {
                this.doFiringEffects();
            }
        } else {
            this.doFlightEffects();
        }
        Vec3 posVector = new Vec3(this.getX(), this.getY(), this.getZ());
        Vec3 approachVector = new Vec3(this.getX() + motionVec.x(), this.getY() + motionVec.y(), this.getZ() + motionVec.z());
        BlockHitResult objectStruckByVector = this.level().clip(new ClipContext(posVector, approachVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Entity hitEntity = this.getHitEntity(motionVec, posVector, approachVector);
        if (hitEntity != null) {
            objectStruckByVector = new EntityHitResult(hitEntity);
        }
        if (objectStruckByVector != null) {
            this.applyPotionEffects((HitResult)objectStruckByVector);
            this.onHit((HitResult)objectStruckByVector);
        }
        if (this.scheduledForDeath) {
            this.discard();
        }
        Vec3 newPos = this.position().add(this.getDeltaMovement());
        this.setPos(newPos.x, newPos.y, newPos.z);
    }

    @Nullable
    private Entity getHitEntity(Vec3 motionVec, Vec3 posVector, Vec3 approachVector) {
        Entity hitEntity = null;
        List struckEntitiesInAABB = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(motionVec).inflate(1.0, 1.0, 1.0));
        double var7 = 0.0;
        for (Entity struckEntity : struckEntitiesInAABB) {
            double var14;
            if (!struckEntity.isPickable() || struckEntity == this.getOwner() && this.ticksInAir < 5) continue;
            float var11 = 0.5f;
            AABB var12 = struckEntity.getBoundingBox().inflate((double)var11, (double)var11, (double)var11);
            Optional hitResult = var12.clip(posVector, approachVector);
            if (!hitResult.isPresent() || !((var14 = posVector.distanceTo((Vec3)hitResult.get())) < var7) && var7 != 0.0) continue;
            hitEntity = struckEntity;
            var7 = var14;
        }
        return hitEntity;
    }

    private void spawnPotionParticles() {
        int color = this.getColor();
        if (color != 0) {
            for (int j = 0; j < 2; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    private void applyPotionEffects(HitResult objectStruckByVector) {
        EntityHitResult entityStruckResult;
        Entity entity;
        if (objectStruckByVector.getType() == HitResult.Type.ENTITY && (entity = (entityStruckResult = (EntityHitResult)objectStruckByVector).getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.potionContents.hasEffects()) {
                PotionHelper.applyEffectsToEntity(this.potionContents, (Entity)this, this.getOwner(), living);
            }
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.potionContents = PotionHelper.getPotionContentsFromCompoundTag(compound);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        PotionHelper.addPotionContentsToCompoundTag(compound, this.potionContents);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0;
        return distance < d0 * d0;
    }

    public boolean isAttackable() {
        return false;
    }

    int d3() {
        return this.random.nextInt(3) + 1;
    }

    int d6() {
        return this.random.nextInt(6) + 1;
    }

    int d12() {
        return this.random.nextInt(12) + 1;
    }

    void doDamage(LivingEntity e) {
        e.hurt(this.getDamageSource(e), (e instanceof Player ? 0.5f : 1.0f) * this.adjustDamageForPotionShots(this.getDamageOfShot(e)));
    }

    protected DamageSource getDamageSource(LivingEntity livingEntity) {
        return livingEntity.damageSources().source(ModEntities.BULLET_DAMAGE_TYPE, this.getOwner(), (Entity)this);
    }

    private float adjustDamageForPotionShots(int damageOfShot) {
        return this.potionContents.hasEffects() ? 4.0f : (float)damageOfShot;
    }

    protected void spawnMotionBasedParticle(ParticleOptions particleData) {
        this.spawnMotionBasedParticle(particleData, this.getY());
    }

    protected void spawnMotionBasedParticle(ParticleOptions particleData, double y) {
        Vec3 motion = this.getDeltaMovement();
        this.level().addParticle(particleData, this.getX(), y, this.getZ(), (double)this.gaussian((float)motion.x()), (double)this.gaussian((float)motion.y()), (double)this.gaussian((float)motion.z()));
    }

    protected void groundImpact(Direction sideHit) {
        this.ricochet(sideHit);
    }

    protected double smallGauss(double d) {
        return ((double)this.level().random.nextFloat() - 0.5) * d;
    }

    float posGauss(float d) {
        return this.random.nextFloat() * 0.5f * d;
    }

    double posGauss(double d) {
        return (double)this.random.nextFloat() * 0.5 * d;
    }

    float gaussian(float d) {
        return d + d * ((this.random.nextFloat() - 0.5f) / 4.0f);
    }

    double gaussian(double d) {
        return d + d * (double)(this.random.nextFloat() - 0.5f);
    }

    double lowGauss(double d) {
        return d - d * ((double)(this.random.nextFloat() / 4.0f) + 0.5);
    }

    private void ricochet(Direction sideHit) {
        switch (sideHit) {
            case DOWN: 
            case UP: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
                break;
            }
            case WEST: 
            case EAST: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
                break;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.doBurstEffect(sideHit);
            this.scheduledForDeath = true;
            block11: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case DOWN: {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), (double)this.gaussian(0.1f), (double)(-this.gaussian(0.1f)), (double)this.gaussian(0.1f));
                        continue block11;
                    }
                    case UP: 
                    case EAST: 
                    case SOUTH: {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), (double)this.gaussian(0.1f), (double)this.gaussian(0.1f), (double)this.gaussian(0.1f));
                        continue block11;
                    }
                    case NORTH: {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), (double)this.gaussian(0.1f), (double)this.gaussian(0.1f), (double)(-this.gaussian(0.1f)));
                        continue block11;
                    }
                    case WEST: {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), (double)(-this.gaussian(0.1f)), (double)this.gaussian(0.1f), (double)this.gaussian(0.1f));
                        continue block11;
                    }
                }
            }
        }
    }

    void seekTarget() {
        Entity closestTarget = null;
        List huntableEntitiesBlacklist = (List)Config.COMMON.items.seekerShot.huntableEntitiesBlacklist.get();
        List targetsList = this.level().getEntities((Entity)this, new AABB(this.getX() - 5.0, this.getY() - 5.0, this.getZ() - 5.0, this.getX() + 5.0, this.getY() + 5.0, this.getZ() + 5.0), Mob.class::isInstance);
        Iterator iTarget = targetsList.iterator();
        double closestDistance = Double.MAX_VALUE;
        while (iTarget.hasNext()) {
            LivingEntity living;
            Entity currentTarget = (Entity)iTarget.next();
            String entityName = RegistryHelper.getRegistryName(currentTarget).toString();
            if (huntableEntitiesBlacklist.contains(entityName) || currentTarget == this.getOwner() || !currentTarget.isAlive() || currentTarget instanceof LivingEntity && (living = (LivingEntity)currentTarget).getHealth() <= 0.0f || !((double)this.distanceTo(currentTarget) < closestDistance)) continue;
            closestDistance = this.distanceTo(currentTarget);
            closestTarget = currentTarget;
        }
        if (closestTarget != null && this.getOwner() != null) {
            double x = closestTarget.getBoundingBox().minX + closestTarget.getBoundingBox().maxX;
            x /= 2.0;
            double y = closestTarget.getBoundingBox().minY + closestTarget.getBoundingBox().maxY;
            double z = closestTarget.getBoundingBox().minZ + closestTarget.getBoundingBox().maxZ;
            double trueX = this.getBoundingBox().minX + this.getBoundingBox().maxX;
            double trueY = this.getBoundingBox().minY + this.getBoundingBox().maxY;
            double trueZ = this.getBoundingBox().minZ + this.getBoundingBox().maxZ;
            Vec3 seekVector = new Vec3(x - (trueX /= 2.0), (y /= 2.0) - (trueY /= 2.0), (z /= 2.0) - (trueZ /= 2.0));
            seekVector = seekVector.normalize();
            this.setDeltaMovement(seekVector.multiply(0.4, 0.4, 0.4));
            if (this.level().isClientSide) {
                this.lerpMotion(this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
            }
        }
    }

    abstract int getRicochetMax();

    abstract int getDamageOfShot(LivingEntity var1);

    protected void onImpact(LivingEntity livingEntity) {
        if (!this.level().isClientSide) {
            if (livingEntity != this.getOwner() || this.ticksInAir > 3) {
                this.doDamage(livingEntity);
            }
            this.spawnHitParticles(8);
            this.scheduledForDeath = true;
        }
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).getEntity();
            if (entity == this.getOwner() || !(entity instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entity);
        } else if (result.getType() == HitResult.Type.BLOCK) {
            this.groundImpact(((BlockHitResult)result).getDirection());
        }
    }

    abstract void doBurstEffect(Direction var1);

    abstract void doFiringEffects();

    abstract void doFlightEffects();

    abstract void spawnHitParticles(int var1);

    public abstract ResourceLocation getShotTexture();
}

