/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import reliquary.entities.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class EnderShot
extends ShotBase {
    public EnderShot(EntityType<EnderShot> entityType, Level level) {
        super(entityType, level);
    }

    public EnderShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.ENDER_SHOT.get(), level, player, hand);
    }

    private void doPortalExplosion() {
        for (int particles = 0; particles < 3; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.PORTAL, this.getY() - 1.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        this.discard();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entityHit = ((EntityHitResult)result).getEntity();
            if (entityHit == this.getOwner() || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        }
    }

    @Override
    protected void onImpact(LivingEntity livingEntity) {
        if (livingEntity != this.getOwner() || this.ticksInAir > 3) {
            this.doDamage(livingEntity);
        }
        this.spawnHitParticles(8);
    }

    @Override
    protected void groundImpact(Direction sideHit) {
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.PORTAL, this.getY() - 1.0);
        }
        this.seekTarget();
        if (this.ticksInAir > 100) {
            this.doPortalExplosion();
        }
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.WITCH);
        }
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 16 + this.d12();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.ENDER;
    }
}

