/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.ConcussiveExplosion;
import reliquary.entities.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class BusterShot
extends ShotBase {
    public BusterShot(EntityType<BusterShot> entityType, Level level) {
        super(entityType, level);
    }

    public BusterShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.BUSTER_SHOT.get(), level, player, hand);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        ConcussiveExplosion.customBusterExplosion((Entity)this, this.getX(), this.getY(), this.getZ(), 4.0f);
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.SMOKE);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    protected void onImpact(LivingEntity livingEntity) {
        ConcussiveExplosion.customBusterExplosion((Entity)this, this.getX(), this.getY(), this.getZ(), 4.0f);
        super.onImpact(livingEntity);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BUSTER;
    }
}

