/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import reliquary.data.BlockLootSubProvider;
import reliquary.data.ChestLootInjectSubProvider;
import reliquary.data.EntityLootInjectSubProvider;

public class ReliquaryLootTableProvider
extends LootTableProvider {
    ReliquaryLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, ReliquaryLootTableProvider.getAllInjectLootTables(), List.of(new LootTableProvider.SubProviderEntry(BlockLootSubProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ChestLootInjectSubProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(EntityLootInjectSubProvider::new, LootContextParamSets.ENTITY)), registries);
    }

    private static Set<ResourceKey<LootTable>> getAllInjectLootTables() {
        HashSet<ResourceKey<LootTable>> injectLootTables = new HashSet<ResourceKey<LootTable>>();
        injectLootTables.addAll(ChestLootInjectSubProvider.LOOT_INJECTS.values());
        injectLootTables.addAll(EntityLootInjectSubProvider.LOOT_INJECTS.values());
        return injectLootTables;
    }
}

