/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.infernaltear;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import reliquary.Reliquary;
import reliquary.compat.jei.infernaltear.InfernalTearRecipe;
import reliquary.init.ModItems;
import reliquary.items.InfernalTearItem;
import reliquary.util.XpHelper;

public class InfernalTearRecipeCategory
implements IRecipeCategory<InfernalTearRecipe> {
    public static final RecipeType<InfernalTearRecipe> TYPE = RecipeType.create((String)"reliquary", (String)"infernal_tear", InfernalTearRecipe.class);
    private static final ResourceLocation BACKGROUNDS_TEXTURE = Reliquary.getRL("textures/gui/jei/backgrounds.png");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public InfernalTearRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUNDS_TEXTURE, 0, 76, 110, 25);
        this.localizedName = Component.translatable((String)"jei.reliquary.recipe.infernal_tear");
        ItemStack iconTear = new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get());
        InfernalTearItem.setTearTarget(iconTear, new ItemStack((ItemLike)Items.IRON_INGOT));
        this.icon = guiHelper.createDrawableItemStack(iconTear);
    }

    public RecipeType<InfernalTearRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfernalTearRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 0).addItemStack(recipe.getInput());
    }

    public void draw(InfernalTearRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int experiencePoints = recipe.getExperiencePoints();
        String points = experiencePoints + " " + Language.getInstance().getOrDefault("jei.reliquary.recipe.infernal_tear.xp");
        Font fontRenderer = Minecraft.getInstance().font;
        int stringWidth = fontRenderer.width(points);
        guiGraphics.drawString(fontRenderer, points, (int)((double)this.background.getWidth() / 2.0 + ((double)this.background.getWidth() / 2.0 + 16.0 - (double)stringWidth) / 2.0), 5, 8453920);
        this.drawLevels(guiGraphics, experiencePoints, fontRenderer);
    }

    private void drawLevels(GuiGraphics guiGraphics, int experiencePoints, Font fontRenderer) {
        int numberOfLevels = XpHelper.getLevelForExperience(experiencePoints);
        this.drawXpBar(guiGraphics, experiencePoints, numberOfLevels);
        this.drawXpLevel(guiGraphics, fontRenderer, numberOfLevels);
    }

    private void drawXpLevel(GuiGraphics guiGraphics, Font fontRenderer, int numberOfLevels) {
        String xpLevel = Integer.toString(numberOfLevels);
        int x = (this.background.getWidth() - fontRenderer.width(xpLevel)) / 2;
        int y = this.background.getHeight() - 10;
        guiGraphics.drawString(fontRenderer, xpLevel, x + 1, y, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x - 1, y, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y + 1, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y - 1, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y, 8453920);
    }

    private void drawXpBar(GuiGraphics guiGraphics, int experiencePoints, int level) {
        int partialXp = experiencePoints - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        if (partialXp == 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUNDS_TEXTURE);
        float textureWidth = 256.0f;
        float textureHeight = 256.0f;
        float minU = 0.0f;
        float minV = 101.0f;
        float maxU = 110.0f * ((float)partialXp / (float)maxBarExperience);
        float maxV = 106.0f;
        float width = maxU - minU;
        float height = maxV - minV;
        float x = 0.0f;
        float y = (float)this.background.getHeight() - 5.0f;
        BufferBuilder buffer = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        PoseStack.Pose pose = guiGraphics.pose().last();
        buffer.addVertex(pose, x, y + height, 0.0f).setUv(minU / textureWidth, maxV / textureHeight);
        buffer.addVertex(pose, x + width, y + height, 0.0f).setUv(maxU / textureWidth, maxV / textureHeight);
        buffer.addVertex(pose, x + width, y, 0.0f).setUv(maxU / textureWidth, minV / textureHeight);
        buffer.addVertex(pose, x, y, 0.0f).setUv(minU / textureWidth, minV / textureHeight);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

