/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import reliquary.blocks.tile.BlockEntityBase;
import reliquary.init.ModBlocks;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class PassivePedestalBlockEntity
extends BlockEntityBase
implements Container {
    protected ItemStack item;
    private final IItemHandler inventoryWrapper = new InvWrapper((Container)this);

    public ItemStack getItem() {
        return this.item;
    }

    public PassivePedestalBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get(), pos, state);
    }

    PassivePedestalBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.item = ItemStack.EMPTY;
    }

    public IItemHandler getItemHandler() {
        return this.inventoryWrapper;
    }

    public void dropPedestalInventory(Level level) {
        if (!this.item.isEmpty()) {
            InventoryHelper.spawnItemStack(level, this.worldPosition, this.item);
        }
    }

    public void removeAndSpawnItem(Level level) {
        if (!this.item.isEmpty()) {
            if (!level.isClientSide) {
                this.setChanged();
                ItemEntity itemEntity = new ItemEntity(level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, this.item);
                level.addFreshEntity((Entity)itemEntity);
                WorldHelper.notifyBlockUpdate(this);
            }
            this.item = ItemStack.EMPTY;
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public ItemStack getItem(int index) {
        return index == 0 ? this.item : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        if (index == 0) {
            return this.decrStackInInventory(count);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack decrStackInInventory(int count) {
        if (!this.item.isEmpty()) {
            ItemStack stack = this.item.split(count);
            if (this.item.isEmpty()) {
                this.notifyBlock();
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (index == 0) {
            ItemStack stack = this.item;
            this.item = ItemStack.EMPTY;
            this.notifyBlock();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void notifyBlock() {
        if (this.level == null) {
            return;
        }
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.item = tag.contains("item") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("item")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.item.isEmpty()) {
            compound.put("item", this.item.save(registries));
        }
    }

    public void setItem(int index, ItemStack stack) {
        if (index == 0) {
            this.item = stack;
            this.notifyBlock();
        }
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index == 0;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }
}

