/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.gui.IDrawableGuiListener;
import com.hrznstudio.emojiful.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class EmojiSelectionGui
extends IDrawableGuiListener {
    private final ChatScreen chatScreen;
    private final EditBox fieldWidget;
    private final Rect2i openSelectionArea;
    private final Rect2i selectionArea;
    private final Rect2i categorySelectionArea;
    private final Rect2i emojiInfoArea;
    private final Rect2i textFieldRectangle;
    private int selectionPointer = 1;
    private int categoryPointer = 0;
    private int openSelectionAreaEmoji;
    private boolean showingSelectionArea;
    private double lastMouseX;
    private double lastMouseY;
    private Emoji lastEmoji;
    private List<Emoji[]> filteredEmojis;

    public EmojiSelectionGui(ChatScreen screen) {
        this.chatScreen = screen;
        this.openSelectionAreaEmoji = -1;
        if (Constants.EMOJI_MAP.containsKey("Smileys & Emotion")) {
            this.openSelectionAreaEmoji = new Random().nextInt(Constants.EMOJI_MAP.get("Smileys & Emotion").size());
        }
        this.showingSelectionArea = false;
        int offset = 0;
        if (Services.PLATFORM.isModLoaded("quark")) {
            offset = -80;
        }
        this.openSelectionArea = new Rect2i(this.chatScreen.width - 14, this.chatScreen.height - 12, 12, 12);
        this.selectionArea = new Rect2i(this.chatScreen.width - 14 - 132 + offset, this.chatScreen.height - 16 - 110 - 4, 136, 114);
        this.categorySelectionArea = new Rect2i(this.selectionArea.getX(), this.selectionArea.getY() + 20, 22, this.selectionArea.getHeight() - 20);
        this.emojiInfoArea = new Rect2i(this.selectionArea.getX() + 22, this.selectionArea.getY() + this.selectionArea.getHeight() - 20, this.selectionArea.getWidth() - 22, 20);
        this.textFieldRectangle = new Rect2i(this.selectionArea.getX() + 6, this.selectionArea.getY() + 6, this.selectionArea.getWidth() - 12, 10);
        this.fieldWidget = new EditBox(ClientEmojiHandler.oldFontRenderer, this.textFieldRectangle.getX(), this.textFieldRectangle.getY(), this.textFieldRectangle.getWidth(), this.textFieldRectangle.getHeight(), (Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents("")));
        this.fieldWidget.setEditable(true);
        this.fieldWidget.setVisible(true);
        this.filteredEmojis = new ArrayList<Emoji[]>();
    }

    @Override
    public void render(GuiGraphics guiGraphics) {
        if (this.openSelectionAreaEmoji != -1) {
            guiGraphics.drawString(Minecraft.getInstance().font, Constants.EMOJI_MAP.get((Object)"Smileys & Emotion").get((int)this.openSelectionAreaEmoji).strings.get(0), this.openSelectionArea.getX(), this.openSelectionArea.getY(), 0);
        }
        if (this.showingSelectionArea) {
            this.drawRectangle(guiGraphics, this.selectionArea);
            this.drawRectangle(guiGraphics, this.categorySelectionArea);
            this.drawRectangle(guiGraphics, this.emojiInfoArea);
            for (int i = 0; i < 6; ++i) {
                this.drawLine(guiGraphics, (float)i * 12.0f, i + this.selectionPointer);
            }
            int progressY = (int)((double)(this.emojiInfoArea.getY() - this.categorySelectionArea.getY() - 5) / (double)this.getLineAmount() * (double)this.selectionPointer);
            this.drawRectangle(guiGraphics, new Rect2i(this.selectionArea.getX() + this.selectionArea.getWidth() - 2, this.categorySelectionArea.getY() + progressY, 1, 5), -11382190);
            if (this.lastEmoji != null) {
                guiGraphics.drawString(Minecraft.getInstance().font, this.lastEmoji.strings.get(0), this.emojiInfoArea.getX() + 2, this.emojiInfoArea.getY() + 6, 0);
                StringBuilder builder = new StringBuilder();
                this.lastEmoji.strings.forEach(s -> builder.append((String)s).append(" "));
                float textScale = 0.5f;
                List iTextPropertiesList = ClientEmojiHandler.oldFontRenderer.split(FormattedText.of((String)builder.toString()), (int)((float)(this.emojiInfoArea.getWidth() - 18) * (1.0f / textScale)));
                float i = -iTextPropertiesList.size() / 2;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(textScale, textScale, textScale);
                for (FormattedCharSequence reorderingProcessor : iTextPropertiesList) {
                    StringBuilder stringBuilder = new StringBuilder();
                    reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                        stringBuilder.append((char)ch);
                        return true;
                    });
                    guiGraphics.drawString(ClientEmojiHandler.oldFontRenderer, stringBuilder.toString(), (int)((float)(this.emojiInfoArea.getX() + 15) * (1.0f / textScale)), (int)(((float)(this.emojiInfoArea.getY() + 8) + 4.0f * i) * (1.0f / textScale)), 0x969696);
                    i += 1.0f;
                }
                guiGraphics.pose().scale(1.0f, 1.0f, 1.0f);
                guiGraphics.pose().popPose();
            }
            progressY = (int)((double)(this.categorySelectionArea.getHeight() - 10) / ((double)ClientEmojiHandler.CATEGORIES.size() - 7.0) * (double)this.categoryPointer);
            this.drawRectangle(guiGraphics, new Rect2i(this.categorySelectionArea.getX() + this.categorySelectionArea.getWidth() - 2, this.categorySelectionArea.getY() + progressY + 2, 1, 5), -11382190);
            EmojiCategory firstCategory = this.getCategory(this.selectionPointer);
            for (int i = 0; i < 7; ++i) {
                int selCategory = i + this.categoryPointer;
                if (selCategory >= ClientEmojiHandler.CATEGORIES.size()) continue;
                EmojiCategory category = ClientEmojiHandler.CATEGORIES.get(selCategory);
                Rect2i rec = new Rect2i(this.categorySelectionArea.getX() + 6, this.categorySelectionArea.getY() + 6 + i * 12, 11, 11);
                if (category.equals(firstCategory)) {
                    guiGraphics.fill(rec.getX() - 1, rec.getY() - 2, rec.getX() + rec.getWidth(), rec.getY() + rec.getHeight() - 1, -2130706433);
                }
                if (rec.contains((int)this.lastMouseX, (int)this.lastMouseY) && Minecraft.getInstance().screen != null) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, Arrays.asList(MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(category.name()))), Optional.empty(), (int)this.lastMouseX, (int)this.lastMouseY);
                }
                if (!ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.containsKey(category) || ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category).size() <= 0) continue;
                guiGraphics.drawString(Minecraft.getInstance().font, ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get((Object)category).get((int)0)[0].strings.get(0), this.categorySelectionArea.getX() + 6, this.categorySelectionArea.getY() + 6 + i * 12, 0);
            }
            this.fieldWidget.render(guiGraphics, (int)this.lastMouseX, (int)this.lastMouseY, 0.0f);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_231044_5_) {
        if (this.openSelectionArea.contains((int)mouseX, (int)mouseY)) {
            this.toggleSelectionArea();
            return true;
        }
        if (this.showingSelectionArea) {
            this.fieldWidget.setFocused(this.textFieldRectangle.contains((int)mouseX, (int)mouseY));
            if (this.categorySelectionArea.contains((int)mouseX, (int)mouseY)) {
                for (int i = 0; i < 7; ++i) {
                    Rect2i rec;
                    int selCategory = i + this.categoryPointer;
                    if (selCategory >= ClientEmojiHandler.CATEGORIES.size() || !(rec = new Rect2i(this.categorySelectionArea.getX() + 6, this.categorySelectionArea.getY() + 6 + i * 12, 11, 11)).contains((int)mouseX, (int)mouseY)) continue;
                    EmojiCategory name = ClientEmojiHandler.CATEGORIES.get(selCategory);
                    for (int i1 = 0; i1 < this.getLineAmount(); ++i1) {
                        if (!name.equals(this.getLineToDraw(i1))) continue;
                        this.selectionPointer = i1;
                    }
                }
                return true;
            }
            if (this.selectionArea.contains((int)mouseX, (int)mouseY)) {
                for (int line = 0; line < 6; ++line) {
                    Object object = this.getLineToDraw(line + this.selectionPointer);
                    if (!(object instanceof Emoji[])) continue;
                    Emoji[] emojis = (Emoji[])object;
                    for (int i = 0; i < emojis.length; ++i) {
                        float y;
                        float x;
                        Rect2i rec;
                        if (emojis[i] == null || !(rec = new Rect2i((int)(x = (float)(this.categorySelectionArea.getX() + this.categorySelectionArea.getWidth() + 2) + 12.0f * (float)i), (int)(y = (float)(this.categorySelectionArea.getY() + line * 12 + 2)) - 1, 11, 11)).contains((int)this.lastMouseX, (int)this.lastMouseY)) continue;
                        this.chatScreen.input.setValue(this.chatScreen.input.getValue() + emojis[i].getShorterString());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double d) {
        if (this.categorySelectionArea.contains((int)mouseX, (int)mouseY)) {
            this.categoryPointer = (int)((double)this.categoryPointer - d);
            this.categoryPointer = Mth.clamp((int)this.categoryPointer, (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        if (this.selectionArea.contains((int)mouseX, (int)mouseY)) {
            this.selectionPointer = (int)((double)this.selectionPointer - d);
            this.selectionPointer = Mth.clamp((int)this.selectionPointer, (int)1, (int)Math.max(1, this.getLineAmount() - 5));
            this.categoryPointer = Mth.clamp((int)Arrays.asList(ClientEmojiHandler.CATEGORIES).indexOf(this.getCategory(this.selectionPointer)), (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        return false;
    }

    public void drawRectangle(GuiGraphics guiGraphics, Rect2i rectangle2d) {
        this.drawRectangle(guiGraphics, rectangle2d, Integer.MIN_VALUE);
    }

    public void drawRectangle(GuiGraphics guiGraphics, Rect2i rectangle2d, int value) {
        guiGraphics.fill(rectangle2d.getX(), rectangle2d.getY(), rectangle2d.getX() + rectangle2d.getWidth(), rectangle2d.getY() + rectangle2d.getHeight(), value);
    }

    public void toggleSelectionArea() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.showingSelectionArea = !this.showingSelectionArea;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.fieldWidget.keyPressed(keyCode, scanCode, modifiers)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, int mod) {
        if (this.fieldWidget.charTyped(c, mod)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public void drawLine(GuiGraphics guiGraphics, float height, int line) {
        Object lineToDraw = this.getLineToDraw(line);
        if (lineToDraw != null) {
            if (lineToDraw instanceof EmojiCategory) {
                float textScale = 1.0f;
                guiGraphics.pose().scale(textScale, textScale, textScale);
                guiGraphics.drawString(Minecraft.getInstance().font, ((EmojiCategory)lineToDraw).name(), (int)((float)(this.categorySelectionArea.getX() + this.categorySelectionArea.getWidth() + 2) * (1.0f / textScale)), (int)(((float)this.categorySelectionArea.getY() + height + 2.0f) * (1.0f / textScale)), 0x969696);
                guiGraphics.pose().scale(1.0f, 1.0f, 1.0f);
            } else {
                Emoji[] emojis = (Emoji[])lineToDraw;
                for (int i = 0; i < emojis.length; ++i) {
                    float y;
                    if (emojis[i] == null) continue;
                    float x = (float)(this.categorySelectionArea.getX() + this.categorySelectionArea.getWidth() + 2) + 12.0f * (float)i;
                    Rect2i rec = new Rect2i((int)x, (int)(y = (float)this.categorySelectionArea.getY() + height + 2.0f) - 1, 11, 11);
                    if (rec.contains((int)this.lastMouseX, (int)this.lastMouseY)) {
                        this.lastEmoji = emojis[i];
                        guiGraphics.fill(rec.getX() - 1, rec.getY() - 1, rec.getX() + rec.getWidth(), rec.getY() + rec.getHeight(), -2130706433);
                    }
                    guiGraphics.drawString(Minecraft.getInstance().font, emojis[i].strings.get(0), (int)x, (int)y, 0x969696);
                }
            }
        }
    }

    public Object getLineToDraw(int line) {
        if (this.fieldWidget.getValue().isEmpty()) {
            for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
                if (--line == 0) {
                    return category;
                }
                for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                    if (--line != 0) continue;
                    return emojis;
                }
            }
        } else if (this.filteredEmojis.size() > line - 1 && line - 1 >= 0) {
            return this.filteredEmojis.get(line - 1);
        }
        return null;
    }

    public void updateFilter() {
        if (!this.fieldWidget.getValue().isEmpty()) {
            this.selectionPointer = 1;
            this.filteredEmojis = new ArrayList<Emoji[]>();
            List emojis = Constants.EMOJI_LIST.stream().filter(emoji -> emoji.strings.stream().anyMatch(s -> s.toLowerCase().contains(this.fieldWidget.getValue().toLowerCase()))).collect(Collectors.toList());
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = emojis.iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                this.filteredEmojis.add(array);
                array = new Emoji[9];
                i = 0;
            }
            if (i > 0) {
                this.filteredEmojis.add(array);
            }
        }
    }

    public int getLineAmount() {
        return this.fieldWidget.getValue().isEmpty() ? ClientEmojiHandler.lineAmount : this.filteredEmojis.size();
    }

    public EmojiCategory getCategory(int line) {
        for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
            if (--line == 0) {
                return category;
            }
            for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                if (--line != 0) continue;
                return category;
            }
        }
        return null;
    }

    public ChatScreen getChatScreen() {
        return this.chatScreen;
    }

    public EditBox getFieldWidget() {
        return this.fieldWidget;
    }
}

