/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.jumpoverfences.config;

import com.kreezcraft.jumpoverfences.Constants;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeFencesConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOG.debug("Loaded Jump Over Fences' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOG.warn("Jump Over Fences' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<List<? extends String>> jumpTheseToo;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.jumpTheseToo = builder.comment("modid:thingid list of stuff to jump, used for implicit jumping, for example the default list item 'cfm:oak_upgraded_fence").defineListAllowEmpty(List.of("jumpTheseToo"), () -> List.of("cfm:oak_upgraded_fence"), o -> o instanceof String);
            builder.pop();
        }
    }
}

