/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class ComponentItem
extends BaseItem
implements IColored {
    private final String type;

    public ComponentItem(String type) {
        this.type = type;
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (stack.isEnchanted()) {
            Rarity rarity = switch (jetpack.rarity) {
                default -> throw new MatchException(null, null);
                case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
                case Rarity.RARE -> Rarity.EPIC;
                case Rarity.EPIC -> jetpack.rarity;
            };
            stack.set(DataComponents.RARITY, (Object)rarity);
        } else {
            stack.set(DataComponents.RARITY, (Object)jetpack.rarity);
        }
    }

    public Component getName(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)("item.ironjetpacks." + this.type)).args(new Object[]{jetpack.displayName}).build();
    }

    public String getDescriptionId(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)("item.ironjetpacks." + this.type)).args(new Object[]{jetpack.displayName}).buildString();
    }

    public int getColor(int i, ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return jetpack.color;
    }
}

