/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.handler;

import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public final class HudHandler {
    private static final ResourceLocation HUD_TEXTURE = IronJetpacks.resource("textures/gui/hud.png");

    @SubscribeEvent
    public void onRegisterGuiOverlays(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && HudHandler.isVisible(mc)) {
            HudPos pos;
            ItemStack chest = JetpackUtils.getEquippedJetpack((Player)mc.player);
            Item item = chest.getItem();
            if (!chest.isEmpty() && item instanceof JetpackItem && (pos = HudHandler.getHudPos()) != null) {
                int xPos = (int)((double)pos.x / 0.33) - 18;
                int yPos = (int)((double)pos.y / 0.33) - 78;
                GuiGraphics gfx = event.getGuiGraphics();
                PoseStack matrix = gfx.pose();
                matrix.pushPose();
                matrix.scale(0.33f, 0.33f, 1.0f);
                gfx.blit(HUD_TEXTURE, xPos, yPos, 0.0f, 0.0f, 28, 156, 256, 256);
                int i2 = HudHandler.getEnergyBarScaled(chest);
                gfx.blit(HUD_TEXTURE, xPos, 166 - i2 + yPos - 10, 28.0f, (float)(156 - i2), 28, i2, 256, 256);
                matrix.popPose();
                Component fuel = HudHandler.getFuelComponent(chest);
                Component throttle = HudHandler.getThrottleComponent(chest);
                Component engine = HudHandler.getEngineComponent(chest);
                Component hover = HudHandler.getHoverComponent(chest);
                if (pos.side == 1) {
                    gfx.drawString(mc.font, fuel, pos.x - 8 - mc.font.width((FormattedText)fuel), pos.y - 21, 0xF9FFFE);
                    gfx.drawString(mc.font, throttle, pos.x - 8 - mc.font.width((FormattedText)throttle), pos.y - 6, 0xF9FFFE);
                    gfx.drawString(mc.font, engine, pos.x - 8 - mc.font.width((FormattedText)engine), pos.y + 4, 0xF9FFFE);
                    gfx.drawString(mc.font, hover, pos.x - 8 - mc.font.width((FormattedText)hover), pos.y + 14, 0xF9FFFE);
                } else {
                    gfx.drawString(mc.font, fuel, pos.x + 6, pos.y - 21, 0xF9FFFE);
                    gfx.drawString(mc.font, throttle, pos.x + 6, pos.y - 6, 0xF9FFFE);
                    gfx.drawString(mc.font, engine, pos.x + 6, pos.y + 4, 0xF9FFFE);
                    gfx.drawString(mc.font, hover, pos.x + 6, pos.y + 14, 0xF9FFFE);
                }
            }
        }
    }

    private static HudPos getHudPos() {
        Window window = Minecraft.getInstance().getWindow();
        int xOffset = (Integer)ModConfigs.HUD_OFFSET_X.get();
        int yOffset = (Integer)ModConfigs.HUD_OFFSET_Y.get();
        return switch ((Integer)ModConfigs.HUD_POSITION.get()) {
            case 0 -> new HudPos(10 + xOffset, 30 + yOffset, 0);
            case 1 -> new HudPos(10 + xOffset, window.getGuiScaledHeight() / 2 + yOffset, 0);
            case 2 -> new HudPos(10 + xOffset, window.getGuiScaledHeight() - 30 + yOffset, 0);
            case 3 -> new HudPos(window.getGuiScaledWidth() - 8 - xOffset, 30 + yOffset, 1);
            case 4 -> new HudPos(window.getGuiScaledWidth() - 8 - xOffset, window.getGuiScaledHeight() / 2 + yOffset, 1);
            case 5 -> new HudPos(window.getGuiScaledWidth() - 8 - xOffset, window.getGuiScaledHeight() - 30 + yOffset, 1);
            default -> null;
        };
    }

    private static int getEnergyBarScaled(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return 156;
        }
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        int i = energy.getEnergyStored();
        int j = energy.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 156L / (long)j : 0L);
    }

    private static Component getFuelComponent(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return Component.literal((String)(ModTooltips.INFINITE_STATIC.getString() + " FE"));
        }
        int energy = JetpackUtils.getEnergyStorage(stack).getEnergyStored();
        if (energy >= 1000000000) {
            int big;
            int small = (energy - (big = energy / 1000000000) * 1000000000) / 100000000;
            return Component.literal((String)(big + (String)(small != 0 ? "." + small : "") + "G FE")).withStyle(ChatFormatting.GRAY);
        }
        if (energy >= 1000000) {
            int big;
            int small = (energy - (big = energy / 1000000) * 1000000) / 100000;
            return Component.literal((String)(big + (String)(small != 0 ? "." + small : "") + "M FE")).withStyle(ChatFormatting.GRAY);
        }
        if (energy >= 1000) {
            return Component.literal((String)(energy / 1000 + "k FE")).withStyle(ChatFormatting.GRAY);
        }
        return Component.literal((String)(energy + " FE")).withStyle(ChatFormatting.GRAY);
    }

    private static Component getThrottleComponent(ItemStack stack) {
        return Component.literal((String)("T: " + (int)(JetpackUtils.getThrottle(stack) * 100.0) + "%")).withStyle(ChatFormatting.GRAY);
    }

    private static Component getEngineComponent(ItemStack stack) {
        return Component.literal((String)"E: ").append(ModTooltips.getStatusComponent(JetpackUtils.isEngineOn(stack))).withStyle(ChatFormatting.GRAY);
    }

    private static Component getHoverComponent(ItemStack stack) {
        return Component.literal((String)"H: ").append(ModTooltips.getStatusComponent(JetpackUtils.isHovering(stack))).withStyle(ChatFormatting.GRAY);
    }

    private static boolean isVisible(Minecraft mc) {
        return (Boolean)ModConfigs.ENABLE_HUD.get() != false && ((Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() != false || (Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() == false && !(mc.screen instanceof ChatScreen)) && !mc.options.hideGui && !mc.getDebugOverlay().showDebugScreen();
    }

    private record HudPos(int x, int y, int side) {
    }
}

