/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.module.CompatModule;
import com.yungnickyoung.minecraft.travelerstitles.module.SoundModule;
import com.yungnickyoung.minecraft.travelerstitles.module.TagModule;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import com.yungnickyoung.minecraft.travelerstitles.services.Services;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.DimensionType;

public class TitleRenderManager {
    public final TitleRenderer<Biome> biomeTitleRenderer;
    public final TitleRenderer<DimensionType> dimensionTitleRenderer;

    public TitleRenderManager() {
        this.biomeTitleRenderer = new TitleRenderer(TravelersTitlesCommon.CONFIG.biomes.recentBiomeCacheSize, TravelersTitlesCommon.CONFIG.biomes.enabled, TravelersTitlesCommon.CONFIG.biomes.textFadeInTime, TravelersTitlesCommon.CONFIG.biomes.textDisplayTime, TravelersTitlesCommon.CONFIG.biomes.textFadeOutTime, TravelersTitlesCommon.CONFIG.biomes.textColor, TravelersTitlesCommon.CONFIG.biomes.renderShadow, TravelersTitlesCommon.CONFIG.biomes.textSize, TravelersTitlesCommon.CONFIG.biomes.textXOffset, TravelersTitlesCommon.CONFIG.biomes.textYOffset, TravelersTitlesCommon.CONFIG.biomes.centerText);
        this.dimensionTitleRenderer = new TitleRenderer(1, TravelersTitlesCommon.CONFIG.dimensions.enabled, TravelersTitlesCommon.CONFIG.dimensions.textFadeInTime, TravelersTitlesCommon.CONFIG.dimensions.textDisplayTime, TravelersTitlesCommon.CONFIG.dimensions.textFadeOutTime, TravelersTitlesCommon.CONFIG.dimensions.textColor, TravelersTitlesCommon.CONFIG.dimensions.renderShadow, TravelersTitlesCommon.CONFIG.dimensions.textSize, TravelersTitlesCommon.CONFIG.dimensions.textXOffset, TravelersTitlesCommon.CONFIG.dimensions.textYOffset, TravelersTitlesCommon.CONFIG.dimensions.centerText);
    }

    public void clientTick() {
        if (!Minecraft.getInstance().isPaused()) {
            this.dimensionTitleRenderer.tick();
            Services.WAYSTONES.clientTick();
            this.biomeTitleRenderer.tick();
        }
    }

    public void renderTitles(GuiGraphics guiGraphics, float partialTicks) {
        if (!Minecraft.getInstance().getDebugOverlay().showDebugScreen()) {
            this.dimensionTitleRenderer.renderText(partialTicks, guiGraphics);
            this.biomeTitleRenderer.renderText(partialTicks, guiGraphics);
            Services.WAYSTONES.renderText(partialTicks, guiGraphics);
        }
    }

    public void playerTick(Player player) {
        if (player instanceof LocalPlayer && player.level().isLoaded(player.blockPosition())) {
            BlockPos playerPos = player.blockPosition();
            Level world = player.level();
            boolean isPlayerUnderground = world.dimensionType().hasSkyLight() && !world.canSeeSky(playerPos);
            this.updateDimensionTitle(world, player, isPlayerUnderground);
            boolean isRenderingWaystoneTitle = this.updateWaystoneTitle(player, isPlayerUnderground);
            if (!TravelersTitlesCommon.CONFIG.waystones.waystonesOverrideBiomeTitle || !isRenderingWaystoneTitle) {
                this.updateBiomeTitle(world, playerPos, player, isPlayerUnderground);
            } else {
                this.biomeTitleRenderer.clearTimer();
            }
        }
    }

    public void playerChangedDimension(Object entity) {
        if (entity instanceof Player) {
            if (TravelersTitlesCommon.CONFIG.biomes.enabled && TravelersTitlesCommon.CONFIG.biomes.resetBiomeCacheOnDimensionChange) {
                this.biomeTitleRenderer.clearTimer();
                this.biomeTitleRenderer.recentEntries.clear();
                this.biomeTitleRenderer.displayedTitle = null;
            }
            if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled && TravelersTitlesCommon.CONFIG.waystones.resetWaystoneCacheOnDimensionChange) {
                Services.WAYSTONES.reset();
            }
        }
    }

    private void updateDimensionTitle(Level world, Player player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.dimensions.onlyUpdateAtSurface) {
            return;
        }
        DimensionType currDimension = world.dimensionType();
        if (this.dimensionTitleRenderer.enabled && !this.dimensionTitleRenderer.matchesAnyRecentEntry(d -> d == currDimension)) {
            ResourceLocation dimensionBaseKey = world.dimension().location();
            String dimensionNameKey = Util.makeDescriptionId((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
            if (!TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist.contains(dimensionBaseKey.toString())) {
                MutableComponent dimensionTitle = Language.getInstance().has(dimensionNameKey) ? Component.translatable((String)dimensionNameKey) : Component.literal((String)"???");
                String dimensionColorKey = dimensionNameKey + ".color";
                String dimensionColorStr = Language.getInstance().has(dimensionColorKey) ? Language.getInstance().getOrDefault(dimensionColorKey) : this.dimensionTitleRenderer.titleDefaultTextColor;
                this.dimensionTitleRenderer.setColor(dimensionColorStr);
                this.dimensionTitleRenderer.displayTitle((Component)dimensionTitle, null);
                this.dimensionTitleRenderer.addRecentEntry(currDimension);
                player.playSound((SoundEvent)SoundModule.DIMENSION.get(), (float)TravelersTitlesCommon.CONFIG.sound.dimensionVolume, (float)TravelersTitlesCommon.CONFIG.sound.dimensionPitch);
            }
        }
    }

    private void updateBiomeTitle(Level world, BlockPos playerPos, Player player, boolean isPlayerUnderground) {
        boolean isUndergroundBiome;
        Holder biomeHolder = world.getBiome(playerPos);
        boolean bl = isUndergroundBiome = biomeHolder.is(Biomes.LUSH_CAVES) || biomeHolder.is(Biomes.DRIPSTONE_CAVES) || biomeHolder.is(TagModule.IS_UNDERGROUND);
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.biomes.onlyUpdateAtSurface && !isUndergroundBiome) {
            return;
        }
        ResourceLocation biomeBaseKey = world.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)biomeHolder.value()));
        if (this.biomeTitleRenderer.enabled && this.biomeTitleRenderer.cooldownTimer <= 0 && !this.biomeTitleRenderer.matchesAnyRecentEntry(b -> world.registryAccess().registryOrThrow(Registries.BIOME).getKey(b) == biomeBaseKey)) {
            String overrideBiomeNameKey = Util.makeDescriptionId((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
            String normalBiomeNameKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)biomeBaseKey);
            if (biomeBaseKey != null && !TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
                MutableComponent biomeTitle;
                if (Language.getInstance().has(overrideBiomeNameKey)) {
                    biomeTitle = Component.translatable((String)overrideBiomeNameKey);
                } else if (Language.getInstance().has(normalBiomeNameKey)) {
                    biomeTitle = Component.translatable((String)normalBiomeNameKey);
                } else {
                    return;
                }
                String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
                String normalBiomeColorKey = normalBiomeNameKey + ".color";
                String biomeColorStr = Language.getInstance().has(overrideBiomeColorKey) ? Language.getInstance().getOrDefault(overrideBiomeColorKey) : (Language.getInstance().has(normalBiomeColorKey) ? Language.getInstance().getOrDefault(normalBiomeColorKey) : this.biomeTitleRenderer.titleDefaultTextColor);
                if (this.biomeTitleRenderer.displayedTitle != null && biomeTitle.getString().equals(this.biomeTitleRenderer.displayedTitle.getString())) {
                    return;
                }
                this.biomeTitleRenderer.setColor(biomeColorStr);
                this.biomeTitleRenderer.displayTitle((Component)biomeTitle, null);
                this.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
                this.biomeTitleRenderer.addRecentEntry((Biome)biomeHolder.value());
                if (!(this.dimensionTitleRenderer.titleTimer > 0 || CompatModule.isWaystonesLoaded && Services.WAYSTONES.isRendering())) {
                    player.playSound((SoundEvent)SoundModule.BIOME.get(), (float)TravelersTitlesCommon.CONFIG.sound.biomeVolume, (float)TravelersTitlesCommon.CONFIG.sound.biomePitch);
                }
            }
        }
    }

    private boolean updateWaystoneTitle(Player player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.waystones.onlyUpdateAtSurface) {
            return false;
        }
        if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled) {
            return Services.WAYSTONES.updateWaystoneTitle(player);
        }
        return false;
    }
}

