/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class DimensionTitleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dimensiontitle").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> DimensionTitleCommand.displayTitle((CommandSourceStack)ctx.getSource(), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))));
    }

    public static int displayTitle(CommandSourceStack commandSource, ServerLevel world) {
        ResourceLocation dimensionBaseKey = world.dimension().location();
        String dimensionNameKey = Util.makeDescriptionId((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
        if (TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist.contains(dimensionBaseKey.toString())) {
            commandSource.sendSuccess(() -> Component.literal((String)"That dimension is blacklisted, so its title won't normally show!"), false);
        }
        MutableComponent dimensionTitle = Language.getInstance().has(dimensionNameKey) ? Component.translatable((String)dimensionNameKey) : Component.literal((String)"???");
        String dimensionColorKey = dimensionNameKey + ".color";
        String dimensionColorStr = Language.getInstance().has(dimensionColorKey) ? Language.getInstance().getOrDefault(dimensionColorKey) : TravelersTitlesCommon.titleManager.dimensionTitleRenderer.titleDefaultTextColor;
        TravelersTitlesCommon.titleManager.dimensionTitleRenderer.setColor(dimensionColorStr);
        TravelersTitlesCommon.titleManager.dimensionTitleRenderer.displayTitle((Component)dimensionTitle, null);
        return 1;
    }
}

