/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private final XpPumpUpgradeConfig xpPumpUpgradeConfig;

    protected XpPumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.xpPumpUpgradeConfig = ((XpPumpUpgradeItem)this.upgradeItem).getXpPumpUpgradeConfig();
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (entity != null && !(entity instanceof Player) || this.isInCooldown(level)) {
            return;
        }
        if (entity == null) {
            AABB searchBox = new AABB(pos).inflate(3.0);
            for (Player player : level.players()) {
                if (!searchBox.contains(player.getX(), player.getY(), player.getZ())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        } else {
            Player player = (Player)entity;
            this.interactWithPlayer(player);
            this.mendItems(player);
        }
        this.setCooldown(level, 5);
    }

    private void mendItems(Player player) {
        if (Boolean.FALSE.equals(this.xpPumpUpgradeConfig.mendingOn.get()) || !this.shouldMendItems()) {
            return;
        }
        EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)player, ItemStack::isDamaged).ifPresent(item -> {
            float xpToTryDrain;
            ItemStack itemStack = item.itemStack();
            if (!itemStack.isEmpty() && itemStack.isDamaged() && itemStack.getXpRepairRatio() > 0.0f && (xpToTryDrain = Math.min((float)((Integer)this.xpPumpUpgradeConfig.maxXpPointsPerMending.get()).intValue(), (float)itemStack.getDamageValue() / itemStack.getXpRepairRatio())) > 0.0f) {
                this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                    FluidStack drained = fluidHandler.drain(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), IFluidHandler.FluidAction.EXECUTE, false);
                    float xpDrained = XpHelper.liquidToExperience(drained.getAmount());
                    int durationToRepair = (int)(xpDrained * itemStack.getXpRepairRatio());
                    itemStack.setDamageValue(itemStack.getDamageValue() - durationToRepair);
                });
            }
        });
    }

    private void interactWithPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if (direction == AutomationDirection.INPUT) {
                if (level < player.experienceLevel || level == player.experienceLevel && player.experienceProgress > 0.0f) {
                    this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, level, false);
                }
            } else if (direction == AutomationDirection.OUTPUT && level > player.experienceLevel) {
                this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        FluidStack drained = fluidHandler.drain(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (!drained.isEmpty()) {
            player.giveExperiencePoints((int)XpHelper.liquidToExperience(drained.getAmount()));
        }
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        int filled = fluidHandler.fill(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (filled > 0) {
            player.giveExperiencePoints((int)(-XpHelper.liquidToExperience(filled)));
        }
    }

    public void takeLevelsFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, Math.max(player.experienceLevel - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, player.experienceLevel + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return (AutomationDirection)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)AutomationDirection.INPUT));
    }

    public void setDirection(AutomationDirection direction) {
        this.upgrade.set(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)direction);
        this.save();
    }

    public void setLevel(int level) {
        this.upgrade.set(ModCoreDataComponents.LEVEL, (Object)level);
        this.save();
    }

    public int getLevel() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVEL, (Object)10);
    }

    public void setLevelsToStore(int levelsToStore) {
        this.upgrade.set(ModCoreDataComponents.LEVELS_TO_STORE, (Object)levelsToStore);
        this.save();
    }

    public int getLevelsToStore() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVELS_TO_STORE, (Object)1);
    }

    public void setLevelsToTake(int levelsToTake) {
        this.upgrade.set(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)levelsToTake);
        this.save();
    }

    public int getLevelsToTake() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)1);
    }

    public boolean shouldMendItems() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.MEND_ITEMS, (Object)true);
    }

    public void setMendItems(boolean mendItems) {
        this.upgrade.set(ModCoreDataComponents.MEND_ITEMS, (Object)mendItems);
        this.save();
    }
}

