/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade,
ISlotLimitUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.filterLogic.setAllowByDefault(true);
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @Override
    public ItemStack onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        if (this.shouldVoidOverflow && inventoryHandler.getStackInSlot(slot).isEmpty() && (!this.filterLogic.shouldMatchComponents() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(stack)) {
            for (int s = 0; s < inventoryHandler.getSlots(); ++s) {
                if (s == slot || !this.stackMatchesFilterStack(inventoryHandler.getStackInSlot(s), stack)) continue;
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return !this.shouldVoidOverflow && this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        this.upgrade.set(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflowDefault) != false;
    }

    public boolean shouldVoidOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            storageInventory.extractItem(slot, storageInventory.getStackInSlot(slot).getCount(), false);
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public ItemStack onOverflow(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public boolean stackMatchesFilter(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAnythingEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }

    @Override
    public int getSlotLimit() {
        return Integer.MAX_VALUE;
    }
}

