/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class TankUpgradeWrapper
extends UpgradeWrapperBase<TankUpgradeWrapper, TankUpgradeItem>
implements IRenderedTankUpgrade,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback;
    private final TankComponentItemHandler inventory;
    private FluidStack contents;
    private long cooldownTime = 0L;

    protected TankUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new TankComponentItemHandler(upgrade);
        this.contents = TankUpgradeWrapper.getContents(upgrade).copy();
    }

    public static SimpleFluidContent getContents(ItemStack upgrade) {
        return (SimpleFluidContent)upgrade.getOrDefault(ModCoreDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.EMPTY);
    }

    private boolean isValidFluidItem(ItemStack stack, boolean isOutput) {
        return CapabilityHelper.getFromFluidHandler(stack, fluidHandler -> this.isValidFluidHandler((IFluidHandlerItem)fluidHandler, isOutput), false);
    }

    private boolean isValidFluidHandler(IFluidHandlerItem fluidHandler, boolean isOutput) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if ((!isOutput || !fluidInTank.isEmpty() && (tankEmpty || !FluidStack.isSameFluidSameComponents((FluidStack)fluidInTank, (FluidStack)this.contents))) && (isOutput || fluidInTank.isEmpty() || !tankEmpty && !FluidStack.isSameFluidSameComponents((FluidStack)this.contents, (FluidStack)fluidInTank))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTankRenderInfoUpdateCallback(Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateTankRenderInfo() {
        IRenderedTankUpgrade.TankRenderInfo renderInfo = new IRenderedTankUpgrade.TankRenderInfo();
        renderInfo.setFluid(this.contents);
        renderInfo.setFillRatio((float)Math.round((float)this.contents.getAmount() / (float)this.getTankCapacity() * 10.0f) / 10.0f);
        this.updateTankRenderInfoCallback.accept(renderInfo);
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public int getTankCapacity() {
        return ((TankUpgradeItem)this.upgradeItem).getTankCapacity(this.storageWrapper);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    private int getMaxInOut() {
        return (int)Math.max(1000.0, (double)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows()) * ((TankUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int capacity = this.getTankCapacity();
        if (this.contents.getAmount() >= capacity || !this.contents.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.contents)) {
            return 0;
        }
        int toFill = Math.min(capacity - this.contents.getAmount(), resource.getAmount());
        if (!ignoreInOutLimit) {
            toFill = Math.min(this.getMaxInOut(), toFill);
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (this.contents.isEmpty()) {
                this.contents = new FluidStack(resource.getFluid(), toFill);
            } else {
                this.contents.setAmount(this.contents.getAmount() + toFill);
            }
            this.serializeContents();
        }
        return toFill;
    }

    private void serializeContents() {
        this.upgrade.set(ModCoreDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)this.contents));
        this.save();
        this.forceUpdateTankRenderInfo();
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        if (this.contents.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(maxDrain, this.contents.getAmount());
        if (!ignoreInOutLimit) {
            toDrain = Math.min(this.getMaxInOut(), toDrain);
        }
        FluidStack ret = new FluidStack(this.contents.getFluid(), toDrain);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (toDrain == this.contents.getAmount()) {
                this.contents = FluidStack.EMPTY;
            } else {
                this.contents.setAmount(this.contents.getAmount() - toDrain);
            }
            this.serializeContents();
        }
        return ret;
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (level.getGameTime() < this.cooldownTime) {
            return;
        }
        AtomicBoolean didSomething = new AtomicBoolean(false);
        CapabilityHelper.runOnFluidHandler(this.inventory.getStackInSlot(0), fluidHandler -> didSomething.set(this.drainHandler((IFluidHandlerItem)fluidHandler, stack -> this.inventory.setStackInSlotWithoutValidation(0, (ItemStack)stack))));
        CapabilityHelper.runOnFluidHandler(this.inventory.getStackInSlot(1), fluidHandler -> didSomething.set(this.fillHandler((IFluidHandlerItem)fluidHandler, stack -> this.inventory.setStackInSlotWithoutValidation(1, (ItemStack)stack))));
        if (didSomething.get()) {
            this.cooldownTime = level.getGameTime() + (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().autoFillDrainContainerCooldown.get()).intValue();
        }
    }

    public boolean fillHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack) {
        if (!this.contents.isEmpty() && this.isValidFluidHandler(fluidHandler, true)) {
            int filled = fluidHandler.fill(new FluidStack(this.contents.getFluid(), Math.min(1000, this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (filled <= 0) {
                return false;
            }
            FluidStack drained = this.drain(filled, IFluidHandler.FluidAction.EXECUTE, false);
            fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            updateContainerStack.accept(fluidHandler.getContainer());
            return true;
        }
        return false;
    }

    public boolean drainHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack) {
        if (this.isValidFluidHandler(fluidHandler, false)) {
            FluidStack extracted;
            FluidStack fluidStack = extracted = this.contents.isEmpty() ? fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE) : fluidHandler.drain(new FluidStack(this.contents.getFluid(), Math.min(1000, this.getTankCapacity() - this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (extracted.isEmpty()) {
                return false;
            }
            int filled = this.fill(extracted, IFluidHandler.FluidAction.EXECUTE, false);
            FluidStack toExtract = filled == extracted.getAmount() ? extracted : new FluidStack(extracted.getFluid(), filled);
            fluidHandler.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
            updateContainerStack.accept(fluidHandler.getContainer());
            return true;
        }
        return false;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.contents.getAmount() / (float)((TankUpgradeItem)this.upgradeItem).getBaseCapacity(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private class TankComponentItemHandler
    extends ComponentItemHandler {
        public TankComponentItemHandler(ItemStack upgrade) {
            super((MutableDataComponentHolder)upgrade, DataComponents.CONTAINER, 2);
        }

        protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            super.onContentsChanged(slot, oldStack, newStack);
            TankUpgradeWrapper.this.save();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.isEmpty() || this.isValidInputItem(stack);
            }
            if (slot == 1) {
                return stack.isEmpty() || this.isValidOutputItem(stack);
            }
            return false;
        }

        private boolean isValidInputItem(ItemStack stack) {
            return TankUpgradeWrapper.this.isValidFluidItem(stack, false);
        }

        private boolean isValidOutputItem(ItemStack stack) {
            return TankUpgradeWrapper.this.isValidFluidItem(stack, true);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void setStackInSlotWithoutValidation(int slot, ItemStack stack) {
            super.updateContents(this.getContents(), stack, slot);
        }
    }
}

