/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public record TankClickPayload(int upgradeSlot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TankClickPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("tank_click"));
    public static final StreamCodec<ByteBuf, TankClickPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TankClickPayload::upgradeSlot, TankClickPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(TankClickPayload payload, IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer serverPlayer;
        Player player;
        block9: {
            block8: {
                player = context.player();
                if (!(player instanceof ServerPlayer)) break block8;
                serverPlayer = (ServerPlayer)player;
                abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof StorageContainerMenuBase) break block9;
            }
            return;
        }
        StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
        AbstractContainerMenu containerMenu = player.containerMenu;
        UpgradeContainerBase<?, ?> upgradeContainer = storageContainerMenu.getUpgradeContainers().get(payload.upgradeSlot);
        if (!(upgradeContainer instanceof TankUpgradeContainer)) {
            return;
        }
        TankUpgradeContainer tankContainer = (TankUpgradeContainer)upgradeContainer;
        ItemStack cursorStack = containerMenu.getCarried();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)cursorStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        TankUpgradeWrapper tankWrapper = (TankUpgradeWrapper)tankContainer.getUpgradeWrapper();
        FluidStack tankContents = tankWrapper.getContents();
        if (tankContents.isEmpty()) {
            TankClickPayload.drainHandler(serverPlayer, containerMenu, fluidHandler, tankWrapper);
        } else if (!tankWrapper.fillHandler(fluidHandler, itemStackIn -> {
            containerMenu.setCarried(itemStackIn);
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, containerMenu.getCarried()));
        })) {
            TankClickPayload.drainHandler(serverPlayer, containerMenu, fluidHandler, tankWrapper);
        }
    }

    private static void drainHandler(ServerPlayer player, AbstractContainerMenu containerMenu, IFluidHandlerItem fluidHandler, TankUpgradeWrapper tankWrapper) {
        tankWrapper.drainHandler(fluidHandler, itemStackIn -> {
            containerMenu.setCarried(itemStackIn);
            player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, containerMenu.getCarried()));
        });
    }
}

