/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;
    private final PumpUpgradeConfig pumpUpgradeConfig = ((PumpUpgradeItem)this.upgradeItem).getPumpUpgradeConfig();

    protected PumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)this.pumpUpgradeConfig.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        this.setCooldown(level, this.storageWrapper.getFluidHandler().map(storageFluidHandler -> this.tick((IFluidHandlerItem)storageFluidHandler, entity, level, pos)).orElse(40));
    }

    private int tick(IFluidHandlerItem storageFluidHandler, @Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (entity == null) {
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, (Player)entity, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        } else {
            Player player;
            if (this.shouldInteractWithHand() && entity instanceof Player && this.handleFluidContainerInHands(player = (Player)entity, (IFluidHandler)storageFluidHandler)) {
                this.lastHandActionTime = level.getGameTime();
                return 3;
            }
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, (Player)entity, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        }
        return this.lastHandActionTime + 30L > level.getGameTime() ? 3 : 40;
    }

    private Optional<Integer> handleInWorldInteractions(IFluidHandlerItem storageFluidHandler, @Nullable Player player, Level level, BlockPos pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithHand() && this.handleFluidContainersInHandsOfNearbyPlayers(level, pos, (IFluidHandler)storageFluidHandler)) {
            this.lastHandActionTime = level.getGameTime();
            return Optional.of(3);
        }
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(level, pos, (IFluidHandler)storageFluidHandler, player)).isPresent()) {
            return newCooldown;
        }
        return this.interactWithAttachedFluidHandlers(level, pos, (IFluidHandler)storageFluidHandler);
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(Level level, BlockPos pos, IFluidHandler storageFluidHandler) {
        for (Direction dir : Direction.values()) {
            boolean successful = WorldHelper.getBlockEntity((BlockGetter)level, pos.offset(dir.getNormal())).map(be -> CapabilityHelper.getFromFluidHandler(be, dir.getOpposite(), fluidHandler -> {
                if (this.isInput()) {
                    return this.fillFromFluidHandler((IFluidHandler)fluidHandler, storageFluidHandler, this.getMaxInOut());
                }
                return this.fillFluidHandler((IFluidHandler)fluidHandler, storageFluidHandler, this.getMaxInOut());
            }, false)).orElse(false);
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private int getMaxInOut() {
        return Math.max(1000, (Integer)this.pumpUpgradeConfig.maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows() * this.getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.pumpUpgradeConfig.stackMultiplierRatio.get() * (storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1.0));
    }

    private Optional<Integer> interactWithWorld(Level level, BlockPos pos, IFluidHandler storageFluidHandler, @Nullable Player player) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(level, pos, storageFluidHandler, player);
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.offset(dir.getNormal());
            if (!this.placeFluidInWorld(level, storageFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(Level level, IFluidHandler storageFluidHandler, Direction dir, BlockPos offsetPos) {
        if (dir != Direction.UP) {
            for (int tank = 0; tank < storageFluidHandler.getTanks(); ++tank) {
                FluidStack tankFluid = storageFluidHandler.getFluidInTank(tank);
                if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || !this.isValidForFluidPlacement(level, offsetPos) || !FluidUtil.tryPlaceFluid(null, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)offsetPos, (IFluidHandler)storageFluidHandler, (FluidStack)tankFluid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(Level level, BlockPos offsetPos) {
        BlockState blockState = level.getBlockState(offsetPos);
        return blockState.isAir() || !blockState.getFluidState().isEmpty() && !blockState.getFluidState().isSource();
    }

    private Optional<Integer> fillFromBlockInRange(Level level, BlockPos basePos, IFluidHandler storageFluidHandler, @Nullable Player player) {
        LinkedList<BlockPos> nextPositions = new LinkedList<BlockPos>();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            BlockPos pos = (BlockPos)nextPositions.poll();
            if (this.fillFromBlock(level, pos, storageFluidHandler, player)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.distSqr((Vec3i)pos))) * 20.0));
            }
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.offset(dir.getNormal());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.distSqr((Vec3i)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(Level level, BlockPos pos, IFluidHandler storageFluidHandler, @Nullable Player player) {
        FluidState fluidState = level.getFluidState(pos);
        if (!fluidState.isEmpty()) {
            BucketPickupHandlerWrapper targetFluidHandler;
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                targetFluidHandler = new BucketPickupHandlerWrapper(player, bucketPickup, level, pos);
            } else {
                Optional fluidHandler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, null);
                if (fluidHandler.isEmpty()) {
                    return false;
                }
                targetFluidHandler = (IFluidHandler)fluidHandler.get();
            }
            return this.fillFromFluidHandler((IFluidHandler)targetFluidHandler, storageFluidHandler);
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(Level level, BlockPos pos, IFluidHandler storageFluidHandler) {
        AABB searchBox = new AABB(pos).inflate(3.0);
        for (Player player : level.players()) {
            if (!searchBox.contains(player.getX(), player.getY(), player.getZ()) || !this.handleFluidContainerInHands(player, storageFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(Player player, IFluidHandler storageFluidHandler) {
        return this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.MAIN_HAND) || this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.OFF_HAND);
    }

    private boolean handleFluidContainerInHand(IFluidHandler storageFluidHandler, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getCount() != 1 || itemInHand == this.storageWrapper.getWrappedStorageStack()) {
            return false;
        }
        return CapabilityHelper.getFromFluidHandler(itemInHand, itemFluidHandler -> {
            if (this.isInput()) {
                return this.fillFromHand(player, hand, (IFluidHandlerItem)itemFluidHandler, storageFluidHandler);
            }
            return this.fillContainerInHand(player, hand, (IFluidHandlerItem)itemFluidHandler, storageFluidHandler);
        }, false);
    }

    private boolean fillContainerInHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler storageFluidHandler) {
        boolean ret = this.fillFluidHandler((IFluidHandler)itemFluidHandler, storageFluidHandler);
        if (ret) {
            player.setItemInHand(hand, itemFluidHandler.getContainer());
        }
        return ret;
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler) {
        return this.fillFluidHandler(fluidHandler, storageFluidHandler, 1000);
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler, int maxFill) {
        boolean ret = false;
        for (int tank = 0; tank < storageFluidHandler.getTanks(); ++tank) {
            FluidStack tankFluid = storageFluidHandler.getFluidInTank(tank);
            if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)storageFluidHandler, (FluidStack)new FluidStack(tankFluid.getFluid(), maxFill), (boolean)true).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean fillFromHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler storageFluidHandler) {
        if (this.fillFromFluidHandler((IFluidHandler)itemFluidHandler, storageFluidHandler)) {
            player.setItemInHand(hand, itemFluidHandler.getContainer());
            return true;
        }
        return false;
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler) {
        return this.fillFromFluidHandler(fluidHandler, storageFluidHandler, 1000);
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler, int maxDrain) {
        FluidStack containedFluid = fluidHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (!containedFluid.isEmpty() && this.fluidFilterLogic.fluidMatches(containedFluid)) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)storageFluidHandler, (IFluidHandler)fluidHandler, (FluidStack)containedFluid, (boolean)true).isEmpty();
        }
        return false;
    }

    public void setIsInput(boolean input) {
        this.upgrade.set(ModCoreDataComponents.IS_INPUT, (Object)input);
        this.save();
    }

    public boolean isInput() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.IS_INPUT, (Object)true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        this.upgrade.set(ModCoreDataComponents.INTERACT_WITH_HAND, (Object)interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.INTERACT_WITH_HAND, (Object)((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        this.upgrade.set(ModCoreDataComponents.INTERACT_WITH_WORLD, (Object)interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.INTERACT_WITH_WORLD, (Object)((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }
}

