/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), storageWrapper::getInventoryHandler, storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public ItemStack pickup(Level level, ItemStack stack, boolean simulate) {
        if (!this.shouldPickupItems() || !this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        return this.storageWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(level)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, level, pos) : 40;
        if (this.shouldPickupXp() && this.canFillStorageWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, level, pos));
        }
        this.setCooldown(level, cooldown);
    }

    private boolean canFillStorageWithXp() {
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.fill(ModFluids.EXPERIENCE_TAG, 1, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    private int pickupXpOrbs(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        List xpEntities = level.getEntitiesOfClass(ExperienceOrb.class, new AABB(pos).inflate((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        for (ExperienceOrb xpOrb : xpEntities) {
            if (!xpOrb.isAlive() || this.canNotPickup((Entity)xpOrb, entity) || this.tryToFillTank(xpOrb, entity, level)) continue;
            cooldown = 40;
            break;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrb xpOrb, @Nullable LivingEntity entity, Level level) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.getValue());
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded = fluidHandler.fill(ModFluids.EXPERIENCE_TAG, amountToTransfer, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE);
            if (amountAdded > 0) {
                Vec3 pos = xpOrb.position();
                xpOrb.value = 0;
                xpOrb.discard();
                Player player = (Player)entity;
                if (player != null) {
                    MagnetUpgradeWrapper.playXpPickupSound(level, player);
                }
                if (amountToTransfer > amountAdded) {
                    level.addFreshEntity((Entity)new ExperienceOrb(level, pos.x(), pos.y(), pos.z(), (int)XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        List itemEntities = level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(pos).inflate((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        Player player = (Player)entity;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.isAlive() || !this.filterLogic.matchesFilter(itemEntity.getItem()) || this.canNotPickup((Entity)itemEntity, entity)) continue;
            if (this.tryToInsertItem(player, itemEntity)) {
                if (player == null) continue;
                MagnetUpgradeWrapper.playItemPickupSound(level, player);
                continue;
            }
            cooldown = 40;
        }
        return cooldown;
    }

    private static void playItemPickupSound(Level level, @Nonnull Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f);
    }

    private static void playXpPickupSound(Level level, @Nonnull Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (level.random.nextFloat() - level.random.nextFloat()) * 0.35f + 0.9f);
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity entity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        CompoundTag data = entity.getPersistentData();
        return player != null ? data.contains(PREVENT_REMOTE_MOVEMENT) : data.contains(PREVENT_REMOTE_MOVEMENT) && !data.contains(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(@Nullable Player player, ItemEntity itemEntity) {
        ItemStack stack = itemEntity.getItem();
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = inventory.insertItem(stack, true);
        boolean insertedSomething = false;
        if (remaining.getCount() != stack.getCount()) {
            insertedSomething = true;
            int originalCount = stack.getCount();
            Item item = stack.getItem();
            remaining = inventory.insertItem(stack, false);
            itemEntity.setItem(remaining);
            if (player != null) {
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), originalCount - remaining.getCount());
            }
        }
        return insertedSomething;
    }

    public void setPickupItems(boolean pickupItems) {
        this.upgrade.set(ModCoreDataComponents.PICKUP_ITEMS, (Object)pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.PICKUP_ITEMS, (Object)true);
    }

    public void setPickupXp(boolean pickupXp) {
        this.upgrade.set(ModCoreDataComponents.PICKUP_XP, (Object)pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.PICKUP_XP, (Object)true);
    }
}

