/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackPayload;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<ResourceKey<Level>, Long> lastWorldCheck = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Map<UUID, KeepAliveInfo>> worldStorageSoundKeepAlive = new HashMap<ResourceKey<Level>, Map<UUID, KeepAliveInfo>>();

    private ServerStorageSoundHandler() {
    }

    public static void tick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceKey dim = serverLevel.dimension();
        if (lastWorldCheck.computeIfAbsent((ResourceKey<Level>)dim, key -> serverLevel.getGameTime()) > serverLevel.getGameTime() - 10L || !worldStorageSoundKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((ResourceKey<Level>)dim, serverLevel.getGameTime());
        worldStorageSoundKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < serverLevel.getGameTime() - 10L) {
                ServerStorageSoundHandler.sendStopMessage((Level)serverLevel, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID storageUuid, Level level, Vec3 position, Runnable onNoLongerRunning) {
        ResourceKey dim = level.dimension();
        if (!worldStorageSoundKeepAlive.containsKey(dim) || !worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).get(storageUuid).update(level.getGameTime(), position);
        }
    }

    public static void onSoundStopped(Level level, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(level, storageUuid);
    }

    public static void startPlayingDisc(ServerLevel serverLevel, BlockPos position, UUID storageUuid, Holder<JukeboxSong> song, Runnable onStopHandler) {
        Vec3 pos = Vec3.atCenterOf((Vec3i)position);
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)128.0, (CustomPacketPayload)new PlayDiscPayload(storageUuid, song, position), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ServerStorageSoundHandler.putKeepAliveInfo(serverLevel, storageUuid, onStopHandler, pos);
    }

    public static void startPlayingDisc(ServerLevel serverLevel, Vec3 position, UUID storageUuid, int entityId, Holder<JukeboxSong> song, Runnable onStopHandler) {
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)position.x(), (double)position.y(), (double)position.z(), (double)128.0, (CustomPacketPayload)new PlayDiscPayload(storageUuid, song, entityId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ServerStorageSoundHandler.putKeepAliveInfo(serverLevel, storageUuid, onStopHandler, position);
    }

    private static void putKeepAliveInfo(ServerLevel serverLevel, UUID storageUuid, Runnable onStopHandler, Vec3 pos) {
        worldStorageSoundKeepAlive.computeIfAbsent((ResourceKey<Level>)serverLevel.dimension(), dim -> new HashMap()).put(storageUuid, new KeepAliveInfo(onStopHandler, serverLevel.getGameTime(), pos));
    }

    public static void stopPlayingDisc(Level level, Vec3 position, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(level, storageUuid);
        ServerStorageSoundHandler.sendStopMessage(level, position, storageUuid);
    }

    private static void removeKeepAliveInfo(Level level, UUID storageUuid) {
        ResourceKey dim = level.dimension();
        if (worldStorageSoundKeepAlive.containsKey(dim) && worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).remove(storageUuid).runOnStop();
        }
    }

    private static void sendStopMessage(Level level, Vec3 position, UUID storageUuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)position.x(), (double)position.y(), (double)position.z(), (double)128.0, (CustomPacketPayload)new StopDiscPlaybackPayload(storageUuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onStopHandler;
        private long lastKeepAliveTime;
        private Vec3 lastPosition;

        private KeepAliveInfo(Runnable onStopHandler, long lastKeepAliveTime, Vec3 lastPosition) {
            this.onStopHandler = new WeakReference<Runnable>(onStopHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vec3 getLastPosition() {
            return this.lastPosition;
        }

        public void update(long gameTime, Vec3 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnStop() {
            Runnable handler = (Runnable)this.onStopHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

