/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;

public class JukeboxUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);

    public JukeboxUpgradeItem(IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of();
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, JukeboxUpgradeItem>
    implements ITickableUpgrade {
        private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
        private final ComponentItemHandler discInventory;
        private long lastKeepAliveSendTime = 0L;
        private boolean isPlaying;

        protected Wrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
            this.discInventory = new ComponentItemHandler((MutableDataComponentHolder)upgrade, DataComponents.CONTAINER, 1){

                protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
                    super.onContentsChanged(slot, oldStack, newStack);
                    this.save();
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return stack.isEmpty() || stack.has(DataComponents.JUKEBOX_PLAYABLE);
                }
            };
            this.isPlaying = (Boolean)upgrade.getOrDefault(ModCoreDataComponents.IS_PLAYING, (Object)false);
        }

        public void setDisc(ItemStack disc) {
            this.discInventory.setStackInSlot(0, disc);
        }

        public ItemStack getDisc() {
            return this.discInventory.getStackInSlot(0);
        }

        public void play(Level level, BlockPos pos) {
            this.play(level, (ServerLevel serverLevel, UUID storageUuid) -> JukeboxSong.fromStack((HolderLookup.Provider)level.registryAccess(), (ItemStack)this.getDisc()).ifPresent(song -> ServerStorageSoundHandler.startPlayingDisc(serverLevel, pos, storageUuid, (Holder<JukeboxSong>)song, () -> this.setIsPlaying(false))));
        }

        public void play(LivingEntity entity) {
            this.play(entity.level(), (ServerLevel world, UUID storageUuid) -> JukeboxSong.fromStack((HolderLookup.Provider)entity.level().registryAccess(), (ItemStack)this.getDisc()).ifPresent(song -> ServerStorageSoundHandler.startPlayingDisc(world, entity.position(), storageUuid, entity.getId(), (Holder<JukeboxSong>)song, () -> this.setIsPlaying(false))));
        }

        private void play(Level level, BiConsumer<ServerLevel, UUID> play) {
            if (!(level instanceof ServerLevel) || this.getDisc().isEmpty()) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> play.accept((ServerLevel)level, (UUID)storageUuid));
            this.setIsPlaying(true);
        }

        private void setIsPlaying(boolean playing) {
            this.isPlaying = playing;
            this.upgrade.set(ModCoreDataComponents.IS_PLAYING, (Object)playing);
            if (this.isPlaying) {
                this.storageWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
            } else {
                this.removeRenderData();
            }
            this.save();
        }

        private void removeRenderData() {
            this.storageWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
        }

        public void stop(LivingEntity entity) {
            if (!(entity.level() instanceof ServerLevel)) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc(entity.level(), entity.position(), storageUuid));
            this.setIsPlaying(false);
        }

        public IItemHandler getDiscInventory() {
            return this.discInventory;
        }

        @Override
        public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
            if (this.isPlaying && this.lastKeepAliveSendTime < level.getGameTime() - 5L) {
                this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, level, entity != null ? entity.position() : Vec3.atCenterOf((Vec3i)pos), () -> this.setIsPlaying(false)));
                this.lastKeepAliveSendTime = level.getGameTime();
            }
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }

        @Override
        public void onBeforeRemoved() {
            this.removeRenderData();
        }
    }
}

