/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeContainer
extends UpgradeContainerBase<JukeboxUpgradeItem.Wrapper, JukeboxUpgradeContainer> {
    private static final String ACTION_DATA = "action";

    public JukeboxUpgradeContainer(final Player player, int upgradeContainerId, final JukeboxUpgradeItem.Wrapper upgradeWrapper, UpgradeContainerType<JukeboxUpgradeItem.Wrapper, JukeboxUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.slots.add(new SlotItemHandler(this, upgradeWrapper.getDiscInventory(), 0, -100, -100){

            public void setChanged() {
                super.setChanged();
                if (upgradeWrapper.isPlaying()) {
                    upgradeWrapper.stop((LivingEntity)player);
                }
            }
        });
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(ACTION_DATA)) {
            String actionName = data.getString(ACTION_DATA);
            if (actionName.equals("play")) {
                AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
                if (abstractContainerMenu instanceof StorageContainerMenuBase) {
                    StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
                    storageContainerMenu.getBlockPosition().ifPresentOrElse(pos -> ((JukeboxUpgradeItem.Wrapper)this.upgradeWrapper).play(this.player.level(), (BlockPos)pos), () -> ((JukeboxUpgradeItem.Wrapper)this.upgradeWrapper).play((LivingEntity)this.player));
                }
            } else if (actionName.equals("stop")) {
                ((JukeboxUpgradeItem.Wrapper)this.upgradeWrapper).stop((LivingEntity)this.player);
            }
        }
    }

    public void play() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "play"));
    }

    public void stop() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "stop"));
    }
}

