/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.compacting;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CompactingUpgradeWrapper
extends UpgradeWrapperBase<CompactingUpgradeWrapper, CompactingUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToCompact = new HashSet<Integer>();

    public CompactingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((CompactingUpgradeItem)this.upgradeItem).getFilterSlotCount(), stack -> stack.getComponentsPatch().isEmpty() && !RecipeHelper.getItemCompactingShapes(stack.getItem()).isEmpty(), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    @Override
    public ItemStack onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        this.compactSlot(inventoryHandler, slot);
    }

    private void compactSlot(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (slotStack.isEmpty() || !slotStack.getComponentsPatch().isEmpty() || !this.filterLogic.matchesFilter(slotStack)) {
            return;
        }
        Item item = slotStack.getItem();
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(item);
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            this.tryCompacting(inventoryHandler, item, 3, 3);
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            this.tryCompacting(inventoryHandler, item, 2, 2);
        }
    }

    private void tryCompacting(IItemHandlerSimpleInserter inventoryHandler, Item item, int width, int height) {
        int totalCount = width * height;
        RecipeHelper.CompactingResult compactingResult = RecipeHelper.getCompactingResult(item, width, height);
        if (!compactingResult.getResult().isEmpty()) {
            ItemStack extractedStack = InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, true);
            if (extractedStack.getCount() != totalCount) {
                return;
            }
            while (extractedStack.getCount() == totalCount) {
                List<ItemStack> remainingItemsCopy;
                ItemStack resultCopy = compactingResult.getResult().copy();
                List<ItemStack> list = remainingItemsCopy = compactingResult.getRemainingItems().isEmpty() ? Collections.emptyList() : compactingResult.getRemainingItems().stream().map(ItemStack::copy).toList();
                if (!this.fitsResultAndRemainingItems((IItemHandler)inventoryHandler, remainingItemsCopy, resultCopy)) break;
                InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, false);
                inventoryHandler.insertItem(resultCopy, false);
                InventoryHelper.insertIntoInventory(remainingItemsCopy, (IItemHandler)inventoryHandler, false);
                extractedStack = InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, true);
            }
        }
    }

    private boolean fitsResultAndRemainingItems(IItemHandler inventoryHandler, List<ItemStack> remainingItems, ItemStack result) {
        if (!remainingItems.isEmpty()) {
            IItemHandler clonedHandler = InventoryHelper.cloneInventory(inventoryHandler);
            return InventoryHelper.insertIntoInventory(result, clonedHandler, false).isEmpty() && InventoryHelper.insertIntoInventory(remainingItems, clonedHandler, false).isEmpty();
        }
        return InventoryHelper.insertIntoInventory(result, inventoryHandler, true).isEmpty();
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldCompactNonUncraftable() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.COMPACT_NON_UNCRAFTABLE, (Object)false);
    }

    public void setCompactNonUncraftable(boolean shouldCompactNonUncraftable) {
        this.upgrade.set(ModCoreDataComponents.COMPACT_NON_UNCRAFTABLE, (Object)shouldCompactNonUncraftable);
        this.save();
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (this.shouldWorkInGUI()) {
            this.slotsToCompact.add(slot);
        }
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (this.slotsToCompact.isEmpty()) {
            return;
        }
        for (int slot : this.slotsToCompact) {
            this.compactSlot(this.storageWrapper.getInventoryHandler(), slot);
        }
        this.slotsToCompact.clear();
    }
}

