/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem;

public class BatteryUpgradeWrapper
extends UpgradeWrapperBase<BatteryUpgradeWrapper, BatteryUpgradeItem>
implements IRenderedBatteryUpgrade,
IEnergyStorage,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback;
    private final BatteryComponentItemHandler inventory;
    private int energyStored;

    protected BatteryUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new BatteryComponentItemHandler(upgrade);
        this.energyStored = BatteryUpgradeWrapper.getEnergyStored(upgrade);
    }

    public static int getEnergyStored(ItemStack upgrade) {
        return (Integer)upgrade.getOrDefault(ModCoreDataComponents.ENERGY_STORED, (Object)0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.innerReceiveEnergy(maxReceive, simulate);
    }

    private int innerReceiveEnergy(int maxReceive, boolean simulate) {
        int ret = Math.min(this.getMaxEnergyStored() - this.energyStored, Math.min(this.getMaxInOut(), maxReceive));
        if (!simulate) {
            this.energyStored += ret;
            this.serializeEnergyStored();
        }
        return ret;
    }

    private void serializeEnergyStored() {
        this.upgrade.set(ModCoreDataComponents.ENERGY_STORED, (Object)this.energyStored);
        this.save();
        this.forceUpdateBatteryRenderInfo();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.innerExtractEnergy(maxExtract, simulate);
    }

    private int innerExtractEnergy(int maxExtract, boolean simulate) {
        int ret = Math.min(this.energyStored, Math.min(this.getMaxInOut(), maxExtract));
        if (!simulate) {
            this.energyStored -= ret;
            this.serializeEnergyStored();
        }
        return ret;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return ((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyStored(this.storageWrapper);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    private int getMaxInOut() {
        int baseInOut;
        double stackMultiplier = ((BatteryUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper);
        return stackMultiplier > (double)(Integer.MAX_VALUE / (baseInOut = (Integer)((BatteryUpgradeItem)this.upgradeItem).getBatteryUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows())) ? Integer.MAX_VALUE : (int)((double)baseInOut * stackMultiplier);
    }

    private boolean isValidEnergyItem(ItemStack stack, boolean isOutput) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return false;
        }
        if (isOutput) {
            return energyStorage.canReceive();
        }
        return energyStorage.canExtract() && energyStorage.getEnergyStored() > 0;
    }

    @Override
    public void setBatteryRenderInfoUpdateCallback(Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateBatteryRenderInfo() {
        IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = new IRenderedBatteryUpgrade.BatteryRenderInfo(1.0f);
        batteryRenderInfo.setChargeRatio((float)this.energyStored / (float)this.getMaxEnergyStored());
        this.updateTankRenderInfoCallback.accept(batteryRenderInfo);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        ItemStack energyContainer;
        IEnergyStorage energyStorage;
        if (this.energyStored < this.getMaxEnergyStored() && (energyStorage = (IEnergyStorage)(energyContainer = this.inventory.getStackInSlot(0)).getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            this.receiveFromStorage(energyContainer, energyStorage);
        }
        if (this.energyStored > 0 && (energyStorage = (IEnergyStorage)(energyContainer = this.inventory.getStackInSlot(1)).getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            this.extractToStorage(energyContainer, energyStorage);
        }
    }

    private void extractToStorage(ItemStack energyContainer, IEnergyStorage energyStorage) {
        int toExtract = this.innerExtractEnergy(this.getMaxInOut(), true);
        if (toExtract > 0 && (toExtract = energyStorage.receiveEnergy(toExtract, true)) > 0) {
            energyStorage.receiveEnergy(toExtract, false);
            this.innerExtractEnergy(toExtract, false);
            this.inventory.setStackInSlotWithoutValidation(1, energyContainer);
        }
    }

    private void receiveFromStorage(ItemStack energyContainer, IEnergyStorage energyStorage) {
        int toReceive = this.innerReceiveEnergy(this.getMaxInOut(), true);
        if (toReceive > 0 && (toReceive = energyStorage.extractEnergy(toReceive, true)) > 0) {
            energyStorage.extractEnergy(toReceive, false);
            this.innerReceiveEnergy(toReceive, false);
            this.inventory.setStackInSlotWithoutValidation(0, energyContainer);
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.energyStored / (float)((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyBase(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private class BatteryComponentItemHandler
    extends ComponentItemHandler {
        public BatteryComponentItemHandler(ItemStack upgrade) {
            super((MutableDataComponentHolder)upgrade, DataComponents.CONTAINER, 2);
        }

        protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            super.onContentsChanged(slot, oldStack, newStack);
            BatteryUpgradeWrapper.this.save();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.isEmpty() || this.isValidInputItem(stack);
            }
            if (slot == 1) {
                return stack.isEmpty() || this.isValidOutputItem(stack);
            }
            return false;
        }

        private boolean isValidInputItem(ItemStack stack) {
            return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, false);
        }

        private boolean isValidOutputItem(ItemStack stack) {
            return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, true);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void setStackInSlotWithoutValidation(int slot, ItemStack stack) {
            super.updateContents(this.getContents(), stack, slot);
        }
    }
}

