/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public interface IUpgradeItem<T extends IUpgradeWrapper> {
    public UpgradeType<T> getType();

    default public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, ItemStack upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        UpgradeSlotChangeResult result = this.checkUpgradePerStorageTypeLimit(storageWrapper);
        if (!result.successful()) {
            return result;
        }
        result = this.checkForConflictingUpgrades(storageWrapper, this.getUpgradeConflicts(), -1);
        if (!result.successful()) {
            return result;
        }
        return this.checkExtraInsertConditions(upgradeStack, storageWrapper, isClientSide, null);
    }

    private UpgradeSlotChangeResult checkForConflictingUpgrades(IStorageWrapper storageWrapper, List<UpgradeConflictDefinition> upgradeConflicts, int excludeUpgradeSlot) {
        for (UpgradeConflictDefinition conflictDefinition : upgradeConflicts) {
            AtomicInteger conflictingCount = new AtomicInteger(0);
            HashSet<Integer> conflictingSlots = new HashSet<Integer>();
            InventoryHelper.iterate((IItemHandler)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
                if (slot != excludeUpgradeSlot && conflictDefinition.isConflictingItem.test(stack.getItem())) {
                    conflictingCount.incrementAndGet();
                    conflictingSlots.add((Integer)slot);
                }
            });
            if (conflictingCount.get() <= conflictDefinition.maxConflictingAllowed) continue;
            return UpgradeSlotChangeResult.fail(conflictDefinition.errorMessage, conflictingSlots, Set.of(), Set.of());
        }
        return UpgradeSlotChangeResult.success();
    }

    public List<UpgradeConflictDefinition> getUpgradeConflicts();

    private UpgradeSlotChangeResult checkUpgradePerStorageTypeLimit(IStorageWrapper storageWrapper) {
        int upgradesPerStorage = this.getUpgradesPerStorage(storageWrapper.getStorageType());
        int upgradesInGroupPerStorage = this.getUpgradesInGroupPerStorage(storageWrapper.getStorageType());
        if (upgradesPerStorage == Integer.MAX_VALUE && upgradesInGroupPerStorage == Integer.MAX_VALUE) {
            return UpgradeSlotChangeResult.success();
        }
        if (upgradesPerStorage == 0) {
            return UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", this.getName(), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        if (upgradesInGroupPerStorage == 0) {
            return UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", Component.translatable((String)this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUpgrade = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            if (stack.getItem() == this) {
                slotsWithUpgrade.add((Integer)slot);
            }
        });
        if (slotsWithUpgrade.size() >= upgradesPerStorage) {
            return UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesPerStorage, this.getName(), storageWrapper.getDisplayName(), upgradesPerStorage), slotsWithUpgrade, Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUgradeGroup = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            IUpgradeItem upgradeItem;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IUpgradeItem && (upgradeItem = (IUpgradeItem)patt0$temp).getUpgradeGroup() == this.getUpgradeGroup()) {
                slotsWithUgradeGroup.add((Integer)slot);
            }
        });
        if (slotsWithUgradeGroup.size() >= upgradesInGroupPerStorage) {
            return UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesInGroupPerStorage, Component.translatable((String)this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), slotsWithUgradeGroup, Set.of(), Set.of());
        }
        return UpgradeSlotChangeResult.success();
    }

    default public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        return UpgradeSlotChangeResult.success();
    }

    default public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (upgradeStackToPut.getItem() == this) {
            return UpgradeSlotChangeResult.success();
        }
        Item item = upgradeStackToPut.getItem();
        if (item instanceof IUpgradeItem) {
            UpgradeSlotChangeResult result;
            int upgradesInGroupPerStorage;
            IUpgradeItem upgradeToPut = (IUpgradeItem)item;
            int upgradesPerStorage = upgradeToPut.getUpgradesPerStorage(storageWrapper.getStorageType());
            if (upgradesPerStorage < (upgradesInGroupPerStorage = upgradeToPut.getUpgradesInGroupPerStorage(storageWrapper.getStorageType())) ? !(result = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).successful() : upgradeToPut.getUpgradeGroup() != this.getUpgradeGroup() && !(result = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).successful()) {
                return result;
            }
            result = this.checkForConflictingUpgrades(storageWrapper, upgradeToPut.getUpgradeConflicts(), upgradeSlot);
            if (!result.successful()) {
                return result;
            }
            return upgradeToPut.checkExtraInsertConditions(upgradeStackToPut, storageWrapper, isClientSide, this);
        }
        return UpgradeSlotChangeResult.success();
    }

    default public UpgradeSlotChangeResult checkExtraInsertConditions(ItemStack upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide, @Nullable IUpgradeItem<?> upgradeInSlot) {
        return UpgradeSlotChangeResult.success();
    }

    default public int getInventoryColumnsTaken() {
        return 0;
    }

    default public ItemStack getCleanedUpgradeStack(ItemStack upgradeStack) {
        return upgradeStack;
    }

    public int getUpgradesPerStorage(String var1);

    public int getUpgradesInGroupPerStorage(String var1);

    default public UpgradeGroup getUpgradeGroup() {
        return UpgradeGroup.NONE;
    }

    public Component getName();

    public record UpgradeConflictDefinition(Predicate<Item> isConflictingItem, int maxConflictingAllowed, Component errorMessage) {
    }
}

