/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public abstract class RenderInfo {
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String UPGRADE_ITEMS_TAG = "upgradeItems";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES = Map.of(CookingUpgradeRenderData.TYPE.getName(), CookingUpgradeRenderData.TYPE, JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
    private ItemDisplayRenderInfo itemDisplayRenderInfo;
    private final Supplier<Runnable> getSaveHandler;
    private final List<ItemStack> upgradeItems = new ArrayList<ItemStack>();
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private Consumer<RenderInfo> changeListener = ri -> {};

    protected RenderInfo(Supplier<Runnable> getSaveHandler) {
        this.getSaveHandler = getSaveHandler;
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo();
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public void setUpgradeItems(List<ItemStack> upgradeItems) {
        this.upgradeItems.clear();
        this.upgradeItems.addAll(upgradeItems);
        this.serializeUpgradeItems();
        this.save();
    }

    private void serializeUpgradeItems() {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag upgradeItemsTag = new ListTag();
        for (ItemStack upgradeItem : this.upgradeItems) {
            upgradeItemsTag.add((Object)RegistryHelper.getRegistryAccess().map(arg_0 -> ((ItemStack)upgradeItem).saveOptional(arg_0)).orElse((Tag)new CompoundTag()));
        }
        renderInfo.put(UPGRADE_ITEMS_TAG, (Tag)upgradeItemsTag);
        this.serializeRenderInfo(renderInfo);
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.put(upgradeRenderDataType.getName(), (Tag)renderData.serializeNBT()));
        this.save();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    private void serializeUpgradeData(Consumer<CompoundTag> modifyUpgradesTag) {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        CompoundTag upgrades = renderInfo.getCompound(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.put(UPGRADES_TAG, (Tag)upgrades);
        this.serializeRenderInfo(renderInfo);
    }

    public void refreshItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(displayItems, inaccessibleSlots);
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void setChangeListener(Consumer<RenderInfo> changeListener) {
        this.changeListener = changeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.getSaveHandler.get().run();
        if (triggerChangeListener) {
            this.changeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    protected abstract void serializeRenderInfo(CompoundTag var1);

    protected void deserialize() {
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            this.deserializeItemDisplay((CompoundTag)renderInfoTag);
            this.deserializeUpgradeItems((CompoundTag)renderInfoTag);
            this.deserializeUpgradeData((CompoundTag)renderInfoTag);
            this.deserializeTanks((CompoundTag)renderInfoTag);
            this.deserializeBattery((CompoundTag)renderInfoTag);
        });
        this.changeListener.accept(this);
    }

    private void deserializeUpgradeItems(CompoundTag renderInfoTag) {
        ListTag upgradeItemsTag = renderInfoTag.getList(UPGRADE_ITEMS_TAG, 10);
        this.upgradeItems.clear();
        RegistryHelper.getRegistryAccess().ifPresent(registryAccess -> {
            for (int i = 0; i < upgradeItemsTag.size(); ++i) {
                this.upgradeItems.add(ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)upgradeItemsTag.getCompound(i)));
            }
        });
    }

    private void deserializeItemDisplay(CompoundTag renderInfoTag) {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(renderInfoTag.getCompound(ITEM_DISPLAY_TAG));
    }

    protected abstract Optional<CompoundTag> getRenderInfoTag();

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.remove(type.getName()));
        this.save();
    }

    private void deserializeUpgradeData(CompoundTag renderInfoTag) {
        CompoundTag upgrades = renderInfoTag.getCompound(UPGRADES_TAG);
        upgrades.getAllKeys().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.getCompound(key)));
            }
        });
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag().orElse(new CompoundTag());
    }

    public void deserializeFrom(HolderLookup.Provider registries, CompoundTag renderInfoNbt) {
        this.resetUpgradeInfo(false);
        this.upgradeData.clear();
        this.serializeRenderInfo(renderInfoNbt);
        this.deserialize();
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            renderInfoTag.remove(TANKS_TAG);
            renderInfoTag.remove(BATTERY_TAG);
        });
        this.save(triggerChangeListener);
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks(CompoundTag renderInfoTag) {
        ListTag tanks = renderInfoTag.getList(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.getCompound(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.getString(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.getCompound(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery(CompoundTag renderInfoTag) {
        this.batteryRenderInfo = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag tanks = renderInfo.getList(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.getCompound(i);
            if (!tank.getString(TANK_POSITION_TAG).equals(tankPosition.getSerializedName())) continue;
            tank.put(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.putString(TANK_POSITION_TAG, tankPosition.getSerializedName());
            tankPositionInfo.put(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.put(TANKS_TAG, (Tag)tanks);
        }
        this.serializeRenderInfo(renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(BATTERY_TAG, (Tag)batteryInfo);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public List<ItemStack> getUpgradeItems() {
        return this.upgradeItems;
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEMS_TAG = "items";
        private static final String INACCESSIBLE_SLOTS_TAG = "inaccessibleSlots";
        private final List<DisplayItem> displayItems;
        private final List<Integer> inaccessibleSlots;

        private ItemDisplayRenderInfo(DisplayItem displayItem, List<Integer> inaccessibleSlots) {
            this(List.of(displayItem), inaccessibleSlots);
        }

        private ItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots) {
            this.displayItems = displayItems;
            this.inaccessibleSlots = inaccessibleSlots;
        }

        public ItemDisplayRenderInfo() {
            this(new ArrayList<DisplayItem>(), new ArrayList<Integer>());
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.displayItems.size() == 1) {
                this.displayItems.get(0).serialize(ret);
            } else if (this.displayItems.size() > 1) {
                NBTHelper.putList(ret, ITEMS_TAG, this.displayItems, displayItem -> displayItem.serialize(new CompoundTag()));
            }
            NBTHelper.putList(ret, INACCESSIBLE_SLOTS_TAG, this.inaccessibleSlots, IntTag::valueOf);
            return ret;
        }

        public static ItemDisplayRenderInfo deserialize(CompoundTag tag) {
            List inaccessibleSlots = NBTHelper.getCollection(tag, INACCESSIBLE_SLOTS_TAG, (byte)3, t -> Optional.of(((IntTag)t).getAsInt()), ArrayList::new).orElseGet(ArrayList::new);
            if (tag.contains("item")) {
                return new ItemDisplayRenderInfo(DisplayItem.deserialize(tag), (List<Integer>)inaccessibleSlots);
            }
            if (tag.contains(ITEMS_TAG)) {
                List items = NBTHelper.getCollection(tag, ITEMS_TAG, (byte)10, stackTag -> Optional.of(DisplayItem.deserialize((CompoundTag)stackTag)), ArrayList::new).orElseGet(ArrayList::new);
                return new ItemDisplayRenderInfo(items, (List<Integer>)inaccessibleSlots);
            }
            return new ItemDisplayRenderInfo();
        }

        public Optional<DisplayItem> getDisplayItem() {
            return this.isValidIndex(this.displayItems, 0) ? Optional.of(this.displayItems.get(0)) : Optional.empty();
        }

        private boolean isValidIndex(List<?> list, int index) {
            return index >= 0 && index < list.size();
        }

        public List<DisplayItem> getDisplayItems() {
            return this.displayItems;
        }

        public List<Integer> getInaccessibleSlots() {
            return this.inaccessibleSlots;
        }
    }

    public static class DisplayItem {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private static final String SLOT_INDEX_TAG = "slotIndex";
        private static final String DISPLAY_SIDE_TAG = "displaySide";
        private final ItemStack item;
        private final int rotation;
        private final int slotIndex;
        private final DisplaySide displaySide;

        public DisplayItem(ItemStack item, int rotation, int slotIndex, DisplaySide displaySide) {
            this.item = item;
            this.rotation = rotation;
            this.slotIndex = slotIndex;
            this.displaySide = displaySide;
        }

        private CompoundTag serialize(CompoundTag tag) {
            tag.put(ITEM_TAG, RegistryHelper.getRegistryAccess().map(arg_0 -> ((ItemStack)this.item).saveOptional(arg_0)).orElse((Tag)new CompoundTag()));
            tag.putInt(ROTATION_TAG, this.rotation);
            tag.putInt(SLOT_INDEX_TAG, this.slotIndex);
            tag.putString(DISPLAY_SIDE_TAG, this.displaySide.getSerializedName());
            return tag;
        }

        private static DisplayItem deserialize(CompoundTag tag) {
            return new DisplayItem(RegistryHelper.getRegistryAccess().map(registryAccess -> ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound(ITEM_TAG))).orElse(ItemStack.EMPTY), tag.getInt(ROTATION_TAG), tag.getInt(SLOT_INDEX_TAG), DisplaySide.fromName(tag.getString(DISPLAY_SIDE_TAG)));
        }

        public ItemStack getItem() {
            return this.item;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public DisplaySide getDisplaySide() {
            return this.displaySide;
        }
    }
}

