/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class CraftingContainerRecipeTransferHandlerServer {
    private CraftingContainerRecipeTransferHandlerServer() {
    }

    public static void setItems(Player player, ResourceLocation recipeId, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase container = (StorageContainerMenuBase)abstractContainerMenu;
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.getSlot(entry.getValue());
            ItemStack slotStack = slot.getItem();
            if (slotStack.isEmpty()) {
                return;
            }
            ItemStack stack = slotStack.copy();
            stack.setCount(1);
            slotMap.put(entry.getKey(), stack);
        }
        Map<Integer, ItemStack> toTransfer = CraftingContainerRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        List<ItemStack> clearedCraftingItems = CraftingContainerRecipeTransferHandlerServer.clearAndPutItemsIntoGrid(player, recipeId, craftingSlots, container, toTransfer);
        CraftingContainerRecipeTransferHandlerServer.putIntoInventory(player, inventorySlots, container, clearedCraftingItems);
        container.broadcastChanges();
    }

    private static void putIntoInventory(Player player, List<Integer> inventorySlots, StorageContainerMenuBase<?> container, List<ItemStack> clearedCraftingItems) {
        for (ItemStack oldCraftingItem : clearedCraftingItems) {
            int added = CraftingContainerRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.getCount() || player.getInventory().add(oldCraftingItem)) continue;
            player.drop(oldCraftingItem, false);
        }
    }

    private static List<ItemStack> clearAndPutItemsIntoGrid(Player player, ResourceLocation recipeId, List<Integer> craftingSlots, AbstractContainerMenu container, Map<Integer, ItemStack> toTransfer) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        int minSlotStackLimit = Integer.MAX_VALUE;
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            ItemStack transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            Slot craftingSlot = container.getSlot(craftingSlotNumber);
            if (!craftingSlot.mayPickup(player)) continue;
            if (craftingSlot.hasItem()) {
                ItemStack craftingItem = craftingSlot.remove(craftingSlot.getItem().getCount());
                clearedCraftingItems.add(craftingItem);
            }
            if ((transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.getMaxStackSize(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        CraftingContainerRecipeTransferHandlerServer.putItemIntoGrid(container, toTransfer, clearedCraftingItems, minSlotStackLimit);
        if (container instanceof StorageContainerMenuBase) {
            StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)container;
            storageContainerMenu.getOpenOrFirstCraftingContainer().ifPresent(c -> ((ICraftingContainer)((Object)c)).setRecipeUsed(recipeId));
        }
        return clearedCraftingItems;
    }

    private static void putItemIntoGrid(AbstractContainerMenu container, Map<Integer, ItemStack> toTransfer, List<ItemStack> clearedCraftingItems, int minSlotStackLimit) {
        for (Map.Entry<Integer, ItemStack> entry : toTransfer.entrySet()) {
            ItemStack stack;
            Integer craftingSlotIndex = entry.getKey();
            Slot slot = container.getSlot(craftingSlotIndex.intValue());
            if (slot.mayPlace(stack = entry.getValue())) {
                if (stack.getCount() > minSlotStackLimit) {
                    ItemStack remainder = stack.split(stack.getCount() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.set(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
    }

    private static Map<Integer, ItemStack> removeItemsFromInventory(Player player, StorageContainerMenuBase<?> container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        HashMap<Integer, ItemStack> result;
        block7: {
            boolean noItemsFound;
            result = new HashMap<Integer, ItemStack>(required.size());
            do {
                HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
                HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    ItemStack requiredStack = entry.getValue().copy();
                    Slot slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.getItem().isEmpty() && slot.mayPickup(player);
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.getCount() == resultItemStack.getMaxStackSize();
                    if (!itemFound || resultItemStackLimitReached) {
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            ItemStack stack = (ItemStack)slotEntry.getValue();
                            ((Slot)slotEntry.getKey()).set(stack);
                        }
                        break block7;
                    }
                    if (!originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.getItem().copy());
                    }
                    ItemStack removedItemStack = slot.remove(1);
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (ItemStack)entry.getValue());
                        continue;
                    }
                    resultItemStack.grow(1);
                }
            } while (maxTransfer && !noItemsFound);
        }
        return result;
    }

    @Nullable
    private static Slot getSlotWithStack(StorageContainerMenuBase<?> container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(StorageContainerMenuBase<?> container, Collection<Integer> slotIndexes, ItemStack stack) {
        Slot slot;
        ItemStack inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || (inventoryStack = (slot = container.getSlot(slotIndex)).getItem()).isEmpty() || !inventoryStack.isStackable() || !ItemStack.isSameItemSameComponents((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.getCount() - added;
            int maxStackSize = slot.getMaxStackSize(inventoryStack);
            int space = maxStackSize - inventoryStack.getCount();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.grow(remain);
                return stack.getCount();
            }
            inventoryStack.setCount(maxStackSize);
            added += space;
        }
        if (added >= stack.getCount()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !(inventoryStack = (slot = container.getSlot(slotIndex)).getItem()).isEmpty()) continue;
            ItemStack stackToAdd = stack.copy();
            stackToAdd.setCount(stack.getCount() - added);
            slot.set(stackToAdd);
            return stack.getCount();
        }
        return added;
    }

    @Nullable
    private static Slot getSlotWithStack(StorageContainerMenuBase<?> container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
        for (Integer slotNumber : slotNumbers) {
            Slot slot;
            ItemStack slotStack;
            if (slotNumber < 0 || slotNumber >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.getSlot(slotNumber)).getItem()))) continue;
            return slot;
        }
        return null;
    }

    private static int getTotalSlotsSize(StorageContainerMenuBase<?> container) {
        return container.upgradeSlots.size() + container.realInventorySlots.size();
    }
}

